/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.cash.qing.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.CashFundsTrendDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashTrendChartQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String REVERSE_ORDER = "reverseorder";
    private static final String TDA_CASHTRENDCHARTRPT = "tda_cashtrendchartrpt";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"realvalibalance", ResManager.loadKDString((String)"\u53ef\u7528\u8d44\u91d1", (String)"CashTrendChartQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"realrestrictedamt", ResManager.loadKDString((String)"\u53d7\u9650\u8d44\u91d1", (String)"CashTrendChartQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"CashTrendChartQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"showname", ResManager.loadKDString((String)"\u4e1a\u52a1\u6708\u4efd", (String)"CashTrendChartQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f\u5217", (String)"CashTrendChartQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{REVERSE_ORDER, ResManager.loadKDString((String)"\u9006\u5e8f\u6392\u5217", (String)"CashTrendChartQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return field;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(TDA_CASHTRENDCHARTRPT);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "showname";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId(TDA_CASHTRENDCHARTRPT);
        this.fireLinkageShowForm(view, param);
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet usageLimitDs = CashFundsTrendDataHelper.getFundDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, paramMap, (boolean)true).filter("isoffset = '0'");
        DataSet dateDataSet = DecisionAnlsHelper.getDateDateSet(queryDate);
        usageLimitDs = usageLimitDs.select("bizdate,realvalibalance,realrestrictedamt").groupBy(new String[]{"bizdate"}).sum("realvalibalance").sum("realrestrictedamt").finish();
        DataSet result = dateDataSet.leftJoin(usageLimitDs).on("datestring", "bizdate").select(new String[]{"showname", "sortnum"}, new String[]{"bizdate", "realvalibalance", "realrestrictedamt"}).finish().select("showname,bizdate,sortnum,case when realvalibalance is null then 0 else realvalibalance end realvalibalance,case when realrestrictedamt is null then 0 else realrestrictedamt end realrestrictedamt").orderBy(new String[]{"sortnum"});
        return this.handleDataSet(result);
    }

    private DataSet handleDataSet(DataSet ds) {
        ds = ds.addField("0", REVERSE_ORDER);
        final RowMeta rowMetas = ds.getRowMeta();
        final int[] i = new int[]{0};
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (CashTrendChartQingAnlsPlugin.REVERSE_ORDER.equals(fieldName)) {
                        int n = i[0];
                        i[0] = n - 1;
                        rowInfo.add(n);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("realvalibalance");
        fields.add("realrestrictedamt");
        return fields;
    }
}

