/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.report.ReportList;
import kd.tmc.fbp.common.enums.CashTypeEnum;
import kd.tmc.tda.common.enums.CashFinOrgTypeEnum;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CashConcentrationDetailPlugin
extends AbstractDetailDataPlugin {
    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"CashConcentrationDetailPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"fundtypevalue", ResManager.loadKDString((String)"\u5b58\u6b3e\u7c7b\u578b", (String)"CashConcentrationDetailPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(CashTypeEnum.cashTypeEnumItemList())});
        field.add(new Object[]{"ccrbillno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"CashConcentrationDetailPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankcatename", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"CashConcentrationDetailPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankname", ResManager.loadKDString((String)"\u5408\u4f5c\u91d1\u878d\u673a\u6784", (String)"CashConcentrationDetailPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"finorgtype", ResManager.loadKDString((String)"\u91d1\u878d\u673a\u6784\u7c7b\u522b", (String)"CashConcentrationDetailPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(CashFinOrgTypeEnum.finorgTypeEnumItemList())});
        field.add(new Object[]{"accountbank", ResManager.loadKDString((String)"\u5b58\u6b3e\u8d26\u6237ID", (String)"CashConcentrationDetailPlugin_28", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankaccountnumber", ResManager.loadKDString((String)"\u5b58\u6b3e\u8d26\u6237", (String)"CashConcentrationDetailPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CashConcentrationDetailPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"CashConcentrationDetailPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"isdomestic", ResManager.loadKDString((String)"\u5883\u5185\u5916", (String)"CashConcentrationDetailPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"countryname", ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a", (String)"CashConcentrationDetailPlugin_26", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"cityname", ResManager.loadKDString((String)"\u57ce\u5e02", (String)"CashConcentrationDetailPlugin_27", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"amountoriginal", ResManager.loadKDString((String)"\u5b58\u6b3e\u4f59\u989d", (String)"CashConcentrationDetailPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u5b58\u6b3e\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"CashConcentrationDetailPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realvalibalanceoriginal", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d", (String)"CashConcentrationDetailPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realvalibalance", ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"CashConcentrationDetailPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realrestrictedamtoriginal", ResManager.loadKDString((String)"\u53d7\u9650\u91d1\u989d", (String)"CashConcentrationDetailPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"realrestrictedamt", ResManager.loadKDString((String)"\u53d7\u9650\u91d1\u989d\u6298\u62a5\u544a\u5e01", (String)"CashConcentrationDetailPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u4f59\u989d\u65e5\u671f", (String)"CashConcentrationDetailPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"isoffset", ResManager.loadKDString((String)"\u62b5\u6d88\u6807\u8bc6", (String)"CashConcentrationDetailPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"collecttype", ResManager.loadKDString((String)"\u5b58\u6b3e\u8d26\u6237\u5f52\u96c6\u7c7b\u522b", (String)"CashConcentrationDetailPlugin_29", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"financeamount", ResManager.loadKDString((String)"\u8d22\u53f8\u5f52\u96c6\u8d44\u91d1", (String)"CashConcentrationDetailPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"companyamount", ResManager.loadKDString((String)"\u96c6\u56e2\u5f52\u96c6\u8d44\u91d1", (String)"CashConcentrationDetailPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"collectamount", ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u603b\u989d", (String)"CashConcentrationDetailPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"nocollectamount", ResManager.loadKDString((String)"\u672a\u5f52\u96c6\u8d44\u91d1\u4f59\u989d", (String)"CashConcentrationDetailPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"collectableamount", ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u4f59\u989d\u8d44\u91d1", (String)"CashConcentrationDetailPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"uncollectamount", ResManager.loadKDString((String)"\u4e0d\u53ef\u5f52\u96c6\u8d44\u91d1\u4f59\u989d", (String)"CashConcentrationDetailPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet ds = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIds, queryDate, paramMap, false);
        String props = "id, company orgname, company, billno ccrbillno, fundtype, fundtypevalue, bankcatename, bankname, bankaccountnumber, currencyname, rate,isdomestic, countryname, cityname, isoffset, bizdate, finorgtype, concat(accountbank,'') accountbank, '' collecttype,amount,realvalibalance,realrestrictedamt,amountoriginal,realvalibalanceoriginal,realrestrictedamtoriginal,amount isoffset_amount,financeamount, companyamount, collectamount, collectableamount, nocollectamount, uncollectamount";
        ds = ds.select(props);
        ds = ds.updateFields(new String[]{"amount", "realvalibalance", "realrestrictedamt"}, new String[]{"case when isoffset = '1' then 0.0 else amount end", "case when isoffset = '1' then 0.0 else realvalibalance end", "case when isoffset = '1' then 0.0 else realrestrictedamt end"});
        String isdomesticStr = String.format("case when isdomestic='0' then '%1$s' else '%2$s' end", ResManager.loadKDString((String)"\u5883\u5916", (String)"CashConcentrationDetailPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5883\u5185", (String)"CashConcentrationDetailPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]));
        String collectType = String.format("case when financeamount>0 then '%1$s' when companyamount>0 then '%2$s' when nocollectamount>0 then '%3$s' when uncollectamount>0 then '%4$s' else '' end", ResManager.loadKDString((String)"\u8d22\u53f8\u5f52\u96c6", (String)"CashConcentrationDetailPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u96c6\u56e2\u5f52\u96c6", (String)"CashConcentrationDetailPlugin_31", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u5f52\u96c6", (String)"CashConcentrationDetailPlugin_32", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e0d\u53ef\u5f52\u96c6", (String)"CashConcentrationDetailPlugin_33", (String)"tmc-tda-report", (Object[])new Object[0]));
        return ds.updateFields(new String[]{"isdomestic", "collecttype"}, new String[]{isdomesticStr, collectType});
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("amount", "realvalibalance", "realrestrictedamt", "isoffset_amount", "financeamount", "companyamount", "collectamount");
    }

    @Override
    protected Set<String> getCovertList() {
        return new HashSet<String>(Arrays.asList("collectableamount", "nocollectamount", "uncollectamount"));
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("ccrbillno", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String fundTypeValue = rowData.getString("fundtypevalue");
            String linkEntity = "cim_deposit";
            if (CashTypeEnum.FINANCE.getValue().equals(fundTypeValue)) {
                linkEntity = "cim_finsubscribe";
            } else if (CashTypeEnum.ACCOUNT.getValue().equals(fundTypeValue)) {
                linkEntity = "bei_bankbalance";
            } else if (CashTypeEnum.NOTICE.getValue().equals(fundTypeValue)) {
                linkEntity = "cim_noticedeposit";
            }
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    @Override
    protected List<String> getOrderByList() {
        ArrayList<String> orderList = new ArrayList<String>(2);
        orderList.add("fundtype");
        orderList.add("ccrbillno");
        return orderList;
    }
}

