/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CollFundDistByOrgDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String AMOUNT = "amount";
    private static final String FINANCE_AMOUNT = "financeamount";
    private static final String COMPANY_AMOUNT = "companyamount";
    private static final String COLLECT_AMOUNT = "collectamount";
    private static final String COLLECTABLE_AMOUNT = "collectableamount";
    private static final String NOCOLLECT_AMOUNT = "nocollectamount";
    private static final String UNCOLLECT_AMOUNT = "uncollectamount";
    private static final String IS_OFFSET = "isoffset";
    private static final String IS_DOMESTIC = "isdomestic";
    private static final String COMPANY = "company";
    private static final List<String> AMOUNT_FIELDS = Arrays.asList("amount", "financeamount", "companyamount", "collectamount", "collectableamount", "nocollectamount", "uncollectamount");
    private static final List<String> OFFSET_FIELDS = Arrays.asList("amount", "collectableamount", "nocollectamount", "uncollectamount");

    @Override
    protected DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List allOrgIds = (List)paramMap.get("allorgids");
        DataSet fundDataSet = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), allOrgIds, queryDate, paramMap, false);
        fundDataSet = fundDataSet.updateField(IS_DOMESTIC, "case when isdomestic is null then '1' else isdomestic end");
        fundDataSet = this.groupby(fundDataSet, new String[]{COMPANY, IS_OFFSET, IS_DOMESTIC});
        String areaType = (String)queryParam.getCustomParam().get("dateRange");
        if (EmptyUtil.isEmpty((String)areaType) || "2".equals(areaType)) {
            return fundDataSet;
        }
        return fundDataSet.filter("isdomestic = '" + areaType + "'");
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet[] dataSets = ds.splitByFilter(new String[]{"true", "isoffset = '1'"}, false);
        ds = this.groupby(dataSets[0], new String[]{COMPANY});
        String sumStr = String.join((CharSequence)"+", AMOUNT_FIELDS);
        ds = ds.addField(sumStr, "totalamount");
        ds = ds.filter("totalamount != 0 and totalamount != null");
        List orgIdSet = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIdSet) && orgIdSet.size() > 1) {
            orgIdSet.remove(orgId);
        }
        DataSet offsetDs = dataSets[1].filter("company in suborgids", Collections.singletonMap("suborgids", orgIdSet)).updateField(COMPANY, orgId.toString());
        offsetDs = this.groupby(offsetDs, new String[]{COMPANY});
        String[] offsetFields = DecisionAnlsHelper.getSelectField(OFFSET_FIELDS);
        offsetDs = offsetDs.leftJoin(allOrgDataSet).on(COMPANY, "orgid").select(offsetFields).finish();
        String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CollFundDistByOrgDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        offsetDs = offsetDs.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode", AMOUNT, COLLECTABLE_AMOUNT, NOCOLLECT_AMOUNT, UNCOLLECT_AMOUNT}, new String[]{'\'' + offsetName + '\'', "0", "'0'", "amount * (-1)", "collectableamount * (-1)", "nocollectamount * (-1)", "uncollectamount * (-1)"});
        offsetDs = offsetDs.addFields(new String[]{"0", "0", "0", "0", "0"}, new String[]{"allfundrate", "fundrate", FINANCE_AMOUNT, COMPANY_AMOUNT, COLLECT_AMOUNT});
        offsetDs = offsetDs.updateField(NOCOLLECT_AMOUNT, COLLECTABLE_AMOUNT);
        String[] selectFields = DecisionAnlsHelper.getSelectField(AMOUNT_FIELDS);
        DataSet dataSet = allOrgDataSet.leftJoin(ds).on("rowid", COMPANY).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(dataSet, AMOUNT_FIELDS, "orgid,mixorgname,sortcode");
        List filterOrg = (List)paramMap.get("suborgids");
        if (EmptyUtil.isEmpty((Collection)filterOrg)) {
            filterOrg = (List)paramMap.get("allorgids");
        }
        if (EmptyUtil.isNoEmpty((Object)filterOrg)) {
            sumDataSet = sumDataSet.filter("orgid in filterorg", Collections.singletonMap("filterorg", filterOrg));
        }
        sumDataSet = sumDataSet.addFields(new String[]{"case when amount is null or amount = 0 then 0.00 else collectamount/amount*100 end", "case when collectableamount is null or collectableamount = 0 then 0.00 else collectamount/collectableamount*100 end"}, new String[]{"allfundrate", "fundrate"});
        sumDataSet = sumDataSet.union(offsetDs.select(sumDataSet.getRowMeta().getFieldNames()));
        sumDataSet = sumDataSet.addField(String.valueOf(currencyId), "listcurrency");
        DataSet totalDataSet = this.addAllTotalDataSet(sumDataSet, AMOUNT_FIELDS, Collections.singletonList("listcurrency"), "orgname");
        totalDataSet = totalDataSet.updateFields(new String[]{"allfundrate", "fundrate"}, new String[]{"case when amount is null or amount = 0 then 0.00 else collectamount/amount*100 end", "case when collectableamount is null or collectableamount = 0 then 0.00 else collectamount/collectableamount*100 end"});
        return sumDataSet.union(totalDataSet);
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(AMOUNT_FIELDS);
    }

    private DataSet groupby(DataSet ds, String[] groups) {
        ds = ds.groupBy(groups).sum(AMOUNT).sum(FINANCE_AMOUNT).sum(COMPANY_AMOUNT).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).sum(NOCOLLECT_AMOUNT).sum(UNCOLLECT_AMOUNT).finish();
        return ds;
    }
}

