/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.ccr.helper.FundConcentrateTrendHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundCcrTrendDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String PREFIX = "f";
    private static final String ORGID = "orgid";
    private static final String MONTH = "month";
    private static final String IS_OFF_SET = "isoffset";
    private static final String AVG_COLLECT_AMOUNT = "avgcollectamount";
    private static final String AVG_COLLECT_ABLE_AMOUNT = "avgcollectableamount";
    private static final String COLLECT_ABLE_RATE = "collectablerate";
    private List<String> monthList;
    private List<String> monthAvgAmtFields;

    @Override
    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List orgIds = (List)paramMap.get("allorgids");
        DataSet resourceDS = FundConcentrateTrendHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIds, queryDate, baseCurrency, orgViewId);
        List<String> amtFieldName = Arrays.asList(AVG_COLLECT_AMOUNT, AVG_COLLECT_ABLE_AMOUNT);
        return DecisionAnlsHelper.ChangeMultRowToColDataSet(resourceDS, MONTH, "orgid,isoffset", PREFIX, amtFieldName);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        this.monthAvgAmtFields = new ArrayList<String>(24);
        ArrayList<String> monthRateFields = new ArrayList<String>(12);
        ArrayList<String> monthRateExpr = new ArrayList<String>(12);
        this.monthList = this.getNeedMonth(queryDate, this.monthAvgAmtFields, monthRateFields, monthRateExpr);
        DataSet dataSet = this.dealDsEmptyCol(ds);
        String[] selectFields = DecisionAnlsHelper.getSelectField(this.monthAvgAmtFields);
        List orgIdSet = (List)paramMap.get("allorgids");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        if (!EmptyUtil.isEmpty((Collection)orgIdSet) && orgIdSet.size() > 1) {
            orgIdSet.remove(orgId);
        }
        DataSet offsetDs = dataSet.filter("isoffset='1'").filter("orgid in suborgids", Collections.singletonMap("suborgids", orgIdSet)).updateField(ORGID, orgId.toString());
        offsetDs = this.groupToSum(offsetDs, new String[]{ORGID});
        offsetDs = offsetDs.leftJoin(orgDateSet.copy()).on(ORGID, ORGID).select(selectFields).finish();
        String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"FundCcrTrendDataListPlugin_00", (String)"tmc-tda-report", (Object[])new Object[0]);
        offsetDs = offsetDs.updateFields(new String[]{"mixorgname", "sumlevel", "isgroupnode"}, new String[]{'\'' + offsetName + '\'', "0", "'0'"});
        ArrayList<String> offsetAmtExpr = new ArrayList<String>(this.monthAvgAmtFields.size());
        for (String oaf : this.monthAvgAmtFields) {
            if (oaf.endsWith(AVG_COLLECT_AMOUNT)) {
                offsetAmtExpr.add("0.0");
                continue;
            }
            if (!oaf.endsWith(AVG_COLLECT_ABLE_AMOUNT)) continue;
            offsetAmtExpr.add(oaf + " * (-1)");
        }
        offsetDs = offsetDs.updateFields(this.monthAvgAmtFields.toArray(new String[0]), offsetAmtExpr.toArray(new String[0]));
        offsetDs = offsetDs.addNullField(monthRateFields.toArray(new String[0]));
        DataSet allDs = this.groupToSum(dataSet, new String[]{ORGID});
        DataSet allOrgDs = orgDateSet.leftJoin(allDs).on(ORGID, ORGID).select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(allOrgDs, this.monthAvgAmtFields, "orgid,mixorgname,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        if (kd.bos.entity.plugin.support.util.CollectionUtils.isEmpty((Collection)subOrgIds)) {
            subOrgIds = (List)paramMap.get("allorgids");
        }
        sumDataSet = sumDataSet.filter("rowid in suborgids", Collections.singletonMap("suborgids", subOrgIds)).orderBy(new String[]{"sortcode"});
        sumDataSet = sumDataSet.addFields(monthRateExpr.toArray(new String[0]), monthRateFields.toArray(new String[0]));
        String[] fieldNames = offsetDs.getRowMeta().getFieldNames();
        sumDataSet = sumDataSet.select(fieldNames).union(offsetDs);
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, this.monthAvgAmtFields, "mixorgname");
        totalDataSet = totalDataSet.updateFields(monthRateFields.toArray(new String[0]), monthRateExpr.toArray(new String[0]));
        return sumDataSet.union(totalDataSet);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        for (String month : this.monthList) {
            ReportColumnGroup group = new ReportColumnGroup();
            group.setHideSingleColumnRow(false);
            group.setFieldKey(month);
            group.setCaption(new LocaleString(month));
            this.addChildren(group, month);
            columns.add((AbstractReportColumn)group);
        }
        return columns;
    }

    private void addChildren(ReportColumnGroup group, String typeName) {
        FundConcentrateTrendHelper.buildReportColumn(group, PREFIX + typeName + AVG_COLLECT_AMOUNT, ResManager.loadKDString((String)"\u65e5\u5747\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrTrendQingAnlsPlugin_01", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal");
        FundConcentrateTrendHelper.buildReportColumn(group, PREFIX + typeName + AVG_COLLECT_ABLE_AMOUNT, ResManager.loadKDString((String)"\u65e5\u5747\u53ef\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrTrendQingAnlsPlugin_02", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal");
        FundConcentrateTrendHelper.buildReportColumn(group, PREFIX + typeName + COLLECT_ABLE_RATE, ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundCcrTrendQingAnlsPlugin_03", (String)"tmc-tda-report", (Object[])new Object[0]), "text");
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.monthAvgAmtFields);
    }

    private List<String> getNeedMonth(Date queryDate, List<String> monthAvgAmtFields, List<String> monthRateFields, List<String> monthRateExpr) {
        ArrayList<String> result = new ArrayList<String>(12);
        for (int i = 0; i < 12; ++i) {
            Date date = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)(-(i + 1)));
            String yyyyMMStr = DateUtils.formatString((Date)date, (String)"yyyyMM");
            result.add(yyyyMMStr);
            String avgMonthAmt = PREFIX + yyyyMMStr + AVG_COLLECT_AMOUNT;
            String avgMonthAbleAmt = PREFIX + yyyyMMStr + AVG_COLLECT_ABLE_AMOUNT;
            String avgMonthRate = PREFIX + yyyyMMStr + COLLECT_ABLE_RATE;
            monthAvgAmtFields.add(avgMonthAmt);
            monthAvgAmtFields.add(avgMonthAbleAmt);
            monthRateFields.add(avgMonthRate);
            String rateStr = String.format("case when (%1$s is null or %1$s=0) then 0.00 else round((%2$s/%1$s)*100, 2) end", avgMonthAbleAmt, avgMonthAmt);
            String rateExpr = "concat(" + rateStr + ", '%')";
            monthRateExpr.add(rateExpr);
        }
        return result;
    }

    private DataSet dealDsEmptyCol(DataSet sourceDs) {
        String[] fieldNameArr;
        ArrayList<String> tempList = new ArrayList<String>(24);
        tempList.addAll(this.monthAvgAmtFields);
        for (String fieldName : fieldNameArr = sourceDs.getRowMeta().getFieldNames()) {
            if (!fieldName.endsWith(AVG_COLLECT_AMOUNT) && !fieldName.endsWith(AVG_COLLECT_ABLE_AMOUNT)) continue;
            tempList.remove(fieldName);
        }
        if (CollectionUtils.isNotEmpty(tempList)) {
            String[] exprArr = new String[tempList.size()];
            for (int i = 0; i < tempList.size(); ++i) {
                exprArr[i] = "0.0";
            }
            sourceDs = sourceDs.addFields(exprArr, tempList.toArray(new String[0]));
        }
        return sourceDs;
    }

    private DataSet groupToSum(DataSet ds, String[] groups) {
        GroupbyDataSet groupByDS = ds.groupBy(groups);
        for (String month : this.monthList) {
            groupByDS.sum(PREFIX + month + AVG_COLLECT_AMOUNT).sum(PREFIX + month + AVG_COLLECT_ABLE_AMOUNT);
        }
        return groupByDS.finish();
    }
}

