/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.helper;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.tmc.fbp.common.util.DateUtils;

public class FinsubscribeRedeem {
    private String algoKey;
    private DataSet finsubscribeDs;
    private DataSet redeemDs;
    private Date[] rangeDates;
    private String[] EXTRA_FIELD_NAMES = new String[]{"bizdate"};
    private DataType[] EXTRA_DATA_TYPES = new DataType[]{DataType.DateType};

    public FinsubscribeRedeem(String algoKey, DataSet finsubscribeDs, DataSet redeemDs, Date[] rangeDates) {
        this.algoKey = algoKey;
        this.finsubscribeDs = finsubscribeDs;
        this.redeemDs = redeemDs;
        this.rangeDates = rangeDates;
    }

    public DataSet join() {
        if (this.rangeDates == null) {
            return this.finsubscribeDs;
        }
        if (this.rangeDates.length == 1) {
            Date queryDate = this.rangeDates[0];
            return FinsubscribeRedeem.joinRedeem(this.finsubscribeDs, this.redeemDs, queryDate);
        }
        DataSet depositFilterDs = this.handleDeposit(this.finsubscribeDs, this.rangeDates);
        DataSet releaseFilterDs = this.handleRelease(this.redeemDs, this.rangeDates);
        return FinsubscribeRedeem.joinRedeemOnPeriod(depositFilterDs, releaseFilterDs);
    }

    private static DataSet joinRedeem(DataSet finsubscribeDs, DataSet redeemDs, Date queryDate) {
        redeemDs = redeemDs.groupBy(new String[]{"finbillno"}).sum("copies").sum("redeemamount").finish();
        DataSet ds = finsubscribeDs.leftJoin(redeemDs).on("id", "finbillno").select(finsubscribeDs.getRowMeta().getFieldNames(), new String[]{"copies", "redeemamount"}).finish();
        ds = ds.updateFields(new String[]{"iopv", "copies", "redeemamount"}, new String[]{"case when iopv is null then 0.0 else iopv end", "case when copies is null then 0.0 else copies end", "case when redeemamount is null then 0.0 else redeemamount end"});
        return ds.updateField("amount", "case when redeemway='copies_redeem' then amount-(copies*iopv) when redeemway='amount_redeem' then amount-redeemamount else amount end").removeFields(new String[]{"copies", "redeemamount"}).addField("to_date('" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + "', 'yy-MM-dd')", "bizdate");
    }

    private static DataSet joinRedeemOnPeriod(DataSet finsubscribeDs, DataSet redeemDs) {
        redeemDs = redeemDs.groupBy(new String[]{"finbillno", "bizdate"}).sum("copies").sum("redeemamount").finish();
        DataSet ds = finsubscribeDs.leftJoin(redeemDs).on("id", "finbillno").on("bizdate", "bizdate").select(finsubscribeDs.getRowMeta().getFieldNames(), new String[]{"copies", "redeemamount"}).finish();
        ds = ds.updateFields(new String[]{"iopv", "copies", "redeemamount"}, new String[]{"case when iopv is null then 0.0 else iopv end", "case when copies is null then 0.0 else copies end", "case when redeemamount is null then 0.0 else redeemamount end"});
        return ds.updateField("amount", "case when redeemway='copies_redeem' then amount-(copies*iopv) when redeemway='amount_redeem' then amount-redeemamount else amount end").removeFields(new String[]{"copies", "redeemamount"});
    }

    private DataSet handleDeposit(DataSet depositDs, Date[] rangeDates) {
        RowMeta builderMeta = this.builderMeta(depositDs);
        String[] fieldNames = depositDs.getRowMeta().getFieldNames();
        DataSetBuilder builder = Algo.create((String)(this.algoKey + ".handleFinsubscribePeriod")).createDataSetBuilder(builderMeta);
        for (Row row : depositDs) {
            this.handleDeposit(rangeDates, fieldNames, builder, row);
        }
        return builder.build();
    }

    private void handleDeposit(Date[] rangeDates, String[] fieldNames, DataSetBuilder builder, Row row) {
        for (int i = 0; i < rangeDates.length; ++i) {
            boolean isContain;
            Date bizDate = rangeDates[i];
            Date clearDate = (Date)row.get("cleardate");
            Date intDate = (Date)row.get("valuedate");
            boolean bl = isContain = (clearDate == null || clearDate.after(bizDate)) && intDate.compareTo(bizDate) <= 0;
            if (!isContain) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + this.EXTRA_FIELD_NAMES.length);
            for (int j = 0; j < fieldNames.length; ++j) {
                String fieldName = fieldNames[j];
                appendRow.add(row.get(fieldName));
            }
            appendRow.add(bizDate);
            builder.append(appendRow.toArray());
        }
    }

    private DataSet handleRelease(DataSet releaseDs, Date[] rangeDates) {
        RowMeta builderMeta = this.builderMeta(releaseDs);
        String[] fieldNames = releaseDs.getRowMeta().getFieldNames();
        DataSetBuilder builder = Algo.create((String)(this.algoKey + ".handleRedeemPeriod")).createDataSetBuilder(builderMeta);
        for (Row row : releaseDs) {
            this.handleRelease(rangeDates, fieldNames, builder, row);
        }
        return builder.build();
    }

    private void handleRelease(Date[] rangeDates, String[] fieldNames, DataSetBuilder builder, Row row) {
        for (int i = 0; i < rangeDates.length; ++i) {
            boolean isContain;
            Date bizDate = rangeDates[i];
            Date redeemDate = (Date)row.get("redeemdate");
            boolean bl = isContain = bizDate.compareTo(redeemDate) >= 0;
            if (!isContain) continue;
            ArrayList<Object> appendRow = new ArrayList<Object>(fieldNames.length + this.EXTRA_FIELD_NAMES.length);
            for (int j = 0; j < fieldNames.length; ++j) {
                String fieldName = fieldNames[j];
                appendRow.add(row.get(fieldName));
            }
            appendRow.add(bizDate);
            builder.append(appendRow.toArray());
        }
    }

    private RowMeta builderMeta(DataSet ds) {
        DataType[] dataTypes = ds.getRowMeta().getDataTypes();
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        String[] newFieldNames = new String[fieldNames.length + this.EXTRA_FIELD_NAMES.length];
        DataType[] newDataTypes = new DataType[dataTypes.length + this.EXTRA_DATA_TYPES.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(this.EXTRA_FIELD_NAMES, 0, newFieldNames, fieldNames.length, this.EXTRA_FIELD_NAMES.length);
        System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
        System.arraycopy(this.EXTRA_DATA_TYPES, 0, newDataTypes, dataTypes.length, this.EXTRA_DATA_TYPES.length);
        return RowMetaFactory.createRowMeta((String[])newFieldNames, (DataType[])newDataTypes);
    }
}

