/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DraftBillUpdateFieldFunction;
import kd.tmc.tda.common.helper.TdaCommonHelper;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class AvgFundDistByOrgQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{"mixorgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"AvgFundDistByOrgQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"collectamount", ResManager.loadKDString((String)"\u5df2\u5f52\u96c6\u8d44\u91d1", (String)"AvgFundDistByOrgQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"nocollectamount", ResManager.loadKDString((String)"\u672a\u5f52\u96c6\u8d44\u91d1", (String)"AvgFundDistByOrgQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"isdomestic", ResManager.loadKDString((String)"\u5883\u5185\u5916\u6807\u8bc6", (String)"AvgFundDistByOrgQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"area", ResManager.loadKDString((String)"\u5883\u5185\u5916\u540d\u79f0", (String)"AvgFundDistByOrgQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"displaytype", ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"AvgFundDistByOrgQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DynamicObject orgObject = (DynamicObject)paramMap.get("org");
        Long currentOrgId = orgObject.getLong("id");
        String orgName = EmptyUtil.isEmpty((String)orgObject.getString("simplename")) ? orgObject.getString("name") : orgObject.getString("simplename");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List<Long> orgIds = this.getOrgIds(paramMap);
        DataSet fundDataSet = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIds, queryDate, paramMap, true);
        if (orgIds.size() == 1) {
            fundDataSet = fundDataSet.groupBy(new String[]{"isdomestic", "term"}).sum("collectamount").sum("nocollectamount").finish().addField("'" + orgName + "'", "mixorgname");
        } else {
            fundDataSet = fundDataSet.groupBy(new String[]{"company", "isdomestic", "term"}).sum("collectamount").sum("nocollectamount").finish();
            DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
            fundDataSet = orgDateSet.copy().leftJoin(fundDataSet).on("orgid", "company").select(new String[]{"longnumber", "level", "isdomestic", "term", "collectamount", "nocollectamount"}).finish();
            fundDataSet = fundDataSet.filter("term is not null");
            Integer level = orgDateSet.copy().filter("orgid = " + currentOrgId).next().getInteger("level");
            fundDataSet = fundDataSet.filter("level > " + level);
            fundDataSet = DraftBillUpdateFieldFunction.updateFields((DataSet)fundDataSet, (DraftBillUpdateFieldFunction[])new DraftBillUpdateFieldFunction[]{DraftBillUpdateFieldFunction.orgLongNumberUpdateFunction((Integer)(level + 1))});
            fundDataSet = fundDataSet.groupBy(new String[]{"longnumber", "isdomestic", "term"}).sum("collectamount").sum("nocollectamount").finish();
            orgDateSet = orgDateSet.filter("level = " + (level + 1));
            fundDataSet = fundDataSet.leftJoin(orgDateSet).on("longnumber", "longnumber").select(new String[]{"mixorgname", "isdomestic", "term", "collectamount", "nocollectamount"}).finish();
        }
        fundDataSet = fundDataSet.updateField("isdomestic", "case when isdomestic is null then '1' else isdomestic end");
        fundDataSet = fundDataSet.groupBy(new String[]{"mixorgname", "isdomestic", "term"}).sum("collectamount").sum("nocollectamount").finish();
        fundDataSet = fundDataSet.filter("collectamount > 0 or nocollectamount > 0");
        DataSet[] copys = DataSetHelper.copy((DataSet)fundDataSet);
        fundDataSet = copys[0];
        DataSet allFundDataSet = copys[1];
        allFundDataSet = allFundDataSet.groupBy(new String[]{"mixorgname", "term"}).sum("collectamount").sum("nocollectamount").finish();
        allFundDataSet = allFundDataSet.addField("'2'", "isdomestic");
        fundDataSet = fundDataSet.union(allFundDataSet.select(new String[]{"mixorgname", "isdomestic", "term", "collectamount", "nocollectamount"}));
        fundDataSet = fundDataSet.addField("concat(isdomestic,'_',term)", "displaytype");
        return this.addPullDownField(fundDataSet);
    }

    private DataSet addPullDownField(DataSet dataSet) {
        dataSet = dataSet.addField("case when isdomestic = '0' then '" + this.getMulText(0) + "' when isdomestic = '1' then '" + this.getMulText(1) + "' else '" + this.getMulText(2) + "' end", "area");
        return dataSet;
    }

    private String getMulText(int areaType) {
        if (0 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5916", (String)"FundConcentrationQingPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        if (1 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5185", (String)"FundConcentrationQingPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"FundConcentrationQingPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        Pair typeLinkValue = TdaCommonHelper.getTypeLinkValue((IPageCache)this.getPageCache(), filterParam, (String)"ccrtermtype", (String)"ccrdate");
        String term = (String)typeLinkValue.getValue1();
        if (EmptyUtil.isNoEmpty((String)term)) {
            String filter = "term = '" + term + "'";
            return ds.filter(filter);
        }
        return ds;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("collectamount");
        fields.add("nocollectamount");
        return fields;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_collfundtotalamtrpt");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_collfundtotalamtrpt");
        parameter.setCaption(ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u5355\u4f4d\u5206\u5e03\u8868-\u65f6\u671f", (String)"AvgFundDistByOrgQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]));
        parameter.getCustomParams().put("ccrdate", ids.get(0).split("_")[1]);
        parameter.getCustomParams().put("isdomestic", ids.get(0).split("_")[0]);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "displaytype";
    }
}

