/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.qing.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CollFundDistByOrgQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AREA_TYPE_NAME = "areatypename";
    private static final String AREA_TYPE = "areatype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"CollFundDistByOrgQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"collectamount", ResManager.loadKDString((String)"\u5df2\u5f52\u96c6\u8d44\u91d1", (String)"CollFundDistByOrgQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"nocollectamount", ResManager.loadKDString((String)"\u672a\u5f52\u96c6\u8d44\u91d1", (String)"CollFundDistByOrgQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AREA_TYPE, ResManager.loadKDString((String)"\u533a\u57df\u7c7b\u578b", (String)"CollFundDistByOrgQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AREA_TYPE_NAME, ResManager.loadKDString((String)"\u533a\u57df\u7c7b\u578b\u540d\u79f0", (String)"CollFundDistByOrgQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List<Long> orgIds = this.getOrgIds(paramMap);
        DataSet fundDataSet = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIds, queryDate, paramMap, false).filter("collectamount > 0 or nocollectamount > 0");
        fundDataSet = fundDataSet.updateField("isdomestic", "case when isdomestic is null then '1' else isdomestic end");
        fundDataSet = fundDataSet.groupBy(new String[]{"company", "isdomestic"}).sum("collectamount").sum("nocollectamount").finish();
        DataSet[] dataSets = fundDataSet.splitByFilter(new String[]{"isdomestic = '1'", "isdomestic = '0'"}, true);
        DataSet domesticDs = dataSets[0];
        DataSet overseasDs = dataSets[1];
        domesticDs = this.sumDataSet(domesticDs, orgIds, orgViewId, currentOrgId);
        overseasDs = this.sumDataSet(overseasDs, orgIds, orgViewId, currentOrgId);
        DataSet allDs = domesticDs.union(overseasDs);
        String domestic = ResManager.loadKDString((String)"\u5883\u5185", (String)"CollFundDistByOrgQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
        String overseas = ResManager.loadKDString((String)"\u5883\u5916", (String)"CollFundDistByOrgQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        String allType = ResManager.loadKDString((String)"\u5168\u90e8", (String)"CollFundDistByOrgQingAnlsPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        allDs = allDs.addFields(new String[]{"'" + allType + "'", "2"}, new String[]{AREA_TYPE_NAME, AREA_TYPE});
        domesticDs = domesticDs.addFields(new String[]{"'" + domestic + "'", "1"}, new String[]{AREA_TYPE_NAME, AREA_TYPE});
        overseasDs = overseasDs.addFields(new String[]{"'" + overseas + "'", "0"}, new String[]{AREA_TYPE_NAME, AREA_TYPE});
        return allDs.union(new DataSet[]{overseasDs, domesticDs});
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add("collectamount");
        fields.add("nocollectamount");
        return fields;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_collfunddistbyorgrpt");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.getCustomParams().put("dateRange", ids.get(0));
        parameter.setFormId("tda_collfunddistbyorgrpt");
        parameter.setCaption(ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u5355\u4f4d\u5206\u5e03\u8868-\u65f6\u70b9", (String)"CollFundDistByOrgQingAnlsPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return AREA_TYPE;
    }

    private DataSet sumDataSet(DataSet fundDataSet, List<Long> orgIds, Long orgViewId, Long currentOrgId) {
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> sumFields = this.getSumField();
        String[] selectFields = DecisionAnlsHelper.getSelectField(sumFields);
        selectFields[0] = "mixorgname as orgname";
        fundDataSet = allOrgDataSet.leftJoin(fundDataSet).on("rowid", "company").select(selectFields).finish();
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(fundDataSet, sumFields, "orgid,orgname,");
        List<Long> secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)currentOrgId, (boolean)true);
        List<Long> subOrgIds = EmptyUtil.isNoEmpty((Object)secondOrgIds) ? secondOrgIds : orgIds;
        if (CollectionUtils.isNotEmpty(subOrgIds)) {
            sumDataSet = sumDataSet.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds));
        }
        return sumDataSet.filter("collectamount > 0 or nocollectamount > 0");
    }

    private List<String> getSumField() {
        ArrayList<String> fields = new ArrayList<String>(2);
        fields.add("collectamount");
        fields.add("nocollectamount");
        return fields;
    }
}

