/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundCcrAnlsByPeriodQingPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String AREANUMBER = "areanumber";
    private static final String AREA = "area";
    private static final String COLLECTAMOUNT = "collectamount";
    private static final String FINANCEAMOUNT = "financeamount";
    private static final String COMPANYAMOUNT = "companyamount";
    private static final String AMOUNT = "amount";
    private static final String COLLECTABLEAMOUNT = "collectableamount";
    private static final String ISDOMESTIC = "isdomestic";
    private static final String COLLECTABLERATE = "collectablerate";
    private static final String ALLRATE = "allrate";
    public static final String TERM = "term";
    private static final String DISPLAYTYPE = "displaytype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{AREANUMBER, ResManager.loadKDString((String)"\u533a\u57df\u7f16\u7801", (String)"FundCcrAnlsByPointQingPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{AREA, ResManager.loadKDString((String)"\u533a\u57df", (String)"FundConcentrationQingPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{COLLECTAMOUNT, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u603b\u989d", (String)"FundCcrAnlsByPointQingPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{FINANCEAMOUNT, ResManager.loadKDString((String)"\u8d22\u53f8\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrAnlsByPointQingPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{COMPANYAMOUNT, ResManager.loadKDString((String)"\u96c6\u56e2\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrAnlsByPointQingPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{COLLECTABLERATE, ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundCcrAnlsByPointQingPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{ALLRATE, ResManager.loadKDString((String)"\u5168\u53e3\u5f84\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundCcrAnlsByPointQingPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{DISPLAYTYPE, ResManager.loadKDString((String)"\u7a7f\u900f\u5b57\u6bb5", (String)"AvgFundDistByOrgQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        DataSet ds = CashConcentrationDataHelper.getFundDataSet("FundCcrAnlsByPeriodQingPlugin", (List)paramMap.get("allorgids"), DecisionAnlsHelper.getQueryDate(paramMap), paramMap, true);
        ds = ds.updateFields(new String[]{ISDOMESTIC, AMOUNT, COLLECTABLEAMOUNT}, new String[]{"case when isdomestic is null then '1' else isdomestic end", "case when isoffset = '1' then 0.0 else amount end", "case when isoffset = '1' then 0.0 else collectableamount end"});
        ds = ds.select(new String[]{TERM, ISDOMESTIC, COLLECTAMOUNT, FINANCEAMOUNT, COMPANYAMOUNT, AMOUNT, COLLECTABLEAMOUNT});
        return ds.groupBy(new String[]{TERM, ISDOMESTIC}).sum(COLLECTAMOUNT).sum(FINANCEAMOUNT).sum(COMPANYAMOUNT).sum(AMOUNT).sum(COLLECTABLEAMOUNT).finish();
    }

    private DataSet addPullDownField(DataSet dataSet) {
        dataSet = dataSet.addField("case when areanumber = '0' then '" + this.getMulText(0) + "' when areanumber = '1' then '" + this.getMulText(1) + "' else '" + this.getMulText(2) + "' end", AREA);
        return dataSet;
    }

    private String getMulText(int areaType) {
        if (0 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5916", (String)"FundConcentrationQingPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        if (1 == areaType) {
            return ResManager.loadKDString((String)"\u5883\u5185", (String)"FundConcentrationQingPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u5168\u90e8", (String)"FundConcentrationQingPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, Map<String, Object> filterParam) {
        String filter = CashConcentrationDataHelper.getFilterStringFromPageCache(this.getPageCache(), filterParam);
        ds = ds.filter(filter);
        return this.handle(ds);
    }

    private DataSet handle(DataSet ds) {
        DataSet[] dataSets = ds.splitByFilter(new String[]{"true", "true"}, false);
        DataSet allAreaSet = dataSets[0].groupBy(new String[]{TERM}).sum(COLLECTAMOUNT).sum(FINANCEAMOUNT).sum(COMPANYAMOUNT).sum(AMOUNT).sum(COLLECTABLEAMOUNT).finish().addField("'2'", AREANUMBER);
        ds = dataSets[1].addField(ISDOMESTIC, AREANUMBER).select(allAreaSet.getRowMeta().getFieldNames()).union(allAreaSet);
        String s1 = "case when collectableamount is null or collectableamount = 0 then 0.0 else (collectamount * 100 / collectableamount) end";
        String s2 = "case when amount is null or amount = 0 then 0.0 else (collectamount * 100 / amount) end";
        ds = ds.addFields(new String[]{s1, s2, "concat(areanumber,'_',term)"}, new String[]{COLLECTABLERATE, ALLRATE, DISPLAYTYPE});
        return this.addPullDownField(ds);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_collfundtotalamtrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return DISPLAYTYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_collfundtotalamtrpt");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u65e5\u5747\u5f52\u96c6\u8d44\u91d1\u603b\u989d\u8868", (String)"FundCcrAnlsByPeriodQingPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
        showParameter.getCustomParams().put("ccrdate", ids.get(0).split("_")[1]);
        showParameter.getCustomParams().put(ISDOMESTIC, ids.get(0).split("_")[0]);
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(Arrays.asList(COLLECTAMOUNT, FINANCEAMOUNT, COMPANYAMOUNT));
    }
}

