/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.qing.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.report.ccr.helper.FundConcentrateTrendHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundCcrTrendQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String MONTH = "month";
    private static final String AVG_COLLECT_AMOUNT = "avgcollectamount";
    private static final String AVG_COLLECT_ABLE_AMOUNT = "avgcollectableamount";
    private static final String COLLECT_ABLE_RATE = "collectablerate";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{MONTH, ResManager.loadKDString((String)"\u6708\u4efd", (String)"FundCcrTrendQingAnlsPlugin_00", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{AVG_COLLECT_AMOUNT, ResManager.loadKDString((String)"\u65e5\u5747\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrTrendQingAnlsPlugin_01", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AVG_COLLECT_ABLE_AMOUNT, ResManager.loadKDString((String)"\u65e5\u5747\u53ef\u5f52\u96c6\u8d44\u91d1", (String)"FundCcrTrendQingAnlsPlugin_02", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{COLLECT_ABLE_RATE, ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u8d44\u91d1\u96c6\u4e2d\u5ea6", (String)"FundCcrTrendQingAnlsPlugin_03", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List<Long> orgIds = this.getOrgIds(paramMap);
        DataSet resourceDs = FundConcentrateTrendHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIds, queryDate, baseCurrency, orgViewId);
        resourceDs = resourceDs.updateField(AVG_COLLECT_ABLE_AMOUNT, "case when isoffset = '1' then 0.0 else avgcollectableamount end");
        resourceDs = resourceDs.groupBy(new String[]{MONTH}).sum(AVG_COLLECT_AMOUNT).sum(AVG_COLLECT_ABLE_AMOUNT).finish();
        String collectAbleRateExpr = "case when avgcollectableamount = 0.0 then 0.00 else (avgcollectamount / avgcollectableamount) * 100 end as collectablerate";
        resourceDs = resourceDs.select(new String[]{MONTH, AVG_COLLECT_AMOUNT, AVG_COLLECT_ABLE_AMOUNT, collectAbleRateExpr});
        List<String> needMonthList = this.getNeedMonth(queryDate);
        resourceDs = DecisionAnlsHelper.creatAbsentRow(resourceDs, MONTH, needMonthList, 0, () -> new Object[]{"", 0.0, 0.0, 0.0});
        return resourceDs.orderBy(new String[]{MONTH});
    }

    @Override
    protected Set<String> getAmountFields() {
        return Stream.of(AVG_COLLECT_AMOUNT, AVG_COLLECT_ABLE_AMOUNT).collect(Collectors.toSet());
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_fundccrtrendrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return MONTH;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId("tda_fundccrtrendrpt");
        this.fireLinkageShowForm(view, param);
    }

    private List<String> getNeedMonth(Date queryDate) {
        ArrayList<String> result = new ArrayList<String>(12);
        for (int i = 1; i <= 12; ++i) {
            Date date = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)(-i));
            String yyyyMMStr = DateUtils.formatString((Date)date, (String)"yyyyMM");
            result.add(yyyyMMStr);
        }
        return result;
    }
}

