/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.ccr.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.ccr.helper.CashConcentrationDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FundDistByAreaQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String COLLECT_AMOUNT = "collectamount";
    private static final String COLLECTABLE_AMOUNT = "collectableamount";
    private static final String AREA = "area";
    private static final String AREA_TYPE = "areatype";
    private static final String AREA_TYPE_NAME = "areatypename";
    private static final String FUND_RATIO = "colfundratio";
    private static final String FUND_CON_RATIO = "colfundconratio";
    private static final int TOP_NUMBER = 10;
    private static final String ISOFFSET = "isoffset";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{COLLECT_AMOUNT, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1", (String)"FundDistByAreaQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AREA, ResManager.loadKDString((String)"\u533a\u57df", (String)"FundDistByAreaQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{AREA_TYPE, ResManager.loadKDString((String)"\u533a\u57df\u7c7b\u578b", (String)"FundDistByAreaQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AREA_TYPE_NAME, ResManager.loadKDString((String)"\u533a\u57df\u7c7b\u578b\u540d\u79f0", (String)"FundDistByAreaQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{FUND_RATIO, ResManager.loadKDString((String)"\u5f52\u96c6\u8d44\u91d1\u5360\u6bd4", (String)"FundDistByAreaQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{FUND_CON_RATIO, ResManager.loadKDString((String)"\u53ef\u5f52\u96c6\u96c6\u4e2d\u5ea6", (String)"FundDistByAreaQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"InvestBankAmtQingAnlsPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        BigDecimal totalCollectAmt;
        List<Long> orgIdSet = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet fundDataSet = CashConcentrationDataHelper.getFundDataSet(((Object)((Object)this)).getClass().getName(), orgIdSet, queryDate, paramMap, false).select("collectamount, collectableamount, countryname, cityname, isoffset");
        fundDataSet = fundDataSet.filter("collectableamount > 0");
        fundDataSet = fundDataSet.updateField(COLLECTABLE_AMOUNT, "case when isoffset = '1' then 0.0 else collectableamount end");
        DataSet[] dataSets = DataSetHelper.copy((DataSet)(fundDataSet = fundDataSet.groupBy(new String[]{"countryname", "cityname"}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish()), (int)3);
        DataSet sumSet = dataSets[0].groupBy().sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish();
        if (sumSet.hasNext()) {
            Row next = sumSet.next();
            totalCollectAmt = next.getBigDecimal(COLLECT_AMOUNT);
            if (EmptyUtil.isEmpty((BigDecimal)totalCollectAmt)) {
                return this.createEmptySet();
            }
        } else {
            return this.createEmptySet();
        }
        String countryStr = ResManager.loadKDString((String)"\u6309\u56fd\u5bb6", (String)"FundDistByAreaQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        String cityStr = ResManager.loadKDString((String)"\u6309\u57ce\u5e02", (String)"FundDistByAreaQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        String country = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"FundDistByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet countrySet = dataSets[1].select("case when countryname is null then '" + country + "' else countryname end area, collectamount, collectableamount").groupBy(new String[]{AREA}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish().orderBy(new String[]{"collectamount desc"}).top(10);
        countrySet = countrySet.addFields(new String[]{"case when collectamount is null or collectamount = 0 then 0.00 else collectamount/" + totalCollectAmt + "* 100 end", "case when collectamount is null or collectamount = 0 or collectableamount = 0 then 0.00 else collectamount/collectableamount * 100 end", "0", "'" + countryStr + "'"}, new String[]{FUND_RATIO, FUND_CON_RATIO, AREA_TYPE, AREA_TYPE_NAME});
        String otherCity = ResManager.loadKDString((String)"\u5176\u4ed6\u57ce\u5e02", (String)"FundDistByAreaDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet citySet = dataSets[2].select("case when cityname is null then '" + otherCity + "' else cityname end area, collectamount, collectableamount").groupBy(new String[]{AREA}).sum(COLLECT_AMOUNT).sum(COLLECTABLE_AMOUNT).finish().orderBy(new String[]{"collectamount desc"}).top(10);
        citySet = citySet.addFields(new String[]{"case when collectamount is null or collectamount = 0 then 0.00 else collectamount / " + totalCollectAmt + "*100 end", "case when collectamount is null or collectamount = 0 or collectableamount = 0 then 0.00 else collectamount / collectableamount * 100 end", "1", "'" + cityStr + "'"}, new String[]{FUND_RATIO, FUND_CON_RATIO, AREA_TYPE, AREA_TYPE_NAME});
        citySet = citySet.filter("area <> '" + otherCity + "'");
        return countrySet.union(citySet).filter("collectamount > 0");
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(COLLECT_AMOUNT);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_collfunddistbyarearpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return AREA_TYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(AREA_TYPE, ids.get(0));
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }

    private DataSet createEmptySet() {
        String countryStr = ResManager.loadKDString((String)"\u6309\u56fd\u5bb6", (String)"FundDistByAreaQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        String cityStr = ResManager.loadKDString((String)"\u6309\u57ce\u5e02", (String)"FundDistByAreaQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]);
        String country = ResManager.loadKDString((String)"\u4e2d\u56fd", (String)"FundDistByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet row = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), new String[]{AREA, AREA_TYPE, AREA_TYPE_NAME, COLLECT_AMOUNT, FUND_RATIO, FUND_CON_RATIO, "qingsort"}, new DataType[]{DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.IntegerType}, Collections.singletonList(new Object[]{country, "0", countryStr, "0.0", "0.0", "0.0", "0"}));
        return row.union(DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), new String[]{AREA, AREA_TYPE, AREA_TYPE_NAME, COLLECT_AMOUNT, FUND_RATIO, FUND_CON_RATIO, "qingsort"}, new DataType[]{DataType.StringType, DataType.IntegerType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.IntegerType}, Collections.singletonList(new Object[]{country, "0", cityStr, "0.0", "0.0", "0.0", "0"})));
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        String[] value;
        JSONObject selectFilter = (JSONObject)clickArgs.get((Object)"selectFilter");
        if (selectFilter != null && selectFilter.values().size() > 0 && (value = selectFilter.values().toArray(new String[0])) != null && value.length > 0 && ResManager.loadKDString((String)"\u6309\u57ce\u5e02", (String)"FundDistByAreaQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]).equals(value[0])) {
            param.getCustomParams().put(AREA_TYPE, "1");
        }
    }
}

