/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DbInput;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.splittingread.ThreadReadWriteContext;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.bean.TdaLog;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.tda.common.enums.SnapDataFromEnum;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractDecisionAnlsDataPlugin
extends AbstractTmcListDataPlugin {
    private static final Log logger = LogFactory.getLog(AbstractDecisionAnlsDataPlugin.class);
    private TdaLog dtaLog;
    public static final String MODEL = "tmc-tda-report";

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        long time = System.currentTimeMillis();
        String pageId = (String)queryParam.getFilter().getFilterItem("pageid").getValue();
        ReportView view = (ReportView)SessionManager.getCurrent().getViewNoPlugin(pageId);
        this.dtaLog = SnapDataHelper.createRunLog((String)view.getFormId());
        SnapDataHelper.saveQueryParam((String)view.getFormId(), (ReportQueryParam)queryParam, (String)((Object)((Object)this)).getClass().getName(), (boolean)true);
        try {
            this.initSnapQueryParam(queryParam);
            DataSet ds = super.query(queryParam, o);
            ds = this.filterResultDataSet(ds, queryParam);
            ds = this.updateTotalName(ds, queryParam);
            if (!this.getAmountFields().isEmpty()) {
                ds = AmountTransHelper.dealRowOtherValue((DataSet)ds, (Map)SnapDataHelper.transQueryParam((ReportQueryParam)queryParam), this.getAmountFields());
            }
            if (!this.getRemoveAllZoreFields().isEmpty()) {
                ds = this.removeAllZeroRow(ds, this.getRemoveAllZoreFields());
            }
            DataSet dataSet = ds;
            return dataSet;
        }
        catch (Exception e) {
            this.dtaLog.setException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
        finally {
            DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem("orgview").getValue();
            this.dtaLog.setOrgView(orgView);
            DynamicObjectCollection orgs = (DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue();
            this.dtaLog.setOrg((DynamicObject)orgs.get(0));
            Long costMs = System.currentTimeMillis() - time;
            this.dtaLog.setCosttime(costMs);
            if (ThreadCache.exists((Object)"tdalogdesc")) {
                this.dtaLog.setDesc(this.dtaLog.getDesc() + ":" + ThreadCache.get((Object)"tdalogdesc"));
            }
            SnapDataHelper.saveLog((TdaLog)this.dtaLog);
        }
    }

    protected DataSet queryRealTimeDataSet(ReportQueryParam queryParam) {
        if (EmptyUtil.isNoEmpty((Object)this.dtaLog)) {
            this.dtaLog.setSnapitem(null);
            this.addTdaLogDesc("realtime");
        }
        try (ThreadReadWriteContext ctx = DB.beginThreadRead((String)"qing");){
            DataSet dataSet = super.queryRealTimeDataSet(queryParam);
            return dataSet;
        }
    }

    protected DataSet query(ReportQueryParam queryParam) {
        return this.queryDataSet(queryParam);
    }

    protected abstract DataSet queryDataSet(ReportQueryParam var1);

    protected CachedDataSet queryShowSnapDataSet(String formid, ReportQueryParam queryParam, String snapItem) {
        Date queryDate = (Date)queryParam.getFilter().getFilterItem("querydate").getValue();
        DynamicObject org = (DynamicObject)queryParam.getFilter().getFilterItem("org").getValue();
        DynamicObject orgView = (DynamicObject)queryParam.getFilter().getFilterItem("orgview").getValue();
        String rootOrgId = TmcOrgDataHelper.getOrgRootId((Long)orgView.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && Long.valueOf(rootOrgId).equals(org.getLong("id"))) {
            String from = null;
            DataSet secOrgDataDs = null;
            List secOrgList = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgView.getLong("id"), (Long)Long.valueOf(rootOrgId), (boolean)true);
            if (secOrgList != null && secOrgList.size() > 0) {
                for (Long secOrg : secOrgList) {
                    Pair ds = SnapDataHelper.createCacheDataSet((String)formid, (Long)secOrg, (String)snapItem, (Date)queryDate);
                    if (!EmptyUtil.isNoEmpty((Object)ds.getRight())) continue;
                    DataSet secDs = ((CachedDataSet)ds.getRight()).toDataSet(Algo.create((String)this.createAlgoKey("temp")), false);
                    secOrgDataDs = secOrgDataDs == null ? secDs : secOrgDataDs.union(secDs);
                    from = (String)ds.getLeft();
                }
            }
            if (secOrgDataDs != null) {
                this.addTdaLogDesc(from);
                return secOrgDataDs.cache(SnapDataHelper.getHint((String)formid, (Long)Long.valueOf(rootOrgId), (String)snapItem));
            }
            Pair ds = SnapDataHelper.createCacheDataSet((String)formid, (Long)Long.valueOf(rootOrgId), (String)snapItem, (Date)queryDate);
            this.addTdaLogDesc((String)ds.getLeft());
            return (CachedDataSet)ds.getRight();
        }
        List superiorOrgs = TmcOrgDataHelper.getAllSuperiorOrgs((String)orgView.getString("number"), (Long)org.getLong("id"));
        superiorOrgs.add(org.getLong("id"));
        for (Long superiorOrg : superiorOrgs) {
            Pair ds = SnapDataHelper.createCacheDataSet((String)formid, (Long)superiorOrg, (String)snapItem, (Date)queryDate);
            if (ds.getRight() == null) continue;
            this.addTdaLogDesc((String)ds.getLeft());
            return (CachedDataSet)ds.getRight();
        }
        return null;
    }

    private void addTdaLogDesc(String desc) {
        SnapDataFromEnum from = SnapDataFromEnum.getEnumByValue((String)desc);
        this.dtaLog.setDesc(EmptyUtil.isEmpty((String)this.dtaLog.getDesc()) ? from.getName() : this.dtaLog.getDesc() + "\uff1a" + from.getName());
    }

    protected String orgField() {
        return "org";
    }

    protected boolean isUseDataSnap(String snapItem) {
        return EmptyUtil.isNoEmpty((String)snapItem);
    }

    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        return ds;
    }

    private BigDecimal getUnit(ReportQueryParam queryParam) {
        String amountunit = queryParam.getFilter().getString("amountunit");
        return new BigDecimal(amountunit);
    }

    protected Set<String> getAmountFields() {
        return new HashSet<String>();
    }

    protected Set<String> getRemoveAllZoreFields() {
        return this.getAmountFields();
    }

    protected ReportQueryParam initSnapQueryParam(ReportQueryParam queryParam) {
        QFilter filter;
        String snapItem = null;
        Set props = queryParam.getFilter().getFilterItems().stream().map(v -> v.getPropName()).collect(Collectors.toSet());
        if (props.contains("snapItem")) {
            snapItem = queryParam.getFilter().getFilterItem("snapItem") == null ? null : (String)queryParam.getFilter().getFilterItem("snapItem").getValue();
        } else {
            FilterItemInfo item = new FilterItemInfo("snapItem", null, "=");
            queryParam.getFilter().getFilterItems().add(item);
        }
        if (EmptyUtil.isNoEmpty(snapItem) && !TmcDataServiceHelper.exists((String)"tda_decisanlsversion", (QFilter[])(filter = new QFilter("number", "=", (Object)snapItem)).toArray())) {
            snapItem = null;
            queryParam.getFilter().getFilterItem("snapItem").setValue((Object)snapItem);
        }
        this.dtaLog.setSnapitem(snapItem);
        return queryParam;
    }

    protected QFilter getFilter(ReportQueryParam queryParam) {
        Set orgIdSet = (Set)queryParam.getFilter().getFilterItem("org").getValue();
        return new QFilter("org.id", "in", (Object)orgIdSet);
    }

    protected ReportQueryParam getQueryParam(String formid, String schemeid, String batchno) throws Exception {
        return new ReportQueryParam();
    }

    protected ReportQueryParam setQueryParam(ReportQueryParam param, QFilter[] filter) {
        return this.setFilter(param, filter);
    }

    protected ReportQueryParam setFilter(ReportQueryParam param, QFilter[] filters) {
        try {
            param = DecisionAnlsHelper.tranFilterToParam(param, filters);
        }
        catch (Exception e) {
            logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return param;
    }

    protected String createAlgoKey(String key) {
        return "tda-decisanls-algo-" + ((Object)((Object)this)).getClass().getName() + key;
    }

    protected JobSession createAlgoxSession(ReportQueryParam queryParam) {
        String pageId = (String)queryParam.getFilter().getFilterItem("pageid").getValue();
        return AlgoX.createSession((String)("tda-decisanls-" + ((Object)((Object)this)).getClass().getName() + pageId));
    }

    protected DataSetX DbInput(JobSession session, String key, String sql, Object[] params, RowMeta rowMeta) {
        DbInput input = new DbInput("tda-decisanls-algox-" + ((Object)((Object)this)).getClass().getName() + key, DBRouteConst.TMC.getRouteKey(), sql, params, rowMeta);
        return session.fromInput((Input)input);
    }

    protected DataSetX OrmInput(JobSession session, String key, String entityName, String selectFields, QFilter[] filters, RowMeta rowMeta) {
        OrmInput input = new OrmInput("tda-decisanls-algox-" + ((Object)((Object)this)).getClass().getName() + key, entityName, selectFields, filters, rowMeta);
        return session.fromInput((Input)input);
    }

    protected DataSet removeAllZeroRow(DataSet dataSet, final Set<String> fieldNames) {
        final String[] dataSetFields = dataSet.getRowMeta().getFieldNames();
        final boolean[] containNotAllZeroRow = new boolean[]{false};
        return dataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                if (Arrays.asList(dataSetFields).contains("sumlevel")) {
                    int sumlevel = row.getInteger("sumlevel");
                    if (containNotAllZeroRow[0] && (sumlevel == 1 || sumlevel == 2)) {
                        return true;
                    }
                }
                for (String fieldName : fieldNames) {
                    BigDecimal bigDecimal = row.getBigDecimal(fieldName);
                    if (bigDecimal == null || BigDecimal.ZERO.compareTo(bigDecimal) == 0) continue;
                    containNotAllZeroRow[0] = true;
                    return true;
                }
                return false;
            }
        });
    }

    private DataSet updateTotalName(DataSet dataSet, ReportQueryParam queryParam) {
        DynamicObject org = (DynamicObject)((DynamicObjectCollection)queryParam.getFilter().getFilterItem("filter_company").getValue()).get(0);
        String orgName = org.getString("simplename");
        if (EmptyUtil.isEmpty((String)orgName)) {
            orgName = org.getString("name");
        }
        String total = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CashDistributionByAreaDataListPlugin_1", (String)MODEL, (Object[])new Object[0]);
        String caseWhen = "case when sumlevel = 1 or sumlevel = 2 then '" + orgName + "-" + total + "' else ";
        List collect = Arrays.stream(dataSet.getRowMeta().getFieldNames()).collect(Collectors.toList());
        ArrayList<String> names = new ArrayList<String>(Arrays.asList("org_name", "mixorgname", "orgname", "companyname"));
        names.retainAll(collect);
        ArrayList<String> values = new ArrayList<String>(names.size());
        for (String name : names) {
            String totalName = caseWhen + name + " end";
            values.add(totalName);
        }
        return dataSet.updateFields(names.toArray(new String[0]), values.toArray(new String[0]));
    }
}

