/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.MulComboReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDetailDataPlugin
extends AbstractTmcListDataPlugin {
    private static final Log logger = LogFactory.getLog(AbstractDetailDataPlugin.class);
    public static final String TYPE_MULCOMBO = "MulComboReportColumn";
    public static final String MODEL = "tmc-tda-report";
    private static final List<String> TREELIST = Arrays.asList("rowid", "pid", "isgroupnode", "level", "sumlevel");
    private static final String LONGNUMBER = "longnumber";
    private static final String rowid = "rowid";
    private List<Object[]> columnItems;

    protected List<Object[]> getColumnItems() {
        return this.columnItems;
    }

    protected abstract DataSet getDataSet(Map<String, Object> var1);

    protected abstract List<String> getSumLists();

    protected String getBaseString() {
        return "orgname";
    }

    protected List<String> getOrderByList() {
        return Collections.emptyList();
    }

    public Map<String, String> getHyperlinkMap() {
        return Collections.emptyMap();
    }

    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        return hyperlinkEntity -> "";
    }

    protected Boolean getIsRemoveNoDataFlag() {
        return Boolean.TRUE;
    }

    protected String getNotNullFilterStr() {
        return null;
    }

    protected String getCountField() {
        return null;
    }

    protected DataSet beforeReturn(DataSet result) {
        return result;
    }

    protected Set<String> getCovertList() {
        return new HashSet<String>();
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Object entity = reportQueryParam.getCustomParam().get("entity");
        if (MetaToDetailPluginMap.ENTITY_SET.contains(entity)) {
            paramMap.putAll(reportQueryParam.getCustomParam());
        }
        AbstractDetailDataPlugin detailPlugin = this.getDetailPlugin(reportQueryParam);
        DataSet dataSet = detailPlugin.getDataSet(paramMap);
        List<String> stat = detailPlugin.getSumLists();
        Set<String> covertStat = detailPlugin.getCovertList();
        if (EmptyUtil.isNoEmpty(stat)) {
            covertStat.addAll(stat);
        }
        String baseStr = detailPlugin.getBaseString();
        List<String> orderByList = detailPlugin.getOrderByList();
        Boolean isRemoveNoDataFlag = detailPlugin.getIsRemoveNoDataFlag();
        String notNullFilterStr = detailPlugin.getNotNullFilterStr();
        if (EmptyUtil.isNoEmpty(covertStat)) {
            dataSet = AmountTransHelper.dealAmountConvert((DataSet)dataSet, (Map)paramMap, covertStat);
        }
        if (detailPlugin.getCountField() != null) {
            stat = new ArrayList<String>(stat);
            stat.add(detailPlugin.getCountField());
        }
        Map<String, String> vTreeBaseMap = Collections.singletonMap(baseStr, "orgname");
        Map<String, String> vbizBaseMap = this.getBizBaseMap(dataSet, stat, vTreeBaseMap);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId).addField("0", "sumlevel");
        List allOrgIds = (List)paramMap.get("allorgids");
        orgDateSet = orgDateSet.filter("rowid in allOrgIds", Collections.singletonMap("allOrgIds", allOrgIds));
        StringBuilder sb = new StringBuilder("case when rowid =");
        sb.append(((DynamicObject)paramMap.get("org")).get("id")).append(" then 0 else pid end");
        orgDateSet = orgDateSet.updateField("pid", sb.toString());
        dataSet = this.getBizDsWithOrgTree(dataSet, rowid, "company", stat, vTreeBaseMap, vbizBaseMap, orgDateSet);
        dataSet = this.getSumDataSet(dataSet, stat, isRemoveNoDataFlag, notNullFilterStr);
        if (orderByList != null) {
            dataSet = dataSet.orderBy(orderByList.toArray(new String[orderByList.size()]));
        }
        dataSet = detailPlugin.beforeReturn(dataSet);
        return dataSet;
    }

    private AbstractDetailDataPlugin getDetailPlugin(ReportQueryParam reportQueryParam) {
        String entity = (String)reportQueryParam.getCustomParam().get("entity");
        String pluginName = "";
        AbstractDetailDataPlugin detailPlugin = this;
        Map pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity);
        if (pluginInfo.get("plugin") != null) {
            try {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                pluginName = (String)pluginPair.getValue0();
                detailPlugin = (AbstractDetailDataPlugin)((Object)Class.forName(pluginName).newInstance());
                this.columnItems = detailPlugin.getColumnItems();
            }
            catch (Exception e) {
                logger.info(String.format("\u6620\u5c04\u83b7\u53d6\u660e\u7ec6DataSet\u5931\u8d25\uff0cpulgin name is %s", pluginName.substring(pluginName.lastIndexOf(".") + 1)));
            }
        }
        if (pluginInfo.get("hyperlink") == null || pluginInfo.get("hyperlinkEntity") == null) {
            pluginInfo.put("hyperlink", detailPlugin.getHyperlinkMap());
            pluginInfo.put("hyperlinkEntity", detailPlugin.getHyperlinkEntity());
        }
        return detailPlugin;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        String entity = (String)queryParam.getCustomParam().get("entity");
        Map pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity);
        Map hyperlinks = (Map)pluginInfo.get("hyperlink");
        Set hyperlinkKeys = null;
        HashSet hyperlinkValues = null;
        if (hyperlinks != null) {
            hyperlinkKeys = hyperlinks.keySet();
            hyperlinkValues = new HashSet(hyperlinks.values());
        }
        List<Object[]> columnList = this.columnItems != null ? this.columnItems : this.getColumnItems();
        for (Object[] obj : columnList) {
            ReportColumn newReportColumn = new ReportColumn();
            String columnFieldKey = obj[0].toString();
            newReportColumn.setFieldKey(columnFieldKey);
            newReportColumn.setFieldType(obj[2].toString());
            if ("rate".equals(columnFieldKey) || "gm_rate".equals(columnFieldKey)) {
                newReportColumn.setZeroShow(Boolean.parseBoolean(obj[3].toString()));
                newReportColumn.setScale(8);
            } else if ("avgintrate".equals(columnFieldKey) || "intrate".equals(columnFieldKey) || "referenceratevalue".equals(columnFieldKey) || "ratefloatpoint".equals(columnFieldKey) || "startloanrate".equals(columnFieldKey) || "loanrate".equals(columnFieldKey)) {
                newReportColumn.setZeroShow(Boolean.parseBoolean(obj[3].toString()));
                newReportColumn.setScale(10);
            } else if ("decimal".equals(obj[2].toString())) {
                newReportColumn.setZeroShow(Boolean.parseBoolean(obj[3].toString()));
                newReportColumn.setScale(2);
            } else {
                ComboReportColumn comboReportColumn;
                if ("combofield".equals(obj[2].toString())) {
                    comboReportColumn = new ComboReportColumn();
                    comboReportColumn.setFieldKey(columnFieldKey);
                    comboReportColumn.setCaption(new LocaleString(obj[1].toString()));
                    comboReportColumn.setFieldType(obj[2].toString());
                    comboReportColumn.setComboItems((List)obj[4]);
                    columns.add((AbstractReportColumn)comboReportColumn);
                    continue;
                }
                if (TYPE_MULCOMBO.equals(obj[2].toString())) {
                    comboReportColumn = new MulComboReportColumn();
                    comboReportColumn.setFieldKey(columnFieldKey);
                    comboReportColumn.setFieldType("combofield");
                    comboReportColumn.setCaption(new LocaleString(obj[1].toString()));
                    comboReportColumn.setComboItems((List)obj[4]);
                    columns.add((AbstractReportColumn)comboReportColumn);
                    continue;
                }
                if (hyperlinkKeys != null && hyperlinkKeys.contains(columnFieldKey)) {
                    newReportColumn.setHyperlink(true);
                } else if (hyperlinkValues != null && hyperlinkValues.contains(columnFieldKey)) {
                    newReportColumn.setHide(true);
                }
            }
            newReportColumn.setCaption(new LocaleString(obj[1].toString()));
            columns.add((AbstractReportColumn)newReportColumn);
        }
        this.columnItems = null;
        return columns;
    }

    private Map<String, String> getBizBaseMap(DataSet bizDsBase, List<String> sumList, Map<String, String> vTreeBaseMap) {
        if (bizDsBase == null) {
            return Collections.emptyMap();
        }
        Map<String, DataType> bizDsBaseAllFieldMap = Arrays.stream(bizDsBase.getRowMeta().getFields()).collect(Collectors.toMap(Field::getName, Field::getDataType));
        ArrayList<String> bizDsBaseAllFieldList = new ArrayList<String>(bizDsBaseAllFieldMap.keySet());
        if (vTreeBaseMap != null) {
            bizDsBaseAllFieldList.removeAll(vTreeBaseMap.keySet());
        }
        bizDsBaseAllFieldList.removeAll(sumList);
        bizDsBaseAllFieldList.removeAll(TREELIST);
        bizDsBaseAllFieldList.remove(LONGNUMBER);
        return bizDsBaseAllFieldList.stream().collect(Collectors.toMap(o -> o, o -> {
            DataType tDataType = (DataType)bizDsBaseAllFieldMap.get(o);
            if (tDataType instanceof BigDecimalType) {
                return "0.00";
            }
            if (tDataType instanceof IntegerType) {
                return "0";
            }
            if (tDataType instanceof LongType) {
                return "0L";
            }
            return "null";
        }));
    }

    public DataSet getBizDsWithOrgTree(DataSet bizDsBase, String lField, String rField, List<String> sumList, Map<String, String> vTreeBaseMap, Map<String, String> vbizBaseMap, DataSet orgDateSet) {
        if (bizDsBase == null || lField == null || rField == null) {
            return bizDsBase;
        }
        if (vTreeBaseMap == null) {
            vTreeBaseMap = Collections.emptyMap();
        }
        if (vbizBaseMap == null) {
            vbizBaseMap = Collections.emptyMap();
        }
        if (orgDateSet == null || bizDsBase.copy().isEmpty()) {
            return this.getBizDsUpOrgTree(bizDsBase.addNullField(LONGNUMBER));
        }
        boolean islField = Arrays.stream(orgDateSet.getRowMeta().getFields()).anyMatch(o -> o.getName().equals(lField));
        boolean isrField = Arrays.stream(bizDsBase.getRowMeta().getFields()).anyMatch(o -> o.getName().equals(rField));
        if (!islField || !isrField) {
            return this.getBizDsUpOrgTree(bizDsBase.addNullField(LONGNUMBER));
        }
        ArrayList<String> fieldList = new ArrayList<String>(TREELIST);
        fieldList.addAll(vTreeBaseMap.keySet());
        fieldList.addAll(vbizBaseMap.keySet());
        fieldList.addAll(sumList);
        fieldList.add(LONGNUMBER);
        String[] selectField = fieldList.toArray(new String[0]);
        String[] sumVel = (String[])sumList.stream().map(o -> "0").toArray(String[]::new);
        DataSet bizDsOrgs0 = orgDateSet.copy().join(bizDsBase.copy()).on(lField, rField).select(selectField).finish();
        ArrayList<String> bankAcctvgb = new ArrayList<String>(TREELIST);
        bankAcctvgb.addAll(vTreeBaseMap.keySet());
        bankAcctvgb.add(LONGNUMBER);
        DataSet bizDsOrgs1 = bizDsOrgs0.copy().where("isgroupnode='1'").groupBy(bankAcctvgb.toArray(new String[0])).finish();
        bizDsOrgs1 = this.addMapFields(bizDsOrgs1, vbizBaseMap).addFields(sumVel, sumList.toArray(new String[0])).updateField("pid", rowid).updateField("level", "level+1").select(selectField);
        bizDsOrgs1 = this.updateRowId(bizDsOrgs1);
        Map<String, String> tPidMap = this.getDsMap(bizDsOrgs1, "pid", rowid);
        DataSet bizDsOrgs2 = bizDsOrgs0.copy().updateField("pid", rowid).updateField("level", "level+" + (tPidMap.size() > 0 ? "2" : "1"));
        bizDsOrgs2 = this.updateRowId(bizDsOrgs2);
        bizDsOrgs2 = this.updatePId(bizDsOrgs2, tPidMap);
        if (bizDsOrgs2 == null) {
            return bizDsOrgs2;
        }
        DataSet orgDateSet1 = this.addMapFields(orgDateSet, vbizBaseMap);
        orgDateSet1 = this.addMapFields(orgDateSet1, vTreeBaseMap);
        orgDateSet1 = orgDateSet1.addFields(sumVel, sumList.toArray(new String[0])).select(selectField);
        DataSet allDateSet = bizDsOrgs2.union(new DataSet[]{bizDsOrgs1, orgDateSet1});
        return allDateSet;
    }

    public DataSet getBizDsUpOrgTree(DataSet bizDsBase) {
        if (bizDsBase == null) {
            return bizDsBase;
        }
        return this.updateRowId(bizDsBase.addFields(new String[]{String.valueOf(DBServiceHelper.genGlobalLongId()), "0", "'0'", "0"}, new String[]{rowid, "pid", "isgroupnode", "level"}));
    }

    private DataSet addMapFields(DataSet bizDataSet, Map<String, String> vTreeGbMap) {
        DataSet bizDS = bizDataSet.copy();
        if (vTreeGbMap.size() > 0) {
            ArrayList<String> vTreeGbKeyList = new ArrayList<String>(vTreeGbMap.size());
            ArrayList<String> vTreeGbValueList = new ArrayList<String>(vTreeGbMap.size());
            for (Map.Entry<String, String> vTreeGbEntry : vTreeGbMap.entrySet()) {
                vTreeGbKeyList.add(vTreeGbEntry.getKey());
                vTreeGbValueList.add(vTreeGbEntry.getValue());
            }
            bizDS = bizDS.addFields(vTreeGbValueList.toArray(new String[0]), vTreeGbKeyList.toArray(new String[0]));
        }
        return bizDS;
    }

    private DataSet updateRowId(DataSet bizDsSet) {
        List<String> rowFieldList = this.getFieldList(bizDsSet);
        if (bizDsSet == null || !rowFieldList.contains(rowid)) {
            return bizDsSet;
        }
        if (bizDsSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(bizDsSet.getRowMeta());
        }
        DataSet bizDs = bizDsSet.copy();
        DataSetBuilder bizDsBulider = Algo.create((String)AbstractDetailDataPlugin.class.getSimpleName()).createDataSetBuilder(bizDs.getRowMeta());
        for (Row row : bizDs) {
            ArrayList updataRow = new ArrayList(rowFieldList.size());
            rowFieldList.forEach(rowField -> {
                if (rowid.equals(rowField)) {
                    updataRow.add(String.valueOf(DBServiceHelper.genGlobalLongId()));
                } else {
                    updataRow.add(row.get(rowField));
                }
            });
            bizDsBulider.append(updataRow.toArray());
        }
        return bizDsBulider.build();
    }

    private List<String> getFieldList(DataSet bizDsBase) {
        if (bizDsBase == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(bizDsBase.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
    }

    private Map<String, String> getDsMap(DataSet bizDsSet, String keyField, String valueField) {
        HashMap<String, String> tDsMap = new HashMap<String, String>(16);
        List<String> rowFieldList = this.getFieldList(bizDsSet);
        if (bizDsSet != null && !bizDsSet.copy().isEmpty() && rowFieldList.contains(keyField) && rowFieldList.contains(valueField)) {
            DataSet bizDs = bizDsSet.copy();
            for (Row row : bizDs) {
                tDsMap.put(row.getString(keyField), row.getString(valueField));
            }
            bizDs.close();
        }
        return tDsMap;
    }

    private DataSet updatePId(DataSet bizDsSet, Map<String, String> tPidMap) {
        List<String> rowFieldList = this.getFieldList(bizDsSet);
        String pid = "pid";
        if (bizDsSet == null || bizDsSet.copy().isEmpty() || !rowFieldList.contains("pid") || tPidMap == null || tPidMap.size() < 1) {
            return bizDsSet;
        }
        DataSet bizDs = bizDsSet.copy();
        DataSetBuilder bizDsBulider = Algo.create((String)AbstractDetailDataPlugin.class.getSimpleName()).createDataSetBuilder(bizDs.getRowMeta());
        for (Row row : bizDs) {
            ArrayList updataRow = new ArrayList(rowFieldList.size());
            rowFieldList.forEach(rowField -> {
                if (rowField.equals("pid") && tPidMap.containsKey(row.getString(rowField))) {
                    updataRow.add(tPidMap.get(row.getString(rowField)));
                } else {
                    updataRow.add(row.get(rowField));
                }
            });
            bizDsBulider.append(updataRow.toArray());
        }
        bizDs.close();
        return bizDsBulider.build();
    }

    public DataSet getSumDataSet(DataSet allDateSet, List<String> sumList, boolean isRemoveNoData, String notNullFilterStr) {
        if (allDateSet == null || allDateSet.copy().isEmpty()) {
            return allDateSet;
        }
        List<String> selectList = this.getFieldList(allDateSet);
        selectList.removeAll(TREELIST);
        selectList.removeAll(sumList);
        DataSet bizDs = this.getSumDataSetByLevel(allDateSet.copy(), sumList, String.join((CharSequence)",", selectList.toArray(new String[0])));
        String[] fieldNames = bizDs.getRowMeta().getFieldNames();
        DataSet pidGroupDs = bizDs.copy().groupBy(new String[]{"pid"}).finish().select("pid parentid");
        bizDs = bizDs.leftJoin(pidGroupDs).on(rowid, "parentid").select(fieldNames, new String[]{"parentid"}).finish();
        bizDs = bizDs.updateField("isgroupnode", "case when parentid=null then '0' else '1' end ");
        if (isRemoveNoData) {
            bizDs = bizDs.filter(this.getFilterStr(sumList)).select(fieldNames);
        } else if (StringUtils.isNotEmpty((String)notNullFilterStr)) {
            bizDs = bizDs.filter(notNullFilterStr).select(fieldNames);
            DataSet pidGroupDsNew = bizDs.copy().groupBy(new String[]{"pid"}).finish().select("pid parentid");
            bizDs = bizDs.leftJoin(pidGroupDsNew).on(rowid, "parentid").select(fieldNames, new String[]{"parentid"}).finish();
            bizDs = bizDs.filter("isgroupnode = '0' or (isgroupnode = '1' and parentid != null)");
        }
        return bizDs;
    }

    public List<ValueMapItem> getValueMapItemList(String ... valueMapStr) {
        String[] keyAndValueStrs = valueMapStr;
        ArrayList<ValueMapItem> valueMapItemList = new ArrayList<ValueMapItem>(10);
        for (int i = 0; i < keyAndValueStrs.length; i += 2) {
            ValueMapItem valueMapItem = new ValueMapItem("", keyAndValueStrs[i], new LocaleString(keyAndValueStrs[i + 1]));
            valueMapItemList.add(valueMapItem);
        }
        return valueMapItemList;
    }

    public String getFilterStr(List<String> amountFields) {
        StringBuilder filter = new StringBuilder();
        amountFields.forEach(o -> {
            filter.append("( ");
            filter.append((String)o);
            filter.append(" !=0 and ");
            filter.append((String)o);
            filter.append("!=null ) or ");
        });
        return filter.substring(0, filter.length() - 4);
    }
}

