/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.form;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class AbstractClickFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String FILTER = "filter";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String GROUPNODEVALUE = "1";
    private static final String REPORT_LIS_TAP = "reportlistap";
    private static final String TERM_TYPE = "termType";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getView().getControl(REPORT_LIS_TAP);
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("btn_showdetail")) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                if ("original".equals(formShowParameter.getCustomParam(TERM_TYPE))) {
                    param.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u539f\u59cb\u671f\u9650\u4f59\u989d\u5206\u5e03\u8868\u660e\u7ec6", (String)"AbstractClickFormPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]));
                } else {
                    param.setCaption(ResManager.loadKDString((String)"\u6295\u8d44\u7406\u8d22\u5269\u4f59\u671f\u9650\u4f59\u989d\u5206\u5e03\u8868\u660e\u7ec6", (String)"AbstractClickFormPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
                }
            }
            param.getCustomParams().put(TERM_TYPE, formShowParameter.getCustomParam(TERM_TYPE));
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        this.customVerifyQueryParam().forEach((k, v) -> queryParam.getFilter().addFilterItem(k, parameter.getCustomParams().get(v)));
        return super.verifyQuery(queryParam);
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString(ISGROUPNODE);
        long orgId = row.getLong(ORGID);
        if (orgId == 0L || !GROUPNODEVALUE.equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(ORGID, Long.toString(orgId));
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(this.getView().getFormShowParameter().getFormId());
        this.customHyperLinkClick(param);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    public Map<String, String> customVerifyQueryParam() {
        return Collections.emptyMap();
    }

    public void customHyperLinkClick(ReportShowParameter param) {
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString(ISGROUPNODE);
        Object formatValue = packageDataEvent.getFormatValue();
        if (formatValue != null && !GROUPNODEVALUE.equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(((ReportColumn)packageDataEvent.getSource()).getFieldKey());
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        ReportView reportView = (ReportView)this.getView();
        ReportListModel reportModel = (ReportListModel)reportView.getReportList().getReportModel();
        List reportColumnList = reportModel.getReportTaskResult().getReportColumnList();
        Set<String> columns = reportColumnList.stream().map(ReportColumn::getFieldKey).collect(Collectors.toSet());
        String mergeName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"ClickParamReportHelper_01", (String)"tmc-tda-report", (Object[])new Object[0]);
        List ruleNames = Stream.of("org_name", "mixorgname", "orgname").collect(Collectors.toList());
        ruleNames.retainAll(columns);
        if (ruleNames.isEmpty()) {
            return;
        }
        StringBuilder conditionBuilder = new StringBuilder((String)ruleNames.get(0)).append(" = '").append(mergeName).append("'");
        if (CollectionUtils.isNotEmpty(columns)) {
            columns.forEach(fieldKey -> {
                CellStyleRule cellStyleRule = this.createCellStyleRule("red", (String)fieldKey, conditionBuilder.toString());
                cellStyleRules.add(cellStyleRule);
            });
            columns.forEach(fieldKey -> {
                CellStyleRule cellStyleRule = this.createCellStyleRule("white", (String)fieldKey, conditionBuilder + " and " + fieldKey + " = '0.00'");
                cellStyleRules.add(cellStyleRule);
            });
        }
        super.setCellStyleRules(cellStyleRules);
    }

    private CellStyleRule createCellStyleRule(String color, String fieldKey, String condition) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey(fieldKey);
        cellStyleRule.setForeColor(color);
        cellStyleRule.setBackgroundColor("white");
        cellStyleRule.setDegree(100);
        cellStyleRule.setCondition(condition);
        return cellStyleRule;
    }
}

