/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDException;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.report.common.helper.TdaRptDataServiceHelper;

public class DebugRptDataFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"query"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        ReportQueryParam newParam = new ReportQueryParam();
        DynamicObject orgView = (DynamicObject)this.getModel().getValue("orgview");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Date queryDate = (Date)this.getModel().getValue("querydate");
        String amountUnit = (String)this.getModel().getValue("amountunit");
        FilterInfo items = newParam.getFilter();
        items.addFilterItem("orgview", (Object)orgView);
        items.addFilterItem("org", (Object)org);
        items.addFilterItem("currency", (Object)currency);
        items.addFilterItem("querydate", (Object)queryDate);
        items.addFilterItem("amountunit", (Object)amountUnit);
        String customParam = (String)this.getModel().getValue("customparam");
        JSONObject customMap = JSON.parseObject((String)customParam);
        newParam.getCustomParam().putAll(customMap);
        String entity = (String)this.getModel().getValue("entity");
        String rptType = (String)this.getModel().getValue("rpttype");
        DataSet result = null;
        try {
            result = TdaRptDataServiceHelper.getRptData(newParam, entity, rptType);
        }
        catch (Throwable throwable) {
            throw new KDException(String.valueOf(throwable));
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (Row row : result) {
            String rowVal = "<p>" + row.toString() + "</p>\n";
            builder.append(rowVal);
            ++i;
        }
        builder.insert(0, "totalnum\uff1a" + i);
        RichTextEditor editor = (RichTextEditor)this.getControl("rowdata");
        editor.setText(builder.toString());
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("orgview", (Object)8L);
        this.getModel().setValue("org", (Object)TmcOrgDataHelper.getOrgRootId((Long)8L));
        this.getModel().setValue("currency", (Object)1L);
        this.getModel().setValue("amountunit", (Object)"1");
        this.getModel().setValue("querydate", (Object)DateUtils.getCurrentDate());
    }
}

