/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.credit.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.credit.helper.CreditLimitHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class CreditDetailDataListPlugin
extends AbstractDetailDataPlugin {
    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u6388\u4fe1\u4e3b\u4f53", (String)"CreditDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"creditno", ResManager.loadKDString((String)"\u6388\u4fe1\u5355\u53f7", (String)"CreditDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"contractno", ResManager.loadKDString((String)"\u6388\u4fe1\u534f\u8bae\u53f7", (String)"CreditDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"banktype", ResManager.loadKDString((String)"\u6388\u4fe1\u673a\u6784\u7c7b\u578b", (String)"CreditDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList(CreditFinTypeEnum.FINORG.getValue(), CreditFinTypeEnum.getName((String)CreditFinTypeEnum.FINORG.getValue()), CreditFinTypeEnum.ORG.getValue(), CreditFinTypeEnum.getName((String)CreditFinTypeEnum.ORG.getValue()))});
        field.add(new Object[]{"bankname", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"CreditDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankorgname", ResManager.loadKDString((String)"\u6388\u4fe1\u673a\u6784", (String)"CreditDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"isdomestic", ResManager.loadKDString((String)"\u5883\u5185\u5916\u6807\u8bc6", (String)"CreditDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"creditprop", ResManager.loadKDString((String)"\u6388\u4fe1\u6027\u8d28", (String)"CreditDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("circle", this.getCircle(), "fix", this.getFix())});
        field.add(new Object[]{"credittypename", ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b", (String)"CreditDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CreditDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"CreditDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"originaltotalamt", ResManager.loadKDString((String)"\u603b\u6388\u4fe1\u989d\u5ea6", (String)"CreditDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"totalamt", ResManager.loadKDString((String)"\u603b\u6388\u4fe1\u989d\u5ea6\u6298\u62a5\u544a\u5e01", (String)"CreditDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"originaluseamt", ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"useamt", ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6\u6298\u62a5\u544a\u5e01", (String)"CreditDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"originalavaramt", ResManager.loadKDString((String)"\u53ef\u7528\u989d\u5ea6", (String)"CreditDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"avaramt", ResManager.loadKDString((String)"\u53ef\u7528\u989d\u5ea6\u6298\u62a5\u544a\u5e01", (String)"CreditDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"startdate", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"CreditDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"enddate", ResManager.loadKDString((String)"\u5230\u671f\u65e5\u671f", (String)"CreditDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"guartype", ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f", (String)"CreditDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"close", ResManager.loadKDString((String)"\u5173\u95ed", (String)"CreditDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"closedate", ResManager.loadKDString((String)"\u5173\u95ed\u65e5\u671f", (String)"CreditDetailDataListPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        paramMap.put("allorgids", orgIds);
        DataSet ds = CreditLimitHelper.query(paramMap);
        String props = "id, org orgname, org company, creditno, contractno, banktype, bankname, bankorgname, isdomestic,creditprop, credittypename, currencyname, rate, originaltotalamt, totalamt, originaluseamt, useamt,originaltotalamt-originaluseamt originalavaramt, totalamt-useamt avaramt,startdate, enddate, guartype, closedate,case when closedate is null then '0' else '1' end as close";
        String isdomesticStr = String.format("case when isdomestic = '1' then '%1$s' else '%2$s' end", ResManager.loadKDString((String)"\u5883\u5185", (String)"CreditDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5883\u5916", (String)"CreditDetailDataListPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]));
        ds = ds.updateField("isdomestic", isdomesticStr);
        return this.handleDataSet(ds.select(props));
    }

    private DataSet handleDataSet(DataSet ds) {
        final Map<String, String> valueMapText = this.valueMapText();
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("guartype".equals(fieldName)) {
                        String guaranteeway = row.getString(fieldName);
                        if (EmptyUtil.isEmpty((String)guaranteeway)) {
                            rowInfo.add("");
                            continue;
                        }
                        rowInfo.add(GuaranteeReportHelper.GuaranteewayValueMapText(guaranteeway, valueMapText));
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("totalamt", "useamt", "avaramt");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("creditno", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        return hyperLinkClickEvent -> "cfm_creditlimit";
    }

    @Override
    protected List<String> getOrderByList() {
        ArrayList<String> orderList = new ArrayList<String>(6);
        orderList.add("banktype");
        orderList.add("bankname");
        orderList.add("bankorgname");
        orderList.add("creditprop");
        orderList.add("credittypename");
        return orderList;
    }

    private String getCircle() {
        return ResManager.loadKDString((String)"\u5faa\u73af\u6388\u4fe1", (String)"CreditDetailDataListPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private String getFix() {
        return ResManager.loadKDString((String)"\u975e\u5faa\u73af\u6388\u4fe1", (String)"CreditDetailDataListPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private Map<String, String> valueMapText() {
        GuaranteeWayEnum[] entityEnums = GuaranteeWayEnum.values();
        HashMap<String, String> itemMap = new HashMap<String, String>(8);
        for (GuaranteeWayEnum aEnum : entityEnums) {
            itemMap.put(aEnum.getValue(), GuaranteeWayEnum.getName((String)aEnum.getNumberValue()));
        }
        return itemMap;
    }
}

