/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.credit.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.enums.FinOrgTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.CreditDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class CreditLimitHelper {
    private static String ORG = "org";
    private static String ORG_NAME = "org_name";
    private static String MIX_ORGNAME = "mixorgname";
    private static String ROWID = "rowid";
    private static String PID = "pid";
    private static String ISGROUPNODE = "isgroupnode";
    private static String LEVEL = "level";
    private static String AREAS = "areas";
    private static String DOMESTIC = "domestic";
    private static String OVERSEAS = "overseas";
    private static List<String> COUNT_FIELDS = Arrays.asList("totalamt_" + DOMESTIC, "useamt_" + DOMESTIC, "avaramt_" + DOMESTIC, "totalamt_" + OVERSEAS, "useamt_" + OVERSEAS, "avaramt_" + OVERSEAS);

    public static DataSet query(Map<String, Object> paramMap) {
        List allorgids = (List)paramMap.get("allorgids");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet creditDataSet = CreditDataHelper.getAllCreditLimit((String)"CreditLimitByAreaDataHelper", (Long)orgViewId, (List)allorgids, (Date)queryDate, (Long)baseCurrency).filter(CreditLimitHelper.getCreditFilter().toString());
        return creditDataSet;
    }

    public static DataSet processDataSet(DataSet ds, Map<String, Object> reportQueryMap) {
        Long orgViewId = ((DynamicObject)reportQueryMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet creditDataSet = ds;
        creditDataSet = creditDataSet.select(new String[]{ORG, "totalamt", "useamt", "case when isdomestic = '1' then 'domestic' else 'overseas' end as " + AREAS});
        DataSet groupByOrgSet = creditDataSet.groupBy(new String[]{ORG, AREAS}).sum("totalamt").sum("useamt").finish();
        DataSet changeColSetByArea = CreditLimitHelper.getChangeColSetByArea(groupByOrgSet);
        changeColSetByArea = DecisionAnlsHelper.addAbsentFields(changeColSetByArea, COUNT_FIELDS);
        DataSet leftJoinDataSet = orgDateSet.leftJoin(changeColSetByArea).on(ORG, ORG).select(new String[]{ORG, ROWID, PID, ISGROUPNODE, LEVEL, "orgname org_name", "sortcode", MIX_ORGNAME}, COUNT_FIELDS.toArray(new String[0])).finish();
        leftJoinDataSet = leftJoinDataSet.addField("0", "sumlevel");
        DataSet sumResultSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDataSet, COUNT_FIELDS, ORG + "," + ORG_NAME + "," + MIX_ORGNAME + ",sortcode");
        sumResultSet = DecisionAnlsHelper.updateValueWhenNull(sumResultSet, COUNT_FIELDS);
        DataSet resultDataSet = sumResultSet.updateField(COUNT_FIELDS.get(2), COUNT_FIELDS.get(0) + "-" + COUNT_FIELDS.get(1)).updateField(COUNT_FIELDS.get(5), COUNT_FIELDS.get(3) + "-" + COUNT_FIELDS.get(4));
        resultDataSet = DecisionAnlsHelper.removeNoDataTreeDs(resultDataSet, COUNT_FIELDS, false);
        return resultDataSet;
    }

    public static DataSet filterResultDataSet(DataSet sumResultSet, Map<String, Object> paramMap) {
        List subOrgIds = EmptyUtil.isNoEmpty((Object)paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            sumResultSet = sumResultSet.where("org in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        sumResultSet = sumResultSet.addField(COUNT_FIELDS.get(0) + " + " + COUNT_FIELDS.get(3), "totalamt");
        sumResultSet = sumResultSet.addField(COUNT_FIELDS.get(1) + " + " + COUNT_FIELDS.get(4), "useamt");
        sumResultSet = sumResultSet.addField(COUNT_FIELDS.get(2) + " + " + COUNT_FIELDS.get(5), "avaramt");
        return sumResultSet;
    }

    public static QFilter getCreditFilter() {
        return new QFilter("finorgtype", "!=", (Object)FinOrgTypeEnum.CLEARINGHOUSE.getValue());
    }

    private static DataSet getChangeColSetByArea(DataSet dataSet) {
        DataSet changeColSetByArea = DecisionAnlsHelper.ChangeMultRowToColDataSet(dataSet, AREAS, ORG, "", Arrays.asList("totalamt", "useamt"));
        String[] fieldNames = changeColSetByArea.getRowMeta().getFieldNames();
        ArrayList<String> select = new ArrayList<String>(10);
        for (String fieldName : fieldNames) {
            if (ORG.equals(fieldName)) {
                select.add(fieldName);
                continue;
            }
            String[] splits = fieldName.replace(DOMESTIC, DOMESTIC + "_").replace(OVERSEAS, OVERSEAS + "_").split("_");
            select.add(fieldName + " as " + splits[1] + "_" + splits[0]);
        }
        DataSet resultSet = changeColSetByArea.select(select.toArray(new String[0]));
        return resultSet;
    }
}

