/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.credit.qing.data;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.credit.helper.CreditLimitHelper;
import kd.tmc.tda.report.credit.qing.data.CreditTotalDataPlugin;

public class CreditTotalDiagramDataPlugin
extends CreditTotalDataPlugin {
    private static final String USEAMT_RATIO = "useamtRatio";
    private static final String AVARAMT_RATIO = "avaramtRatio";
    private static final Integer DEFAULT_SCALE = 4;

    @Override
    protected List<Object[]> getColumnItems() {
        List<Object[]> fields = super.getColumnItems();
        fields.add(new Object[]{USEAMT_RATIO, ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6\u5360\u6bd4", (String)"CreditTotalDiagramDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{AVARAMT_RATIO, ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6\u5360\u6bd4", (String)"CreditTotalDiagramDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        paramMap.put("allorgids", this.getOrgIds(paramMap));
        DataSet creditDataSet = CreditLimitHelper.query(paramMap);
        creditDataSet = creditDataSet.select(new String[]{"totalamt", "useamt", "totalamt-useamt as avaramt"});
        DataSet resultSet = creditDataSet.groupBy().sum("totalamt").sum("useamt").sum("avaramt").finish();
        resultSet = this.handleDataSet(resultSet);
        resultSet = DecisionAnlsHelper.creatAbsentRow(resultSet, "type", Arrays.asList("0", "1"), 3, () -> new Object[]{0.0, 0.0, 0.0, "", 0.0, 0.0});
        String typeName = String.format("case when type=0 then '%1$s' when type=1 then '%2$s' else ' ' end", ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditTotalDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditTotalDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]));
        resultSet = resultSet.addFields(new String[]{"'click'", typeName, DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditTotalDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u5269\u4f59\u989d\u5ea6", (String)"CreditTotalDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{this.CLICK, "typename", "usecolumn", "avaramtcolumn"});
        return resultSet.select(new String[]{"totalamt", "useamt", "avaramt", this.CLICK, "type", "typename", "usecolumn", "avaramtcolumn", USEAMT_RATIO, AVARAMT_RATIO});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet handleDataSet(DataSet ds) {
        if (DecisionAnlsHelper.checkEmptyAndClose(ds.copy())) {
            return ds.addFields(new String[]{"0", "0", "0"}, new String[]{"type", USEAMT_RATIO, AVARAMT_RATIO});
        }
        try {
            Row row = (Row)ds.iterator().next();
            BigDecimal useamt = EmptyUtil.isEmpty((BigDecimal)row.getBigDecimal("useamt")) ? BigDecimal.ZERO : row.getBigDecimal("useamt");
            BigDecimal avaramt = EmptyUtil.isEmpty((BigDecimal)row.getBigDecimal("avaramt")) ? BigDecimal.ZERO : row.getBigDecimal("avaramt");
            BigDecimal totalamt = row.getBigDecimal("totalamt");
            BigDecimal useamtRatio = BigDecimal.ZERO.equals(totalamt) ? BigDecimal.ZERO : useamt.divide(totalamt, (int)DEFAULT_SCALE, RoundingMode.HALF_UP);
            BigDecimal avaramtRatio = BigDecimal.ZERO.equals(totalamt) ? BigDecimal.ZERO : avaramt.divide(totalamt, (int)DEFAULT_SCALE, RoundingMode.HALF_UP);
            ds = ds.addField("0", "type");
            RowMeta rowMeta = ds.getRowMeta();
            DataSet useDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{useamt, useamt, 0.0, 1}));
            DataSet avaDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{avaramt, 0.0, avaramt, 0}));
            DataSet resultDs = useDs.union(avaDs);
            DataSet dataSet = resultDs.addFields(new String[]{"'" + useamtRatio + "'", "'" + avaramtRatio + "'"}, new String[]{USEAMT_RATIO, AVARAMT_RATIO});
            return dataSet;
        }
        finally {
            ds.close();
        }
    }
}

