/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.data.AbstractFinDebtDistDataListPlugin;

public class FinDebtByCurrencyDataListPlugin
extends AbstractFinDebtDistDataListPlugin {
    private static final String CURRENCY = "currency";
    private static final String OUT_DEBT_CNY = "outgroupdebtcny";
    private static final String OUT_DEBT_USD = "outgroupdebtusd";
    private static final String OUT_DEBT_HKD = "outgroupdebthkd";
    private static final String OUT_DEBT_OTHER = "outgroupdebtother";
    private static final String IN_DEBT_CNY = "ingroupdebtcny";
    private static final String IN_DEBT_USD = "ingroupdebtusd";
    private static final String IN_DEBT_HKD = "ingroupdebthkd";
    private static final String IN_DEBT_OTHER = "ingroupdebtother";
    private static final String TOTAL_DEBT_CNY = "totaldebtcny";
    private static final String TOTAL_DEBT_USD = "totaldebtusd";
    private static final String TOTAL_DEBT_HKD = "totaldebthkd";
    private static final String TOTAL_DEBT_OTHER = "totaldebtother";
    private static final String OUT_DEBT_SUBTOTAL = "outgroupsubtotal";
    private static final String IN_DEBT_SUBTOTAL = "ingroupsubtotal";
    private static final List<String> OUT_GROUP_SUM_FIELD = Arrays.asList("outgroupdebtcny", "outgroupdebtusd", "outgroupdebthkd", "outgroupdebtother");
    private static final List<String> IN_GROUP_SUM_FIELD = Arrays.asList("ingroupdebtcny", "ingroupdebtusd", "ingroupdebthkd", "ingroupdebtother");
    private static final List<String> SUM_FIELD = Arrays.asList("outgroupdebtcny", "outgroupdebtusd", "outgroupdebthkd", "outgroupdebtother", "ingroupdebtcny", "ingroupdebtusd", "ingroupdebthkd", "ingroupdebtother", "coloffsetcny", "coloffsethkd", "coloffsetusd", "coloffsetother", "coloffset");
    private static final List<String> MERGE_FIELD = Arrays.asList("ingroupdebtcny", "ingroupdebthkd", "ingroupdebtusd", "ingroupdebtother", "ingroupsubtotal", "totaldebtcny", "totaldebthkd", "totaldebtusd", "totaldebtother", "totaldebt");
    private static final List<String> SOURCE_MERGE_FIELD = Arrays.asList("coloffsetcny", "coloffsethkd", "coloffsetusd", "coloffsetother", "coloffset");
    private static final List<String> TOTAL_SUM_FIELD = Arrays.asList("outgroupdebtcny", "outgroupdebtusd", "outgroupdebthkd", "outgroupdebtother", "ingroupdebtcny", "ingroupdebtusd", "ingroupdebthkd", "ingroupdebtother", "totaldebtcny", "totaldebtusd", "totaldebthkd", "totaldebtother", "outgroupsubtotal", "ingroupsubtotal", "totaldebt");

    @Override
    protected DataSet getFinanceQueryDataset(DataSet allDs, Map<String, Object> paramMap) {
        allDs = allDs.filter("isequity = false");
        DataSet dataUnion = allDs.copy().select(new String[]{"org", "coloffset"}).groupBy(new String[]{"org"}).sum("coloffset").finish();
        DataSet[] splitDataSet = allDs.splitByFilter(new String[]{"isoutgroup = 1"}, true);
        DataSet outGroupSet = splitDataSet[0].select(new String[]{"org", "repayamount", CURRENCY});
        DataSet outGroupResSet = outGroupSet.copy().select("org").groupBy(new String[]{"org"}).finish();
        DataSet[] splitOutGroupSet = outGroupSet.splitByFilter(new String[]{"currency = 1", "currency = 2", "currency = 6"}, true);
        DataSet outDebtCNYSet = splitOutGroupSet[0].groupBy(new String[]{"org"}).sum("repayamount", OUT_DEBT_CNY).finish();
        outGroupResSet = outGroupResSet.leftJoin(outDebtCNYSet).on("org", "org").select(new String[]{"org", OUT_DEBT_CNY}).finish();
        DataSet outDebtHKDSet = splitOutGroupSet[1].groupBy(new String[]{"org"}).sum("repayamount", OUT_DEBT_HKD).finish();
        outGroupResSet = outGroupResSet.leftJoin(outDebtHKDSet).on("org", "org").select(new String[]{"org", OUT_DEBT_CNY, OUT_DEBT_HKD}).finish();
        DataSet outDebtUSDSet = splitOutGroupSet[2].groupBy(new String[]{"org"}).sum("repayamount", OUT_DEBT_USD).finish();
        outGroupResSet = outGroupResSet.leftJoin(outDebtUSDSet).on("org", "org").select(new String[]{"org", OUT_DEBT_CNY, OUT_DEBT_HKD, OUT_DEBT_USD}).finish();
        DataSet outDebtOtherSet = splitOutGroupSet[3].groupBy(new String[]{"org"}).sum("repayamount", OUT_DEBT_OTHER).finish();
        outGroupResSet = outGroupResSet.leftJoin(outDebtOtherSet).on("org", "org").select(new String[]{"org", OUT_DEBT_CNY, OUT_DEBT_HKD, OUT_DEBT_USD, OUT_DEBT_OTHER}).finish();
        dataUnion = dataUnion.leftJoin(outGroupResSet).on("org", "org").select(new String[]{"org", OUT_DEBT_CNY, OUT_DEBT_HKD, OUT_DEBT_USD, OUT_DEBT_OTHER, "coloffset"}).finish();
        DataSet inGroupSet = splitDataSet[1].select(new String[]{"org", "repayamount", CURRENCY, "rowoffset", "coloffset"});
        DataSet inGroupResSet = inGroupSet.copy().select("org").groupBy(new String[]{"org"}).finish();
        DataSet[] splitInGroupSet = inGroupSet.splitByFilter(new String[]{"currency = 1", "currency = 2", "currency = 6"}, true);
        DataSet inDebtCNYSet = splitInGroupSet[0].groupBy(new String[]{"org"}).sum("repayamount", IN_DEBT_CNY).sum("rowoffset").sum("coloffset", "coloffsetcny").finish().updateField(IN_DEBT_CNY, "ingroupdebtcny + rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(inDebtCNYSet).on("org", "org").select(new String[]{"org", IN_DEBT_CNY, "coloffsetcny"}).finish();
        DataSet inDebtHKDSet = splitInGroupSet[1].groupBy(new String[]{"org"}).sum("repayamount", IN_DEBT_HKD).sum("rowoffset").sum("coloffset", "coloffsethkd").finish().updateField(IN_DEBT_HKD, "ingroupdebthkd + rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(inDebtHKDSet).on("org", "org").select(new String[]{"org", IN_DEBT_CNY, "coloffsetcny", IN_DEBT_HKD, "coloffsethkd"}).finish();
        DataSet inDebtUSDSet = splitInGroupSet[2].groupBy(new String[]{"org"}).sum("repayamount", IN_DEBT_USD).sum("rowoffset").sum("coloffset", "coloffsetusd").finish().updateField(IN_DEBT_USD, "ingroupdebtusd + rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(inDebtUSDSet).on("org", "org").select(new String[]{"org", IN_DEBT_CNY, "coloffsetcny", IN_DEBT_HKD, "coloffsethkd", IN_DEBT_USD, "coloffsetusd"}).finish();
        DataSet inDebtOtherSet = splitInGroupSet[3].groupBy(new String[]{"org"}).sum("repayamount", IN_DEBT_OTHER).sum("rowoffset").sum("coloffset", "coloffsetother").finish().updateField(IN_DEBT_OTHER, "ingroupdebtother + rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(inDebtOtherSet).on("org", "org").select(new String[]{"org", IN_DEBT_CNY, "coloffsetcny", IN_DEBT_USD, "coloffsetusd", IN_DEBT_HKD, "coloffsethkd", IN_DEBT_OTHER, "coloffsetother"}).finish();
        dataUnion = dataUnion.leftJoin(inGroupResSet).on("org", "org").select(new String[]{"org", OUT_DEBT_CNY, OUT_DEBT_HKD, OUT_DEBT_USD, OUT_DEBT_OTHER, IN_DEBT_CNY, "coloffsetcny", IN_DEBT_USD, "coloffsetusd", IN_DEBT_HKD, "coloffsethkd", IN_DEBT_OTHER, "coloffsetother", "coloffset"}).finish();
        return dataUnion;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet financeDataset, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet resultSet = orgDataSet.leftJoin(financeDataset).on("org", "org").select(ORG_SELECTFIELD.toArray(new String[0]), SUM_FIELD.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(resultSet, SUM_FIELD, "mixorgname,sortcode").addFields(new String[]{String.valueOf(currencyId), "outgroupdebtcny+ingroupdebtcny", "outgroupdebthkd+ingroupdebthkd", "outgroupdebtusd+ingroupdebtusd", "outgroupdebtother+ingroupdebtother"}, new String[]{"listcurrency", TOTAL_DEBT_CNY, TOTAL_DEBT_HKD, TOTAL_DEBT_USD, TOTAL_DEBT_OTHER}).addFields(new String[]{String.join((CharSequence)"+", OUT_GROUP_SUM_FIELD), String.join((CharSequence)"+", IN_GROUP_SUM_FIELD), String.join((CharSequence)"+", OUT_GROUP_SUM_FIELD) + "+" + String.join((CharSequence)"+", IN_GROUP_SUM_FIELD)}, new String[]{OUT_DEBT_SUBTOTAL, IN_DEBT_SUBTOTAL, "totaldebt"});
        sumDataSet = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("suborgids"))) : sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("allorgids")));
        DataSet mergeSet = this.offsetMerge(sumDataSet, SOURCE_MERGE_FIELD, MERGE_FIELD);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(mergeSet);
        DataSet totalSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, TOTAL_SUM_FIELD, Collections.singletonList("listcurrency"), "mixorgname");
        return sumDataSet.union(totalSet).addFields(new String[]{"mixorgname", "rowid"}, new String[]{"orgname", "orgid"});
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(TOTAL_SUM_FIELD);
    }
}

