/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.tmc.tda.extpoint.finance.IFinanceSourceReBuildInterface;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.data.AbstractFinDebtDistDataListPlugin;
import kd.tmc.tda.report.finance.helper.FinanceInterestBearLiaDisHelper;
import org.apache.commons.lang.StringUtils;

public class FinDebtSumDataListPlugin
extends AbstractFinDebtDistDataListPlugin {
    private static final Log logger = LogFactory.getLog(FinDebtSumDataListPlugin.class);
    private static final String IN_ENTER_DEBT = "ingroupenterdebt";
    private static final String OUT_SUBTOTAL = "outgroupsubtotal";
    private static final String IN_SUBTOTAL = "ingroupsubtotal";
    private static final String STATISTICS_TYPE = "statisticsType";
    private static final List<String> OUT_GROUP_SUM_FIELD = Arrays.asList("bankdebt", "bonddebt", "enterdebt", "otherdebt");
    private static final List<String> IN_GROUP_SUM_FIELD = Arrays.asList("finorgdebt", "settledebt", "leasedebt", "ingroupenterdebt");
    private static final List<String> SUM_FIELD = Arrays.asList("bankdebt", "bonddebt", "enterdebt", "otherdebt", "finorgdebt", "settledebt", "leasedebt", "ingroupenterdebt", "totalequity", "coloffsetfinorg", "coloffsetsettle", "coloffsetlease", "coloffsetenter", "coloffset");
    private static final List<String> MERGE_FIELD = Arrays.asList("finorgdebt", "settledebt", "leasedebt", "ingroupenterdebt", "ingroupsubtotal", "totaldebt", "totaldebtwithequity");
    private static final List<String> SOURCE_MERGE_FIELD = Arrays.asList("coloffsetfinorg", "coloffsetsettle", "coloffsetlease", "coloffsetenter", "coloffset");
    private static final List<String> TOTAL_SUM_FIELD = Arrays.asList("bankdebt", "bonddebt", "enterdebt", "finorgdebt", "settledebt", "leasedebt", "ingroupenterdebt", "otherdebt", "outgroupsubtotal", "ingroupsubtotal", "totaldebt", "totalequity", "totaldebtwithequity");

    @Override
    protected DataSet getFinanceQueryDataset(DataSet allDs, Map<String, Object> paramMap) {
        String statisticsType = (String)paramMap.get(STATISTICS_TYPE);
        if (StringUtils.isEmpty((String)statisticsType)) {
            statisticsType = FinanceStatisticTypeEnum.ALL.getValue();
        }
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        allDs = FinanceInterestBearLiaDisHelper.dealStartintdateByType(allDs, queryDate, statisticsType);
        DataSet dataUnion = allDs.copy().select(new String[]{"org", "coloffset"}).groupBy(new String[]{"org"}).sum("coloffset").finish();
        DataSet[] splitEquityDataSet = allDs.splitByFilter(new String[]{"isequity = false"}, true);
        DataSet[] splitGroupDataSet = splitEquityDataSet[0].splitByFilter(new String[]{"isoutgroup = 1"}, true);
        DataSet outGroupSet = splitGroupDataSet[0].select(new String[]{"org", "repayamount", "financetype"});
        DataSet outGroupResSet = outGroupSet.copy().select("org").groupBy(new String[]{"org"}).finish();
        DataSet[] splitOutGroupSet = outGroupSet.splitByFilter(new String[]{"financetype = 0", "financetype = 1", "financetype = 2", "financetype = 3"}, false);
        DataSet bankDebtSet = splitOutGroupSet[0].groupBy(new String[]{"org"}).sum("repayamount", "bankdebt").finish();
        outGroupResSet = outGroupResSet.leftJoin(bankDebtSet).on("org", "org").select(new String[]{"org", "bankdebt"}).finish();
        DataSet bondDebtSet = splitOutGroupSet[1].groupBy(new String[]{"org"}).sum("repayamount", "bonddebt").finish();
        outGroupResSet = outGroupResSet.leftJoin(bondDebtSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt"}).finish();
        DataSet enterDebtSet = splitOutGroupSet[2].groupBy(new String[]{"org"}).sum("repayamount", "enterdebt").finish();
        outGroupResSet = outGroupResSet.leftJoin(enterDebtSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt"}).finish();
        DataSet otherDebtSet = splitOutGroupSet[3].groupBy(new String[]{"org"}).sum("repayamount", "otherdebt").finish();
        outGroupResSet = outGroupResSet.leftJoin(otherDebtSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt", "otherdebt"}).finish();
        dataUnion = dataUnion.leftJoin(outGroupResSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt", "otherdebt", "coloffset"}).finish();
        DataSet inGroupSet = splitGroupDataSet[1];
        DataSet inGroupResSet = inGroupSet.copy().select("org").groupBy(new String[]{"org"}).finish();
        DataSet[] splitInGroupSet = inGroupSet.splitByFilter(new String[]{"sourcetype = 0 and creditortype = 'settlecenter'", "sourcetype = 2", "sourcetype = 3", "creditortype = 'fincom'"}, false);
        DataSet settleSplitInGroupSet = splitInGroupSet[0];
        DataSet finSplitInGroupSet = splitInGroupSet[3];
        DataSet leaseSplitInGroupSet = splitInGroupSet[2];
        DataSet inEnterSplitInGroupSet = splitInGroupSet[1];
        DataSet[] rebuildDataSet = this.rebuildFinAndLeaseDataSet(new DataSet[]{finSplitInGroupSet, leaseSplitInGroupSet});
        finSplitInGroupSet = rebuildDataSet[0];
        leaseSplitInGroupSet = rebuildDataSet[1];
        settleSplitInGroupSet = settleSplitInGroupSet.select(new String[]{"org", "repayamount", "sourcetype", "rowoffset", "coloffset"});
        finSplitInGroupSet = finSplitInGroupSet.select(new String[]{"org", "repayamount", "sourcetype", "rowoffset", "coloffset"});
        leaseSplitInGroupSet = leaseSplitInGroupSet.select(new String[]{"org", "repayamount", "sourcetype", "rowoffset", "coloffset"});
        inEnterSplitInGroupSet = inEnterSplitInGroupSet.select(new String[]{"org", "repayamount", "sourcetype", "rowoffset", "coloffset"});
        DataSet finOrgSet = finSplitInGroupSet.groupBy(new String[]{"org"}).sum("repayamount", "finorgdebt").sum("rowoffset").sum("coloffset", "coloffsetfinorg").finish().updateField("finorgdebt", "finorgdebt+rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(finOrgSet).on("org", "org").select(new String[]{"org", "finorgdebt", "coloffsetfinorg"}).finish();
        DataSet settleOrgSet = settleSplitInGroupSet.groupBy(new String[]{"org"}).sum("repayamount", "settledebt").sum("rowoffset").sum("coloffset", "coloffsetsettle").finish().updateField("settledebt", "settledebt+rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(settleOrgSet).on("org", "org").select(new String[]{"org", "finorgdebt", "coloffsetfinorg", "settledebt", "coloffsetsettle"}).finish();
        DataSet leaseDebtSet = leaseSplitInGroupSet.groupBy(new String[]{"org"}).sum("repayamount", "leasedebt").sum("rowoffset").sum("coloffset", "coloffsetlease").finish().updateField("leasedebt", "leasedebt+rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(leaseDebtSet).on("org", "org").select(new String[]{"org", "finorgdebt", "coloffsetfinorg", "settledebt", "coloffsetsettle", "leasedebt", "coloffsetlease"}).finish();
        DataSet inEnterDebtSet = inEnterSplitInGroupSet.groupBy(new String[]{"org"}).sum("repayamount", IN_ENTER_DEBT).sum("rowoffset").sum("coloffset", "coloffsetenter").finish().updateField(IN_ENTER_DEBT, "ingroupenterdebt+rowoffset");
        inGroupResSet = inGroupResSet.leftJoin(inEnterDebtSet).on("org", "org").select(new String[]{"org", "finorgdebt", "coloffsetfinorg", "settledebt", "coloffsetsettle", "leasedebt", "coloffsetlease", IN_ENTER_DEBT, "coloffsetenter"}).finish();
        dataUnion = dataUnion.leftJoin(inGroupResSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt", "otherdebt", "finorgdebt", "settledebt", "leasedebt", IN_ENTER_DEBT, "coloffsetfinorg", "coloffsetsettle", "coloffsetlease", "coloffsetenter", "coloffset"}).finish();
        DataSet equitySumSet = splitEquityDataSet[1].groupBy(new String[]{"org"}).sum("repayamount", "totalequity").finish();
        dataUnion = dataUnion.leftJoin(equitySumSet).on("org", "org").select(new String[]{"org", "bankdebt", "bonddebt", "enterdebt", "otherdebt", "finorgdebt", "settledebt", "leasedebt", IN_ENTER_DEBT, "totalequity", "coloffsetfinorg", "coloffsetsettle", "coloffsetlease", "coloffsetenter", "coloffset"}).finish();
        return dataUnion;
    }

    private DataSet[] rebuildFinAndLeaseDataSet(DataSet[] dataSets) {
        PluginProxy pluginProxy = PluginProxy.create(IFinanceSourceReBuildInterface.class, (String)"kd.sdk.tmc.tda.extpoint.finance.IFinanceSourceReBuildInterface");
        List result = pluginProxy.callReplace(p -> p.rebuildDataSet(dataSets));
        if (EmptyUtil.isNoEmpty((Object)result) && EmptyUtil.isNoEmpty((Object[])((Object[])result.get(0)))) {
            logger.info("\u8d22\u52a1\u516c\u53f8\u548c\u878d\u8d44\u79df\u8d41\u6570\u636e\u91cd\u7ec4\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e0d\u4e3a\u7a7a");
            return (DataSet[])result.get(0);
        }
        logger.info("\u8d22\u52a1\u516c\u53f8\u548c\u878d\u8d44\u79df\u8d41\u6570\u636e\u91cd\u7ec4\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        return dataSets;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet financeDataset, ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet resultSet = orgDataSet.leftJoin(financeDataset).on("org", "org").select(ORG_SELECTFIELD.toArray(new String[0]), SUM_FIELD.toArray(new String[0])).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(resultSet, SUM_FIELD, "mixorgname,sortcode").addFields(new String[]{String.valueOf(currencyId), String.join((CharSequence)"+", OUT_GROUP_SUM_FIELD), String.join((CharSequence)"+", IN_GROUP_SUM_FIELD)}, new String[]{"listcurrency", OUT_SUBTOTAL, IN_SUBTOTAL}).addFields(new String[]{String.join((CharSequence)"+", OUT_GROUP_SUM_FIELD) + "+" + String.join((CharSequence)"+", IN_GROUP_SUM_FIELD), String.join((CharSequence)"+", OUT_GROUP_SUM_FIELD) + "+" + String.join((CharSequence)"+", IN_GROUP_SUM_FIELD) + "+" + "totalequity"}, new String[]{"totaldebt", "totaldebtwithequity"});
        sumDataSet = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("suborgids"))) : sumDataSet.filter("rowid in orgFilter", Collections.singletonMap("orgFilter", paramMap.get("allorgids")));
        DataSet mergeSet = this.offsetMerge(sumDataSet, SOURCE_MERGE_FIELD, MERGE_FIELD);
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(mergeSet);
        DataSet totalSet = DecisionAnlsHelper.addAllTotalDataSet(sumDataSet, TOTAL_SUM_FIELD, Collections.singletonList("listcurrency"), "mixorgname");
        return sumDataSet.union(totalSet).addFields(new String[]{"mixorgname", "rowid"}, new String[]{"orgname", "orgid"});
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(TOTAL_SUM_FIELD);
    }
}

