/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceCostByBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(FinanceCostByBankDataListPlugin.class);
    private static final String AVGBALANCE_SUFFIX = "_avg";
    private static final String INTEREST_SUFFIX = "_int";
    private static final String CHANGE_FIELD = "changeField";
    private static final String ORGID = "orgid";
    private static final String BANK = "bank";
    private static final String BANK_PREFIX = "bank_";
    private static final String AVGBALANCE = "avgbalance";
    private static final String INTEREST = "interest";
    private static final String CUSTOMTYPE = "customtype";
    private static final String BANK_CATE = "bankcate";
    private static final String BANK_CATENAME = "bankcatename";
    private static final String DATE_RANGE = "dateRange";
    private static final String DATE_TYPE = "datetype";
    public static final int TOP = 6;
    private static final Long AVG_BANK = 99999999999999999L;
    private static final Long OTHER_BANK = 0L;
    private Map<Long, String> ORDER_MAP = new LinkedHashMap<Long, String>(16);

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List queryDateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        DataSet financeCostDataSet = FinanceCostDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)0L, (List)queryDateList, (boolean)true);
        financeCostDataSet = financeCostDataSet.select(new String[]{ORGID, BANK_CATE, BANK_CATENAME, DATE_TYPE, INTEREST, AVGBALANCE, "customtype as dateRange"}).filter("bankcate is not null and bankcate != 0L");
        DataSet bankDataSet = financeCostDataSet.copy().groupBy(new String[]{ORGID, DATE_TYPE, BANK_CATE, BANK_CATENAME, DATE_RANGE}).sum(AVGBALANCE).sum(INTEREST).finish();
        String avgCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceCostByBankDataLPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet weightedAverageSet = financeCostDataSet.groupBy(new String[]{ORGID, DATE_TYPE, DATE_RANGE}).sum(AVGBALANCE).sum(INTEREST).finish().select(new String[]{ORGID, DATE_TYPE, AVG_BANK + "L as " + BANK_CATE, "'" + avgCaption + "' as " + BANK_CATENAME, DATE_RANGE, AVGBALANCE, INTEREST});
        DataSet resultSet = bankDataSet.union(weightedAverageSet);
        return resultSet;
    }

    private DataSet processDataSet(DataSet orgDateSet, DataSet financeCostDataSet) {
        DataSet tempDataSet = this.topIdsByRange(financeCostDataSet, this.ORDER_MAP);
        tempDataSet = tempDataSet.addField("concat(datetype, concat('_', bankcate))", CHANGE_FIELD);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(AVGBALANCE, "avg");
        map.put(INTEREST, "int");
        tempDataSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(tempDataSet, CHANGE_FIELD, ORGID, BANK_PREFIX, map);
        List<String> countFields = this.genFieldNames("change");
        tempDataSet = DecisionAnlsHelper.addAbsentFields(tempDataSet, countFields);
        DataSet leftJoinDs = orgDateSet.leftJoin(tempDataSet).on("rowid", ORGID).select(new String[]{ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, countFields.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDs, countFields, "orgid,mixorgname,sortcode");
        sumDataSet = this.removeAllZeroRow(sumDataSet, new HashSet<String>(countFields));
        return sumDataSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        long start = System.currentTimeMillis();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String dateRange = (String)queryParam.getCustomParam().get(DATE_RANGE);
        if ((ds = ds.filter("dateRange = '" + dateRange + "'")).isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        DataSet processDataSet = this.processDataSet(orgDateSet, ds);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        DataSet filterDataSet = processDataSet;
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            filterDataSet = filterDataSet.where("orgid in ids", Collections.singletonMap("ids", subOrgIds));
        }
        filterDataSet = filterDataSet.orderBy(new String[]{"sortcode"});
        List<String> countFields = this.genFieldNames("change");
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(filterDataSet, countFields, "mixorgname");
        filterDataSet = filterDataSet.union(totalDataSet);
        List<String> calcFieldNames = this.genFieldNames("calc");
        calcFieldNames.addAll(Arrays.asList(ORGID, "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode", "sumlevel"));
        DataSet resultDataSet = filterDataSet.select(calcFieldNames.toArray(new String[0]));
        logger.info("\u878d\u8d44\u6210\u672c\u5206\u6790-\u6309\u94f6\u884c\uff08\u533a\u95f4\uff09" + orgViewId + " \u5904\u7406\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        Map queryParamMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(queryParamMap);
        String dateRange = (String)queryParam.getCustomParam().get(DATE_RANGE);
        if (EmptyUtil.isEmpty((String)dateRange)) {
            dateRange = DateRangeEnum.MONTH.getValue();
        }
        List<String> fieldNames = this.genFieldNames("target");
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
        int diff = dateRangeEnum.getEnd() - dateRangeEnum.getStart();
        LinkedHashMap<String, ReportColumnGroup> groupMap = new LinkedHashMap<String, ReportColumnGroup>();
        for (String fieldName : fieldNames) {
            String[] fieldNameSplit = fieldName.split("_");
            String dateIndex = fieldNameSplit[1];
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)groupMap.get(BANK_PREFIX + dateIndex);
            if (reportColumnGroup == null) {
                reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setFieldKey(BANK_PREFIX + dateIndex);
                String caption = FinanceCostDateHelper.getDateCaption((Date)FinanceCostDateHelper.getNewDate((Date)queryDate), (String)dateRange, (String)dateRangeEnum.getShortName(), (int)diff--);
                reportColumnGroup.setCaption(new LocaleString(caption));
                groupMap.put(BANK_PREFIX + dateIndex, reportColumnGroup);
            }
            Long bankId = Long.parseLong(fieldNameSplit[2]);
            String columnCaption = this.ORDER_MAP.get(bankId);
            if (AVG_BANK.equals(bankId)) {
                columnCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceCostByBankDataLPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
            }
            ReportColumn column = this.createColumn(fieldName, columnCaption);
            reportColumnGroup.getChildren().add(column);
        }
        groupMap.forEach((k, v) -> columns.add((AbstractReportColumn)v));
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("text");
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    private List<String> genFieldNames(String fieldType) {
        ReportQueryParam queryParam = this.getQueryParam();
        String dateRange = (String)queryParam.getCustomParam().get(DATE_RANGE);
        ArrayList<String> fieldNames = new ArrayList<String>(16);
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
        int i = dateRangeEnum.getStart();
        while (i <= dateRangeEnum.getEnd()) {
            int finalI = i++;
            this.ORDER_MAP.forEach((bankCate, bankName) -> this.getFields((List<String>)fieldNames, finalI, (Long)bankCate, fieldType));
        }
        return fieldNames;
    }

    private void getFields(List<String> fieldNames, int count, Long bankCate, String fieldType) {
        switch (fieldType) {
            case "target": {
                fieldNames.add(BANK_PREFIX + count + "_" + bankCate);
                break;
            }
            case "change": {
                fieldNames.add(BANK_PREFIX + count + "_" + bankCate + AVGBALANCE_SUFFIX);
                fieldNames.add(BANK_PREFIX + count + "_" + bankCate + INTEREST_SUFFIX);
                break;
            }
            case "calc": {
                String temp = BANK_PREFIX + count + "_" + bankCate;
                String _int = temp + INTEREST_SUFFIX;
                String _avg = temp + AVGBALANCE_SUFFIX;
                String calcStr = "case when " + _avg + " = 0.0  or " + _avg + " is null then 0 else " + _int + " *1.0 / " + _avg + " end as " + temp;
                fieldNames.add(calcStr);
                break;
            }
        }
    }

    private DataSet topIdsByRange(DataSet dataSet, Map<Long, String> orderMap) {
        Iterator tempSetIterator = (dataSet = dataSet.orderBy(new String[]{"datetype desc", "avgbalance desc"})).copy().iterator();
        if (tempSetIterator.hasNext()) {
            Row next;
            Row next1 = (Row)tempSetIterator.next();
            if (!AVG_BANK.equals(next1.getLong(BANK_CATE))) {
                orderMap.put(next1.getLong(BANK_CATE), next1.getString(BANK_CATENAME));
            }
            int dateType = next1.getInteger(DATE_TYPE);
            String bankName = null;
            while (tempSetIterator.hasNext() && (next = (Row)tempSetIterator.next()).getInteger(DATE_TYPE) == dateType && orderMap.size() < 6) {
                if (AVG_BANK.equals(next.getLong(BANK_CATE))) {
                    bankName = next.getString(BANK_CATENAME);
                    continue;
                }
                orderMap.put(next.getLong(BANK_CATE), next.getString(BANK_CATENAME));
            }
            ArrayList<Long> bankIds = new ArrayList<Long>(orderMap.keySet());
            bankIds.add(AVG_BANK);
            DataSet[] tempSets = dataSet.splitByFilter(new String[]{"bankcate in (" + TmcBusinessBaseHelper.idListToString(bankIds) + ")"}, true);
            DataSet resultSet = tempSets[0].groupBy(new String[]{ORGID, DATE_TYPE, BANK_CATE, BANK_CATENAME}).sum(AVGBALANCE).sum(INTEREST).finish();
            if (!tempSets[1].isEmpty()) {
                String avgCaption = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceCostByBankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
                DataSet otherSet = tempSets[1].groupBy(new String[]{ORGID, DATE_TYPE}).sum(AVGBALANCE).sum(INTEREST).finish();
                otherSet = otherSet.addFields(new String[]{OTHER_BANK + "L", "'" + avgCaption + "'"}, new String[]{BANK_CATE, BANK_CATENAME});
                resultSet = resultSet.union(otherSet.select(new String[]{ORGID, DATE_TYPE, BANK_CATE, BANK_CATENAME, AVGBALANCE, INTEREST}));
                orderMap.put(OTHER_BANK, avgCaption);
            }
            orderMap.put(AVG_BANK, bankName);
            return resultSet;
        }
        return DecisionAnlsHelper.createEmptyDataSet(new String[]{ORGID, DATE_TYPE, BANK_CATE, BANK_CATENAME, AVGBALANCE, INTEREST}, new DataType[]{DataType.LongType, DataType.IntegerType, DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType});
    }
}

