/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.report.ReportList;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.enums.FinanceCostTermEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceCostDetailDataListPlugin
extends AbstractDetailDataPlugin {
    @Override
    protected List<Object[]> getColumnItems() {
        ArrayList<Object[]> field = new ArrayList<Object[]>(26);
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u501f\u6b3e\u4eba/\u53d1\u884c\u4eba", (String)"FinanceCostDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"financetype1", ResManager.loadKDString((String)"\u878d\u8d44\u7c7b\u578b", (String)"FinanceCostDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("bank", ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceCostDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "bond", ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceCostDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "company", ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceCostDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "other", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceCostDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"finproductname", ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"FinanceCostDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"contractno", ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"FinanceCostDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"FinanceCostDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"textcreditor", ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"FinanceCostDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"bankcatename", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"FinanceCostDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"loantype", ResManager.loadKDString((String)"\u8d37\u6b3e\u7c7b\u578b", (String)"FinanceDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("loan", ResManager.loadKDString((String)"\u666e\u901a\u8d37\u6b3e", (String)"FinanceDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "sl", ResManager.loadKDString((String)"\u94f6\u56e2\u8d37\u6b3e", (String)"FinanceDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "ec", ResManager.loadKDString((String)"\u4f01\u4e1a\u5f80\u6765", (String)"FinanceDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "entrust", ResManager.loadKDString((String)"\u59d4\u6258\u8d37\u6b3e", (String)"FinanceDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "bond", ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "lease", ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41", (String)"FinanceDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"loantype1", ResManager.loadKDString((String)"\u671f\u9650\u7c7b\u578b", (String)"FinanceCostDetailDataListPlugin_38", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"termname", ResManager.loadKDString((String)"\u671f\u9650", (String)"FinanceCostDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"residuetermname", ResManager.loadKDString((String)"\u5269\u4f59\u671f\u9650", (String)"FinanceCostDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FinanceCostDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"FinanceCostDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"srcdrawamount", ResManager.loadKDString((String)"\u501f\u6b3e/\u53d1\u884c\u91d1\u989d", (String)"FinanceCostDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"drawamount", ResManager.loadKDString((String)"\u501f\u6b3e/\u53d1\u884c\u91d1\u989d\u6298\u62a5\u544a\u5e01", (String)"FinanceCostDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"srcprinciple", ResManager.loadKDString((String)"\u8ba1\u606f\u672c\u91d1", (String)"FinanceCostDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"principle", ResManager.loadKDString((String)"\u8ba1\u606f\u672c\u91d1\u6298\u62a5\u544a\u5e01", (String)"FinanceCostDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"intrate", ResManager.loadKDString((String)"\u5e74\u5229\u7387(%)", (String)"FinanceCostDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"customtype", ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"FinanceCostDetailDataListPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("year", ResManager.loadKDString((String)"\u5e74", (String)"FinanceCostDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "half", ResManager.loadKDString((String)"\u534a\u5e74", (String)"FinanceCostDetailDataListPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), "season", ResManager.loadKDString((String)"\u5b63", (String)"FinanceCostDetailDataListPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]), "month", ResManager.loadKDString((String)"\u6708", (String)"FinanceCostDetailDataListPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"periodname", ResManager.loadKDString((String)"\u671f\u95f4", (String)"FinanceCostDetailDataListPlugin_26", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"begindate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5", (String)"FinanceCostDetailDataListPlugin_27", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"enddate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5", (String)"FinanceCostDetailDataListPlugin_28", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"daynum", ResManager.loadKDString((String)"\u5929\u6570", (String)"FinanceCostDetailDataListPlugin_29", (String)"tmc-tda-report", (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"dayweight", ResManager.loadKDString((String)"\u5929\u6570\u6743\u91cd", (String)"FinanceCostDetailDataListPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"avgbalance", ResManager.loadKDString((String)"\u5e73\u5747\u4f59\u989d\u6298\u62a5\u544a\u5e01", (String)"FinanceCostDetailDataListPlugin_31", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"interest", ResManager.loadKDString((String)"\u9884\u8ba1\u5e74\u5229\u606f\u6298\u62a5\u544a\u5e01", (String)"FinanceCostDetailDataListPlugin_32", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"avgintrate", ResManager.loadKDString((String)"\u5e73\u5747\u5229\u7387(%)", (String)"FinanceCostDetailDataListPlugin_33", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"isoffset", ResManager.loadKDString((String)"\u662f\u5426\u62b5\u6d88", (String)"FinanceCostDetailDataListPlugin_34", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List orgIds = (List)paramMap.get("allorgids");
        final Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        List dateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        boolean splitBankCate = paramMap.get("splitBankCate") != null && (Boolean)paramMap.get("splitBankCate") != false;
        String dateRange = (String)paramMap.get("dateRange");
        DataSet ds = FinanceCostDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (List)dateList, (boolean)splitBankCate);
        if (EmptyUtil.isNotEmpty((CharSequence)dateRange)) {
            ds = ds.filter("customtype = dateRange", Collections.singletonMap("dateRange", dateRange));
        }
        ds = FinanceCostDataHelper.getFinanceMergeDataSet((DataSet)ds, (DataSet)TmcOrgDataHelper.getOrgDateSet((Long)orgViewId), (Long)orgId);
        ds = ds.addFields(new String[]{"case when rowoffset = 0.0 and coloffset = 0.0 then 0 else 1 end", "case when rowoffset = 0.0 and coloffset = 0.0 then 0 else 1 end", "case when financetype = 0 then 'bank' else case when financetype = 1 then 'bond' else case when financetype = 2 then 'company' else 'other' end end end", "''", "''", "''", "''"}, new String[]{"isoffset", "isoffsetNum", "financetype1", "loantype1", "termname", "periodname", "residuetermname"});
        ds = ds.updateFields(new String[]{"avgbalance", "interest"}, new String[]{"case when isoffset = 1 then 0.0 else avgbalance end", "case when isoffset = 1 then 0.0 else interest end"});
        final RowMeta rowMeta = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                String term = row.getString("term");
                boolean isnofixedterm = row.getBoolean("isnofixedterm");
                int termIndex = rowMeta.getFieldIndex("termname", false);
                int loanTypeIndex = rowMeta.getFieldIndex("loantype1", false);
                FinanceCostTermEnum financeCostTermEnum = FinanceCostTermEnum.matchExp((String)term);
                data[termIndex] = isnofixedterm ? ResManager.loadKDString((String)"\u65e0\u56fa\u5b9a\u671f\u9650", (String)"FinanceCostDetailDataListPlugin_40", (String)"tmc-tda-report", (Object[])new Object[0]) : financeCostTermEnum.getText().loadKDString();
                data[loanTypeIndex] = 1 == financeCostTermEnum.getIndex() || 2 == financeCostTermEnum.getIndex() || isnofixedterm ? ResManager.loadKDString((String)"\u77ed\u671f", (String)"FinanceCostDetailDataListPlugin_35", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u957f\u671f", (String)"FinanceCostDetailDataListPlugin_36", (String)"tmc-tda-report", (Object[])new Object[0]);
                if (!"lease".equals(row.getString("loantype"))) {
                    String residueterm = row.getString("residueterm");
                    int intType = row.getInteger("inttype");
                    int residuetermIndex = rowMeta.getFieldIndex("residuetermname", false);
                    Date expiredate = row.getDate("expiredate");
                    Date clearDate = row.getDate("cleardate");
                    if (isnofixedterm) {
                        if (0 == intType) {
                            if (queryDate.compareTo(clearDate) < 0 && queryDate.compareTo(expiredate) < 0) {
                                data[residuetermIndex] = ResManager.loadKDString((String)"\u65e0\u56fa\u5b9a\u671f\u9650", (String)"FinanceCostDetailDataListPlugin_40", (String)"tmc-tda-report", (Object[])new Object[0]);
                            } else if (queryDate.compareTo(clearDate) < 0 && queryDate.compareTo(expiredate) >= 0) {
                                data[residuetermIndex] = ResManager.loadKDString((String)"\u5df2\u7ed3\u6e05", (String)"FinanceCostDetailDataListPlugin_37", (String)"tmc-tda-report", (Object[])new Object[0]);
                            } else if (queryDate.compareTo(clearDate) >= 0 && clearDate.compareTo(expiredate) <= 0) {
                                data[residuetermIndex] = ResManager.loadKDString((String)"\u5df2\u7ed3\u6e05", (String)"FinanceCostDetailDataListPlugin_37", (String)"tmc-tda-report", (Object[])new Object[0]);
                            } else if (queryDate.compareTo(clearDate) >= 0 && clearDate.compareTo(expiredate) > 0) {
                                data[residuetermIndex] = ResManager.loadKDString((String)"\u903e\u671f", (String)"FinanceCostDetailDataListPlugin_39", (String)"tmc-tda-report", (Object[])new Object[0]);
                            }
                        } else {
                            data[residuetermIndex] = queryDate.compareTo(expiredate) <= 0 ? ResManager.loadKDString((String)"\u65e0\u56fa\u5b9a\u671f\u9650", (String)"FinanceCostDetailDataListPlugin_40", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u903e\u671f", (String)"FinanceCostDetailDataListPlugin_39", (String)"tmc-tda-report", (Object[])new Object[0]);
                        }
                    } else if (queryDate.compareTo(expiredate) < 0) {
                        FinanceCostTermEnum financeCostResidueTermIndexEnum = FinanceCostTermEnum.matchExp((String)residueterm);
                        data[residuetermIndex] = financeCostResidueTermIndexEnum.getText().loadKDString();
                    } else {
                        data[residuetermIndex] = 0 == intType ? ResManager.loadKDString((String)"\u5df2\u7ed3\u6e05", (String)"FinanceCostDetailDataListPlugin_37", (String)"tmc-tda-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u903e\u671f", (String)"FinanceCostDetailDataListPlugin_39", (String)"tmc-tda-report", (Object[])new Object[0]);
                    }
                }
                Integer dateType = row.getInteger("datetype");
                String dateRange = row.getString("customtype");
                DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
                int diff = dateRangeEnum.getEnd() - dateType;
                String dateCaption = FinanceCostDateHelper.getDateCaption((Date)FinanceCostDateHelper.getNewDate((Date)queryDate), (String)dateRange, (String)dateRangeEnum.getShortName(), (int)diff);
                int periodNameIndex = rowMeta.getFieldIndex("periodname", false);
                data[periodNameIndex] = dateCaption;
                Date endDate = row.getDate("enddate");
                int endDateIndex = rowMeta.getFieldIndex("enddate");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDate);
                calendar.add(5, 1);
                endDate = calendar.getTime();
                data[endDateIndex] = endDate;
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        ds = ds.select("id,company,financetype1,finproductname,contractno,billno,textcreditor,bankcatename,loantype,loantype1,termname,residuetermname,currencyname,rate,srcdrawamount,drawamount,srcprinciple,principle,intrate,customtype,periodname,begindate,enddate,daynum,dayweight,avgbalance,interest,isoffsetNum,isoffset").orderBy(new String[]{"billno", "principle", "intrate", "periodname", "enddate"});
        RowMeta resultMeta = ds.getRowMeta();
        String[] newFieldNames = resultMeta.getFieldNames();
        DataSetBuilder builder = Algo.create((String)"FinanceCostDetailDataListPlugin.rebuildduplicate").createDataSetBuilder(resultMeta);
        ArrayList<Object[]> rowTranToList = new ArrayList<Object[]>(10);
        for (Row row : ds) {
            Object[] newRow = new Object[newFieldNames.length];
            for (int i = 0; i < newFieldNames.length; ++i) {
                newRow[i] = row.get(newFieldNames[i]);
            }
            rowTranToList.add(newRow);
        }
        int billnoIndex = this.getFieldIndex(newFieldNames, "billno");
        int principleIndex = this.getFieldIndex(newFieldNames, "principle");
        int intrateIndex = this.getFieldIndex(newFieldNames, "intrate");
        int periodNameIndex = this.getFieldIndex(newFieldNames, "periodname");
        int benginDateIndex = this.getFieldIndex(newFieldNames, "begindate");
        int endDateIndex = this.getFieldIndex(newFieldNames, "enddate");
        int daysIndex = this.getFieldIndex(newFieldNames, "daynum");
        int dayWeightIndex = this.getFieldIndex(newFieldNames, "dayweight");
        int avgBalanceIndex = this.getFieldIndex(newFieldNames, "avgbalance");
        int interestIndex = this.getFieldIndex(newFieldNames, "interest");
        Map<String, List<Object[]>> groupBySameInfo = rowTranToList.stream().collect(Collectors.groupingBy(r -> String.join((CharSequence)"-", (String)r[billnoIndex], ((BigDecimal)r[principleIndex]).toPlainString(), ((BigDecimal)r[intrateIndex]).toPlainString(), (String)r[periodNameIndex])));
        for (List<Object[]> groupSameList : groupBySameInfo.values()) {
            Collections.sort(groupSameList, Comparator.comparing(arr -> (Date)arr[endDateIndex]));
            Object startDate = groupSameList.get(0)[benginDateIndex];
            Integer newDays = groupSameList.stream().map(arr -> (Integer)arr[daysIndex]).reduce(0, Integer::sum);
            BigDecimal newDayWeight = groupSameList.stream().map(arr -> (BigDecimal)arr[dayWeightIndex]).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal newAvgBalance = groupSameList.stream().map(arr -> (BigDecimal)arr[avgBalanceIndex]).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal newInterest = groupSameList.stream().map(arr -> (BigDecimal)arr[interestIndex]).reduce(BigDecimal.ZERO, BigDecimal::add);
            Object[] newBuildRow = groupSameList.get(groupSameList.size() - 1);
            newBuildRow[benginDateIndex] = startDate;
            newBuildRow[daysIndex] = newDays;
            newBuildRow[dayWeightIndex] = newDayWeight;
            newBuildRow[avgBalanceIndex] = newAvgBalance;
            newBuildRow[interestIndex] = newInterest;
            builder.append(newBuildRow);
        }
        return builder.build();
    }

    private int getFieldIndex(String[] fieldNames, String fieldName) {
        for (int i = 0; i < fieldNames.length; ++i) {
            if (!fieldName.equals(fieldNames[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected List<String> getOrderByList() {
        return Arrays.asList("billno", "periodname", "begindate");
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("avgbalance", "interest");
    }

    @Override
    protected Set<String> getCovertList() {
        return new HashSet<String>(Arrays.asList("principle", "drawamount", "avgbalance", "interest"));
    }

    @Override
    protected String getCountField() {
        return "isoffsetNum";
    }

    @Override
    protected Boolean getIsRemoveNoDataFlag() {
        return Boolean.FALSE;
    }

    @Override
    protected String getNotNullFilterStr() {
        String filterStr = this.getFilterStr(this.getSumLists());
        return filterStr + " or (isoffsetNum != 0)";
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("billno", "id");
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String loantype = rowData.getString("loantype");
            String linkEntity = "cfm_loanbill";
            if ("loan".equals(loantype) || "sl".equals(loantype)) {
                linkEntity = "cfm_loanbill_b_l";
            } else if ("ec".equals(loantype) || "entrust".equals(loantype)) {
                linkEntity = "cfm_loanbill_e_l";
            } else if ("bond".equals(loantype)) {
                linkEntity = "cfm_loanbill_bond";
            } else if ("lease".equals(loantype)) {
                linkEntity = "fl_leasecontractbill";
            }
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    @Override
    protected DataSet beforeReturn(DataSet result) {
        return result.addField("case when avgbalance is null or avgbalance = 0 then 0 else interest*100/avgbalance end", "avgintrate");
    }
}

