/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.enums.FinanceTypeEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceCostTypeSectionDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ROWID = "rowid";
    private static final String AMOUNT = "amount";
    private static final String FINANCE_TYPE = "financetype";
    private static final String AMOUNT_FIELD_NAMES = "amountFieldNames";
    private static final String PROFIT_FIELD_NAMES = "profitFieldNames";

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        List dateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        DataSet allDs = FinanceCostDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (List)dateList);
        allDs = allDs.select("orgid,orgid company,creditorinnerorg,customtype,financetype,datetype,avgbalance,intrate");
        DataSet orgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        allDs = FinanceCostDataHelper.getFinanceMergeDataSet((DataSet)allDs, (DataSet)orgDataSet, (Long)orgId);
        allDs = allDs.updateField("avgbalance", "avgbalance + rowoffset");
        return allDs.groupBy(new String[]{"orgid", "customtype", FINANCE_TYPE, "datetype"}).sum("avgbalance", AMOUNT).sum("avgbalance*intrate", "rateamount").sum("coloffset", "amountcoloffset").sum("coloffset*intrate", "rateamountcoloffset").finish();
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        ds = ds.filter("customtype='" + this.getCustomType(paramMap) + "'");
        ds = this.buildAmountFields(ds, paramMap);
        GroupbyDataSet groupbyDs = ds.groupBy(new String[]{"orgid"});
        for (String fieldName : ds.getRowMeta().getFieldNames()) {
            if (!fieldName.endsWith(AMOUNT) && !fieldName.endsWith("coloffset")) continue;
            groupbyDs.sum(fieldName);
        }
        ds = groupbyDs.finish();
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        List<String> sumFields = FinanceCostTypeSectionDataListPlugin.getSumField(ds);
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet orgJoinSet = orgDateSet.leftJoin(ds).on(ROWID, "orgid").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
        ds = this.getSumDataSetByLevel(orgJoinSet, sumFields, "sortcode,orgid,mixorgname");
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        ds = EmptyUtil.isEmpty((Collection)subOrgIds) ? ds.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")) : ds.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds));
        ds = this.removeAllZeroRow(ds, new HashSet<String>(sumFields));
        ds = ds.orderBy(new String[]{"sortcode"}).addField("'groupcol'", "groupcol");
        DataSet totalSet = this.addSubTotalDataSet(ds, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        totalSet = this.offsetTotalDataSet(totalSet, paramMap);
        DataSet resultDs = ds.union(totalSet);
        return this.buildProfitFields(resultDs, paramMap, param);
    }

    private DataSet buildAmountFields(DataSet ds, Map<String, Object> paramMap) {
        int[] dateTypes = this.getDateTypes(paramMap);
        List<Integer> financeTypes = this.getFinanceTypes(ds);
        boolean isCalculateAverage = financeTypes.size() > 1;
        int size = isCalculateAverage ? 4 * dateTypes.length * (financeTypes.size() + 1) : 4 * dateTypes.length * financeTypes.size();
        String[] amountFieldNames = new String[size];
        String[] amountFieldValues = new String[size];
        int i = 0;
        for (int dateType : dateTypes) {
            for (int financeType : financeTypes) {
                amountFieldNames[i] = dateType + "_" + financeType + "_amount";
                amountFieldNames[i + 1] = dateType + "_" + financeType + "_rateamount";
                amountFieldNames[i + 2] = dateType + "_" + financeType + "_amountcoloffset";
                amountFieldNames[i + 3] = dateType + "_" + financeType + "_rateamountcoloffset";
                amountFieldValues[i] = "case when datetype=" + dateType + " and financetype=" + financeType + " then amount else 0.0 end";
                amountFieldValues[i + 1] = "case when datetype=" + dateType + " and financetype=" + financeType + " then rateamount else 0.0 end";
                amountFieldValues[i + 2] = "case when datetype=" + dateType + " and financetype=" + financeType + " then amountcoloffset else 0.0 end";
                amountFieldValues[i + 3] = "case when datetype=" + dateType + " and financetype=" + financeType + " then rateamountcoloffset else 0.0 end";
                i += 4;
            }
            if (!isCalculateAverage) continue;
            amountFieldNames[i] = dateType + "_" + FinanceTypeEnum.AVERAGE.getNumber() + "_amount";
            amountFieldNames[i + 1] = dateType + "_" + FinanceTypeEnum.AVERAGE.getNumber() + "_rateamount";
            amountFieldNames[i + 2] = dateType + "_" + FinanceTypeEnum.AVERAGE.getNumber() + "_amountcoloffset";
            amountFieldNames[i + 3] = dateType + "_" + FinanceTypeEnum.AVERAGE.getNumber() + "_rateamountcoloffset";
            amountFieldValues[i] = "case when datetype=" + dateType + " then amount else 0.0 end";
            amountFieldValues[i + 1] = "case when datetype=" + dateType + " then rateamount else 0.0 end";
            amountFieldValues[i + 2] = "case when datetype=" + dateType + " then amountcoloffset else 0.0 end";
            amountFieldValues[i + 3] = "case when datetype=" + dateType + " then rateamountcoloffset else 0.0 end";
            i += 4;
        }
        paramMap.put(AMOUNT_FIELD_NAMES, amountFieldNames);
        return ds.addFields(amountFieldValues, amountFieldNames);
    }

    private DataSet offsetTotalDataSet(DataSet totalSet, Map<String, Object> paramMap) {
        Object[] amountFieldNames = (String[])paramMap.get(AMOUNT_FIELD_NAMES);
        if (EmptyUtil.isEmpty((Object[])amountFieldNames)) {
            return totalSet;
        }
        int size = amountFieldNames.length / 4;
        String[] fieldNames = new String[2 * size];
        String[] fieldValues = new String[2 * size];
        for (int i = 0; i < size; ++i) {
            Object amountName = amountFieldNames[4 * i];
            Object rateAmountName = amountFieldNames[4 * i + 1];
            Object amountColOffSetName = amountFieldNames[4 * i + 2];
            Object rateAmountColOffSetName = amountFieldNames[4 * i + 3];
            fieldNames[2 * i] = amountName;
            fieldNames[2 * i + 1] = rateAmountName;
            fieldValues[2 * i] = (String)amountName + "+" + (String)amountColOffSetName;
            fieldValues[2 * i + 1] = (String)rateAmountName + "+" + (String)rateAmountColOffSetName;
        }
        return totalSet.updateFields(fieldNames, fieldValues);
    }

    private DataSet buildProfitFields(DataSet ds, Map<String, Object> paramMap, ReportQueryParam param) {
        Object[] amountFieldNames = (String[])paramMap.get(AMOUNT_FIELD_NAMES);
        if (EmptyUtil.isNoEmpty((Object[])amountFieldNames)) {
            int size = amountFieldNames.length / 4;
            String[] profitFieldNames = new String[size];
            String[] profitFieldValues = new String[size];
            for (int i = 0; i < size; ++i) {
                Object amountName = amountFieldNames[4 * i];
                Object rateAmountName = amountFieldNames[4 * i + 1];
                profitFieldNames[i] = ((String)amountName).substring(0, ((String)amountName).lastIndexOf("_")) + "_profit";
                String s = String.format("case when (%1$s is null or %1$s=0) then 0.00 else round(%2$s/%1$s, 2) end", amountName, rateAmountName);
                profitFieldValues[i] = "concat(" + s + ", '%')";
            }
            param.getCustomParam().put(PROFIT_FIELD_NAMES, profitFieldNames);
            return ds.addFields(profitFieldValues, profitFieldNames);
        }
        return ds;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        Object[] profitFieldNames = (String[])this.getQueryParam().getCustomParam().get(PROFIT_FIELD_NAMES);
        if (EmptyUtil.isEmpty((Object[])profitFieldNames)) {
            return columns;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String[] dateTypeArray = FinanceCostDateHelper.parseNewDateType((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        Map<String, String> typeNameMap = this.financeTypeNameMap();
        LinkedHashMap<String, ReportColumnGroup> allColumnGroupMap = new LinkedHashMap<String, ReportColumnGroup>(32);
        HashSet<Object> allProfitColumns = new HashSet<Object>(8);
        for (Object profitFieldName : profitFieldNames) {
            ReportColumnGroup group;
            if (allProfitColumns.contains(profitFieldName)) continue;
            allProfitColumns.add(profitFieldName);
            String[] splits = ((String)profitFieldName).split("_");
            String dateStr = splits[0];
            String type = splits[1];
            if (allColumnGroupMap.containsKey(dateStr)) {
                group = (ReportColumnGroup)allColumnGroupMap.get(dateStr);
            } else {
                group = new ReportColumnGroup();
                group.setHideSingleColumnRow(false);
                group.setFieldKey(dateStr);
                if (dateStr != null) {
                    group.setCaption(new LocaleString(dateTypeArray[Integer.parseInt(dateStr)]));
                } else {
                    group.setCaption(new LocaleString(""));
                }
                allColumnGroupMap.put(dateStr, group);
            }
            ReportColumn newCol = new ReportColumn();
            newCol.setHideSingleColumnRow(false);
            newCol.setFieldKey((String)profitFieldName);
            newCol.setFieldType("text");
            newCol.setCaption(new LocaleString(typeNameMap.get(type)));
            ColumnStyle style = new ColumnStyle();
            style.setTextAlign("right");
            newCol.setStyle(style);
            group.getChildren().add(newCol);
        }
        columns.addAll(allColumnGroupMap.values());
        return columns;
    }

    private static List<String> getSumField(DataSet ds) {
        ArrayList<String> sumField = new ArrayList<String>(64);
        for (String fieldName : ds.getRowMeta().getFieldNames()) {
            if (!fieldName.endsWith(AMOUNT) && !fieldName.endsWith("coloffset")) continue;
            sumField.add(fieldName);
        }
        return sumField;
    }

    private int[] getDateTypes(Map<String, Object> paramMap) {
        String customType = this.getCustomType(paramMap);
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)customType);
        int start = dateRangeEnum.getStart();
        int end = dateRangeEnum.getEnd();
        int length = end - start + 1;
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = start++;
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> getFinanceTypes(DataSet ds) {
        ArrayList<Integer> financeTypes = new ArrayList<Integer>(6);
        try (DataSet copy = null;){
            copy = ds.copy().groupBy(new String[]{FINANCE_TYPE}).finish();
            while (copy.hasNext()) {
                Row row = copy.next();
                Integer financeType = row.getInteger(FINANCE_TYPE);
                if (financeType == null) continue;
                financeTypes.add(financeType);
            }
            ArrayList<Integer> arrayList = financeTypes;
            return arrayList;
        }
    }

    private Map<String, String> financeTypeNameMap() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put(FinanceTypeEnum.BANK.getNumber(), FinanceTypeEnum.BANK.getText());
        map.put(FinanceTypeEnum.BOND.getNumber(), FinanceTypeEnum.BOND.getText());
        map.put(FinanceTypeEnum.COMPANY.getNumber(), FinanceTypeEnum.COMPANY.getText());
        map.put(FinanceTypeEnum.OTHER.getNumber(), FinanceTypeEnum.OTHER.getText());
        map.put(FinanceTypeEnum.AVERAGE.getNumber(), FinanceTypeEnum.AVERAGE.getText());
        return map;
    }

    private String getCustomType(Map<String, Object> paramMap) {
        String type = (String)paramMap.get("customtype");
        if (EmptyUtil.isNoEmpty((String)type) && (DateRangeEnum.YEAR.getValue().equals(type) || DateRangeEnum.HALF_YEAR.getValue().equals(type) || DateRangeEnum.SEASON.getValue().equals(type) || DateRangeEnum.MONTH.getValue().equals(type))) {
            return type;
        }
        return DateRangeEnum.MONTH.getValue();
    }
}

