/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import com.alibaba.fastjson.JSONArray;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceDebtOtherBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String BANK_NAME = "fbankname";
    private static final String AMOUNT = "drawamount";
    private static final String COMPANY = "orgid";
    private static final int TOP_NUMBER = 10;
    private static final String DEBT_QUANTITY_REGION_TYPE = "debtquantityregiontype";

    @Override
    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DynamicObject orgView = (DynamicObject)paramMap.get("orgview");
        long orgViewId = orgView.getLong("id");
        String orgViewNumber = orgView.getString("number");
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        List allOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(orgId), (boolean)true, (boolean)true);
        DataSet ds = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)allOrgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        ds = ds.select("creditortype,bankcate,repayamount drawamount,region,org orgid,isequity").filter("isequity=false and creditortype='bank' and bankcate>0");
        QFilter filter = new QFilter("id", "in", this.getFinOrgIds(ds));
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)this.createAlgoKey("bankcgsetting"), (String)"bd_bankcgsetting", (String)"id,name fbankname", (QFilter[])filter.toArray(), null);
        ds = ds.leftJoin(finOrgDs).on("bankcate", "id").select(new String[]{BANK_NAME}, ds.getRowMeta().getFieldNames()).finish();
        return ds.groupBy(new String[]{COMPANY, BANK_NAME, "region"}).sum(AMOUNT).finish();
    }

    private Set<Long> getFinOrgIds(DataSet ds) {
        return DecisionCommonHelper.getFieldValues((DataSet)ds.copy(), (String)"bankcate", Long.class);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        ds = this.handleDataSet(ds, paramMap);
        String currentOrgId = (String)paramMap.get("current_org_id");
        String orgViewNumber = ((DynamicObject)paramMap.get("orgview")).getString("number");
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)orgViewNumber, Collections.singletonList(Long.valueOf(currentOrgId)), (boolean)true, (boolean)true);
        Long orgId = Long.valueOf(paramMap.get("parent_id").toString());
        if (EmptyUtil.isNoEmpty((String)currentOrgId) && currentOrgId.equals("" + orgId)) {
            subOrgIds.remove(orgId);
        }
        ds = ds.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("drawamount>0");
        ds = ds.groupBy(new String[]{BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"drawamount DESC"});
        DataSet sumDs = ds.copy().updateField(BANK_NAME, ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"CashCateFinanceDateListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{BANK_NAME}).sum(AMOUNT).finish();
        return ds.select("fbankname,drawamount").union(sumDs);
    }

    private DataSet handleDataSet(DataSet ds, Map<String, Object> paramMap) {
        ds = this.regionFilter(ds, paramMap);
        DataSet topBankTempDs = ds.copy().filter("fbankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"drawamount DESC"}).top(10);
        Set<String> topBanks = DecisionAnlsHelper.getTopBanks(topBankTempDs, BANK_NAME);
        DataSet noTopBankDs = ds.copy().filter(DecisionAnlsHelper.buildOtherFilter(topBanks, BANK_NAME));
        return noTopBankDs.groupBy(new String[]{COMPANY, BANK_NAME}).sum(AMOUNT).finish();
    }

    private DataSet regionFilter(DataSet ds, Map<String, Object> paramMap) {
        String regionType = this.getRegionType(paramMap);
        if (AcctDisplayByBankTypeEnum.ALL.getValue().equals(regionType)) {
            return ds;
        }
        ds = AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(regionType) ? ds.filter("region=1") : ds.filter("region=0");
        return ds;
    }

    private String getRegionType(Map<String, Object> paramMap) {
        JSONArray type = (JSONArray)paramMap.get(DEBT_QUANTITY_REGION_TYPE);
        if (type != null && type.size() <= 1) {
            String s = type.get(0).toString();
            if (AcctDisplayByBankTypeEnum.OVERSEAS.getValue().equals(s) || AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(s)) {
                return s;
            }
        }
        return AcctDisplayByBankTypeEnum.ALL.getValue();
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }
}

