/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceDebtQuantityDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String BANK_NAME = "fbankname";
    private static final String AMOUNT = "drawamount";
    private static final String COMPANY = "orgid";
    private static final String ROWID = "rowid";
    private static final int TOP_NUMBER = 10;
    private static final String DEBT_QUANTITY_REGION_TYPE = "debtquantityregiontype";
    private static final String PREFIX = "fbank_";
    private List<String> sumFields;
    private List<String> topBanks;

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        ds = ds.select("creditortype,bankcate,repayamount drawamount,region,org orgid,isequity").filter("isequity=false and creditortype='bank' and bankcate>0");
        QFilter filter = new QFilter("id", "in", this.getFinOrgIds(ds));
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)this.createAlgoKey("bankcgsetting"), (String)"bd_bankcgsetting", (String)"id,name fbankname", (QFilter[])filter.toArray(), null);
        ds = ds.leftJoin(finOrgDs).on("bankcate", "id").select(new String[]{BANK_NAME}, ds.getRowMeta().getFieldNames()).finish();
        return ds.filter("orgid IS NOT NULL").groupBy(new String[]{COMPANY, BANK_NAME, "region"}).sum(AMOUNT).finish();
    }

    private Set<Long> getFinOrgIds(DataSet ds) {
        return DecisionCommonHelper.getFieldValues((DataSet)ds.copy(), (String)"bankcate", Long.class);
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        ds = this.handleDataSet(ds, paramMap);
        ds = this.ChangeRowToColDataSet(ds, BANK_NAME, COMPANY, PREFIX);
        List<String> sumFields = this.getSumField(ds);
        DataSet allDs = orgDs.leftJoin(ds).on(ROWID, COMPANY).select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, sumFields, "mixorgname,orgid,sortcode");
        int hashCode = ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"DraftBillAccepterBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]).hashCode();
        if (hashCode < 0) {
            hashCode *= -1;
        }
        sumFields.remove(PREFIX + hashCode);
        sumDataSet = !sumFields.isEmpty() ? sumDataSet.addField(String.join((CharSequence)"+", sumFields), "stat") : sumDataSet.addField("0.00", "stat");
        if (sumFields.size() > 10) {
            sumFields.add(PREFIX + hashCode);
        }
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat>0");
        sumDataSet = sumDataSet.addField("'groupcol'", "groupcol");
        sumFields.add("stat");
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(totalSet);
        for (String sumField : sumFields) {
            String fieldName = sumField + "rate";
            sumDataSet = sumDataSet.addField("CONCAT(ROUND(" + sumField + "/stat*100, 2), '%')", fieldName);
            sumDataSet = sumDataSet.updateField(fieldName, String.format("case when %1$s ='%2$s' then '%3$s' else %1$s end", fieldName, "%", "0.00%"));
        }
        return sumDataSet;
    }

    private DataSet handleDataSet(DataSet ds, Map<String, Object> paramMap) {
        ds = this.regionFilter(ds, paramMap);
        DataSet topBankTempDs = ds.copy().filter("fbankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"drawamount DESC"}).top(10);
        Set<String> topBankSet = DecisionAnlsHelper.getTopBanks(topBankTempDs, BANK_NAME);
        this.getQueryParam().getCustomParam().put("topBankNames", new ArrayList<String>(topBankSet));
        DataSet topBankDs = ds.copy().filter("fbankname IS NOT NULL").filter(DecisionAnlsHelper.buildContainFilter(topBankSet, BANK_NAME)).groupBy(new String[]{COMPANY, BANK_NAME}).sum(AMOUNT).finish();
        DataSet noTopBankDs = ds.filter(DecisionAnlsHelper.buildOtherFilter(topBankSet, BANK_NAME));
        noTopBankDs = noTopBankDs.groupBy(new String[]{COMPANY, BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"drawamount DESC"});
        DataSet otherBankSet = noTopBankDs.copy().updateField(BANK_NAME, ResManager.loadKDString((String)"'\u5176\u4ed6\u94f6\u884c'", (String)"AbstractDraftBillAccepterBankPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0])).groupBy(new String[]{COMPANY, BANK_NAME}).sum(AMOUNT).finish();
        noTopBankDs = noTopBankDs.union(otherBankSet);
        topBankDs = topBankDs.union(noTopBankDs).addField(AMOUNT, "count");
        return topBankDs;
    }

    private DataSet regionFilter(DataSet ds, Map<String, Object> paramMap) {
        String regionType = this.getRegionType(paramMap);
        if (AcctDisplayByBankTypeEnum.ALL.getValue().equals(regionType)) {
            return ds;
        }
        ds = AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(regionType) ? ds.filter("region=1") : ds.filter("region=0");
        return ds;
    }

    private String getRegionType(Map<String, Object> paramMap) {
        JSONArray type = (JSONArray)paramMap.get(DEBT_QUANTITY_REGION_TYPE);
        if (type != null && type.size() <= 1) {
            String s = type.get(0).toString();
            if (AcctDisplayByBankTypeEnum.OVERSEAS.getValue().equals(s) || AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(s)) {
                return s;
            }
        }
        return AcctDisplayByBankTypeEnum.ALL.getValue();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportQueryParam queryParam = this.getQueryParam();
        this.topBanks = this.getTopBanks(queryParam);
        List top10BankNames = (List)this.getQueryParam().getCustomParam().get("topBankNames");
        String otherBankName = ResManager.loadKDString((String)"\u5176\u4ed6\u94f6\u884c", (String)"DraftBillAccepterBankDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]);
        if (this.topBanks.size() > top10BankNames.size()) {
            this.topBanks.add(otherBankName);
        }
        HashSet<Integer> hashCodes = new HashSet<Integer>(32);
        String debtAmountName = ResManager.loadKDString((String)"\u501f\u6b3e\u4f59\u989d", (String)"FinanceDebtQuantityDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
        String rateName = ResManager.loadKDString((String)"\u6bd4\u4f8b", (String)"FinanceDebtQuantityDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]);
        Boolean isShowAll = (Boolean)this.getQueryParam().getCustomParam().get("isShowAll");
        for (String topBank : this.topBanks) {
            int hashCode = this.getHashCode(hashCodes, topBank);
            hashCodes.add(hashCode);
            String bankSign = PREFIX + hashCode;
            ReportColumnGroup group = this.createReportColumnGroup(bankSign + "group", topBank);
            ReportColumn reportColumn = this.createReportColumn(bankSign, debtAmountName);
            if (otherBankName.equals(topBank)) {
                reportColumn.setHyperlink(true);
            }
            if (!top10BankNames.isEmpty() && !top10BankNames.contains(topBank)) {
                if (isShowAll != null && isShowAll.booleanValue()) {
                    reportColumn.setHide(false);
                    if (otherBankName.equals(topBank)) {
                        reportColumn.setHide(true);
                    }
                } else {
                    reportColumn.setHide(true);
                    if (otherBankName.equals(topBank)) {
                        reportColumn.setHide(false);
                    }
                }
            }
            group.getChildren().add(reportColumn);
            ReportColumn rateColumn = this.createReportColumn(bankSign + "rate", rateName, "text");
            if (!top10BankNames.isEmpty() && !top10BankNames.contains(topBank)) {
                if (isShowAll != null && isShowAll.booleanValue()) {
                    rateColumn.setHide(false);
                    if (otherBankName.equals(topBank)) {
                        rateColumn.setHide(true);
                    }
                } else {
                    rateColumn.setHide(true);
                    if (otherBankName.equals(topBank)) {
                        rateColumn.setHide(false);
                    }
                }
            }
            group.getChildren().add(rateColumn);
            columns.add((AbstractReportColumn)group);
        }
        columns.add((AbstractReportColumn)this.createReportColumn("stat", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"DraftBillAccepterBankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])));
        return columns;
    }

    private ReportColumn createReportColumn(String fieldKey, String caption, String reportColumnType) {
        ReportColumn column = new ReportColumn();
        column.setFieldKey(fieldKey);
        column.setFieldType(reportColumnType);
        column.setZeroShow(true);
        column.setCaption(new LocaleString(caption));
        column.setScale(2);
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign("right");
        column.setStyle(style);
        return column;
    }

    private ReportColumn createReportColumn(String fieldKey, String caption) {
        return this.createReportColumn(fieldKey, caption, "decimal");
    }

    private ReportColumnGroup createReportColumnGroup(String fieldKey, String caption) {
        ReportColumnGroup group = new ReportColumnGroup();
        group.setFieldKey(fieldKey);
        group.setCaption(new LocaleString(caption));
        return group;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(32);
        if (this.sumFields != null && !this.sumFields.isEmpty()) {
            fields.addAll(this.sumFields);
        }
        fields.add("stat");
        return fields;
    }

    private List<String> getSumField(DataSet result) {
        if (this.sumFields != null && !this.sumFields.isEmpty()) {
            return this.sumFields;
        }
        this.sumFields = new ArrayList<String>(32);
        for (String fieldName : result.getRowMeta().getFieldNames()) {
            if (!fieldName.startsWith(PREFIX)) continue;
            this.sumFields.add(fieldName);
        }
        return this.sumFields;
    }

    private List<String> getTopBanks(ReportQueryParam param) {
        this.topBanks = new ArrayList<String>(32);
        DataSet ds = this.queryDataSet(param);
        Map paramMap = this.transQueryParam(param);
        ds = this.regionFilter(ds, paramMap);
        DataSet topBankDs = ds.filter("fbankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"drawamount DESC"});
        while (topBankDs.hasNext()) {
            Row row = topBankDs.next();
            this.topBanks.add(row.getString(BANK_NAME));
        }
        return this.topBanks;
    }
}

