/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDetailDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceTermDateHelper;

public class FinanceDetailDataListPlugin
extends AbstractDetailDataPlugin {
    private static final String DEBT_QUANTITY_REGION_TYPE = "debtquantityregiontype";

    @Override
    protected List<Object[]> getColumnItems() {
        ArrayList<Object[]> field = new ArrayList<Object[]>(40);
        field.add(new Object[]{"orgname", ResManager.loadKDString((String)"\u501f\u6b3e\u4eba/\u53d1\u884c\u4eba", (String)"FinanceDetailDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"billno", ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"FinanceDetailDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"contractno", ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"FinanceDetailDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"contractname", ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"FinanceDetailDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"financemode1", ResManager.loadKDString((String)"\u878d\u8d44\u65b9\u5f0f", (String)"FinanceDetailDataListPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("a", ResManager.loadKDString((String)"\u95f4\u63a5\u878d\u8d44", (String)"FinanceDetailDataListPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), "b", ResManager.loadKDString((String)"\u76f4\u63a5\u878d\u8d44", (String)"FinanceDetailDataListPlugin_87", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"financetype1", ResManager.loadKDString((String)"\u878d\u8d44\u7c7b\u578b", (String)"FinanceDetailDataListPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("bank", ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceDetailDataListPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), "bond", ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceDetailDataListPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), "company", ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceDetailDataListPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), "other", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceDetailDataListPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"loantype", ResManager.loadKDString((String)"\u8d37\u6b3e\u7c7b\u578b", (String)"FinanceDetailDataListPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("loan", ResManager.loadKDString((String)"\u666e\u901a\u8d37\u6b3e", (String)"FinanceDetailDataListPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), "sl", ResManager.loadKDString((String)"\u94f6\u56e2\u8d37\u6b3e", (String)"FinanceDetailDataListPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), "ec", ResManager.loadKDString((String)"\u4f01\u4e1a\u5f80\u6765", (String)"FinanceDetailDataListPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), "entrust", ResManager.loadKDString((String)"\u59d4\u6258\u8d37\u6b3e", (String)"FinanceDetailDataListPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), "bond", ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceDetailDataListPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0]), "lease", ResManager.loadKDString((String)"\u878d\u8d44\u79df\u8d41", (String)"FinanceDetailDataListPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"finproductname", ResManager.loadKDString((String)"\u878d\u8d44\u54c1\u79cd", (String)"FinanceDetailDataListPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"creditortype", ResManager.loadKDString((String)"\u503a\u6743\u4eba\u7c7b\u578b", (String)"FinanceDetailDataListPlugin_19", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("innerunit", ResManager.loadKDString((String)"\u5185\u90e8\u5355\u4f4d", (String)"FinanceDetailDataListPlugin_20", (String)"tmc-tda-report", (Object[])new Object[0]), "bank", ResManager.loadKDString((String)"\u94f6\u884c", (String)"FinanceDetailDataListPlugin_21", (String)"tmc-tda-report", (Object[])new Object[0]), "finorg", ResManager.loadKDString((String)"\u975e\u94f6\u884c\u91d1\u878d\u673a\u6784", (String)"FinanceDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "settlecenter", ResManager.loadKDString((String)"\u7ed3\u7b97\u4e2d\u5fc3", (String)"FinanceDetailDataListPlugin_23", (String)"tmc-tda-report", (Object[])new Object[0]), "fincom", ResManager.loadKDString((String)"\u975e\u94f6\u884c\u91d1\u878d\u673a\u6784", (String)"FinanceDetailDataListPlugin_22", (String)"tmc-tda-report", (Object[])new Object[0]), "custom", ResManager.loadKDString((String)"\u5ba2\u5546", (String)"FinanceDetailDataListPlugin_24", (String)"tmc-tda-report", (Object[])new Object[0]), "other", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceDetailDataListPlugin_25", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"bankcatename", ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u522b", (String)"FinanceDetailDataListPlugin_26", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"textcreditor", ResManager.loadKDString((String)"\u503a\u6743\u4eba", (String)"FinanceDetailDataListPlugin_27", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"realregion", ResManager.loadKDString((String)"\u5730\u57df\u8303\u56f4", (String)"FinanceDetailDataListPlugin_28", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("R1", ResManager.loadKDString((String)"\u4e2d\u56fd\u5927\u9646", (String)"FinanceDetailDataListPlugin_29", (String)"tmc-tda-report", (Object[])new Object[0]), "R2", ResManager.loadKDString((String)"\u6e2f\u6fb3\u53f0", (String)"FinanceDetailDataListPlugin_30", (String)"tmc-tda-report", (Object[])new Object[0]), "R3", ResManager.loadKDString((String)"\u5883\u5916", (String)"FinanceDetailDataListPlugin_31", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"isoutgroup1", ResManager.loadKDString((String)"\u8d37\u6b3e\u6027\u8d28", (String)"FinanceDetailDataListPlugin_32", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("in", ResManager.loadKDString((String)"\u96c6\u56e2\u5185", (String)"FinanceDetailDataListPlugin_33", (String)"tmc-tda-report", (Object[])new Object[0]), "out", ResManager.loadKDString((String)"\u96c6\u56e2\u5916", (String)"FinanceDetailDataListPlugin_34", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"currencyname", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FinanceDetailDataListPlugin_35", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"FinanceDetailDataListPlugin_36", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"srcdrawamount", ResManager.loadKDString((String)"\u501f\u6b3e/\u53d1\u884c\u91d1\u989d", (String)"FinanceDetailDataListPlugin_37", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"drawamount", ResManager.loadKDString((String)"\u501f\u6b3e/\u53d1\u884c\u91d1\u989d\u6298\u672c\u4f4d\u5e01", (String)"FinanceDetailDataListPlugin_38", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"srcrepayamount", ResManager.loadKDString((String)"\u501f\u6b3e\u4f59\u989d", (String)"FinanceDetailDataListPlugin_39", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"repayamount", ResManager.loadKDString((String)"\u501f\u6b3e\u4f59\u989d\u6298\u672c\u4f4d\u5e01", (String)"FinanceDetailDataListPlugin_40", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"bizdate", ResManager.loadKDString((String)"\u653e\u6b3e\u65e5\u671f/\u53d1\u884c\u65e5\u671f", (String)"FinanceDetailDataListPlugin_41", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"startintdate", ResManager.loadKDString((String)"\u8d77\u606f\u65e5", (String)"FinanceDetailDataListPlugin_42", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"expiredate", ResManager.loadKDString((String)"\u5230\u671f\u65e5", (String)"FinanceDetailDataListPlugin_43", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"cleardate", ResManager.loadKDString((String)"\u8fd8\u6e05\u65e5\u671f", (String)"FinanceDetailDataListPlugin_44", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"term", ResManager.loadKDString((String)"\u539f\u59cb\u671f\u9650", (String)"FinanceDetailDataListPlugin_45", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"termyeartext", ResManager.loadKDString((String)"\u957f\u77ed\u671f\u7c7b\u578b", (String)"FinanceDetailDataListPlugin_88", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"interesttype", ResManager.loadKDString((String)"\u5229\u7387\u7c7b\u578b", (String)"FinanceDetailDataListPlugin_46", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("fixed", ResManager.loadKDString((String)"\u56fa\u5b9a\u5229\u7387", (String)"FinanceDetailDataListPlugin_47", (String)"tmc-tda-report", (Object[])new Object[0]), "float", ResManager.loadKDString((String)"\u6d6e\u52a8\u5229\u7387", (String)"FinanceDetailDataListPlugin_48", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"referenceratevalue", ResManager.loadKDString((String)"\u53c2\u8003\u5229\u7387", (String)"FinanceDetailDataListPlugin_49", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"ratefloatpoint", ResManager.loadKDString((String)"\u6d6e\u52a8\u70b9\u6570", (String)"FinanceDetailDataListPlugin_50", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"rateadjustdate", ResManager.loadKDString((String)"\u9996\u6b21\u5229\u7387\u91cd\u7f6e\u65e5", (String)"FinanceDetailDataListPlugin_51", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"rateadjustcycletype", ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u5468\u671f\u7b26\u53f7", (String)"FinanceDetailDataListPlugin_52", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("D", ResManager.loadKDString((String)"\u6309\u5929", (String)"FinanceDetailDataListPlugin_53", (String)"tmc-tda-report", (Object[])new Object[0]), "W", ResManager.loadKDString((String)"\u6309\u5468", (String)"FinanceDetailDataListPlugin_54", (String)"tmc-tda-report", (Object[])new Object[0]), "M", ResManager.loadKDString((String)"\u6309\u6708", (String)"FinanceDetailDataListPlugin_55", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"rateadjustcycle", ResManager.loadKDString((String)"\u5229\u7387\u91cd\u7f6e\u5468\u671f", (String)"FinanceDetailDataListPlugin_56", (String)"tmc-tda-report", (Object[])new Object[0]), "integer", false});
        field.add(new Object[]{"startloanrate", ResManager.loadKDString((String)"\u8d77\u606f\u65e5\u5229\u7387", (String)"FinanceDetailDataListPlugin_57", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"loanrate", ResManager.loadKDString((String)"\u6700\u65b0\u5229\u7387", (String)"FinanceDetailDataListPlugin_58", (String)"tmc-tda-report", (Object[])new Object[0]), "decimal", false});
        field.add(new Object[]{"basis", ResManager.loadKDString((String)"\u8ba1\u606f\u57fa\u51c6", (String)"FinanceDetailDataListPlugin_59", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("Actual_360", "Actual/360", "Actual_365", "Actual/365", "Actual_actual", "Actual/actual", "SIA_30_360", "30/360(SIA)", "BMA_30_360", "30/360(BMA)", "ISDA_30_360", "30/360(ISDA)", "European_30_360", "30/360(European)", "Japanese_Actual_365", "Actual/365(Japanese)", "ICMA_Actual_actual", "Actual/actual(ICMA)", "ICMA_Actual_360", "Actual/360(ICMA)", "ICMA_Actual_365", "Actual/365(ICMA)", "ICMA_30_360", "30/360E(ICMA)", "ISDA_Actual_365", "Actual/365(ISDA)", "BUS_252", "BUS/252")});
        field.add(new Object[]{"repaymentway", ResManager.loadKDString((String)"\u8fd8\u6b3e\u65b9\u5f0f", (String)"FinanceDetailDataListPlugin_60", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("bqhblsbq", ResManager.loadKDString((String)"\u5230\u671f\u8fd8\u672c\uff0c\u5229\u968f\u672c\u6e05", (String)"FinanceDetailDataListPlugin_61", (String)"tmc-tda-report", (Object[])new Object[0]), "dqhblsbq", ResManager.loadKDString((String)"\u5b9a\u671f\u8fd8\u672c\uff0c\u5229\u968f\u672c\u6e05", (String)"FinanceDetailDataListPlugin_62", (String)"tmc-tda-report", (Object[])new Object[0]), "bqhbdqhx", ResManager.loadKDString((String)"\u5230\u671f\u8fd8\u672c\uff0c\u5b9a\u671f\u8fd8\u606f", (String)"FinanceDetailDataListPlugin_63", (String)"tmc-tda-report", (Object[])new Object[0]), "dqhbdqhx", ResManager.loadKDString((String)"\u5b9a\u671f\u8fd8\u672c\uff0c\u5b9a\u671f\u8fd8\u606f", (String)"FinanceDetailDataListPlugin_64", (String)"tmc-tda-report", (Object[])new Object[0]), "debx", ResManager.loadKDString((String)"\u7b49\u989d\u672c\u606f", (String)"FinanceDetailDataListPlugin_65", (String)"tmc-tda-report", (Object[])new Object[0]), "debj", ResManager.loadKDString((String)"\u7b49\u989d\u672c\u91d1", (String)"FinanceDetailDataListPlugin_66", (String)"tmc-tda-report", (Object[])new Object[0]), "dbdx", ResManager.loadKDString((String)"\u7b49\u672c\u7b49\u606f", (String)"FinanceDetailDataListPlugin_67", (String)"tmc-tda-report", (Object[])new Object[0]), "zdyhk", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u8fd8\u6b3e", (String)"FinanceDetailDataListPlugin_68", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"settleintmode", ResManager.loadKDString((String)"\u7ed3\u606f\u65b9\u5f0f", (String)"FinanceDetailDataListPlugin_69", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("ykx", ResManager.loadKDString((String)"\u9884\u6263\u606f", (String)"FinanceDetailDataListPlugin_70", (String)"tmc-tda-report", (Object[])new Object[0]), "lsbq", ResManager.loadKDString((String)"\u5229\u968f\u672c\u6e05", (String)"FinanceDetailDataListPlugin_71", (String)"tmc-tda-report", (Object[])new Object[0]), "gdpljx", ResManager.loadKDString((String)"\u56fa\u5b9a\u9891\u7387\u7ed3\u606f", (String)"FinanceDetailDataListPlugin_72", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"guarantee", ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f", (String)"FinanceDetailDataListPlugin_73", (String)"tmc-tda-report", (Object[])new Object[0]), "text", false});
        field.add(new Object[]{"drawway", ResManager.loadKDString((String)"\u63d0\u6b3e\u548c\u53d1\u884c\u65b9\u5f0f", (String)"FinanceDetailDataListPlugin_74", (String)"tmc-tda-report", (Object[])new Object[0]), "combofield", false, this.getValueMapItemList("once", ResManager.loadKDString((String)"\u4e00\u6b21\u6027", (String)"FinanceDetailDataListPlugin_75", (String)"tmc-tda-report", (Object[])new Object[0]), "stage", ResManager.loadKDString((String)"\u5206\u671f", (String)"FinanceDetailDataListPlugin_76", (String)"tmc-tda-report", (Object[])new Object[0]))});
        field.add(new Object[]{"isrenewal", ResManager.loadKDString((String)"\u662f\u5426\u5c55\u671f", (String)"FinanceDetailDataListPlugin_77", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        field.add(new Object[]{"renewalexpiredate", ResManager.loadKDString((String)"\u5c55\u671f\u5230\u671f\u65e5\u671f", (String)"FinanceDetailDataListPlugin_78", (String)"tmc-tda-report", (Object[])new Object[0]), "date", false});
        field.add(new Object[]{"isoffset", ResManager.loadKDString((String)"\u662f\u5426\u62b5\u6d88", (String)"FinanceDetailDataListPlugin_79", (String)"tmc-tda-report", (Object[])new Object[0]), "checkbox", false});
        return field;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        String financeMode;
        String quantityRegionType;
        boolean splitBankCate;
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId).filter("isequity=false").select("id,company,billno,contractno,contractname,financemode,financetype,loantype,finproductname,creditortype,bankcatename,textcreditor,realregion,isoutgroup,currencyname,rate,srcdrawamount,drawamount,srcrepayamount,repayamount,bizdate,startintdate,expiredate,term,0 termyearnumber,cleardate,interesttype,ratefloatpoint,rateadjustcycletype,rateadjustcycle,startloanrate,loanrate,basis,repaymentway,settleintmode,guarantee,drawway,isrenewal,renewalexpiredate,rowoffset,coloffset,rateadjustdate,referencerate,referenceratevalue,bankcate,region");
        boolean bl = splitBankCate = paramMap.get("splitBankCate") != null && (Boolean)paramMap.get("splitBankCate") != false;
        if (splitBankCate) {
            ds = ds.filter("bankcate > 0");
        }
        if (EmptyUtil.isNoEmpty((String)(quantityRegionType = this.getRegionType(paramMap)))) {
            ds = AcctDisplayByBankTypeEnum.DOMESTIC.getValue().equals(quantityRegionType) ? ds.filter("creditortype='bank' and bankcate>0 and region=1") : (AcctDisplayByBankTypeEnum.OVERSEAS.getValue().equals(quantityRegionType) ? ds.filter("creditortype='bank' and bankcate>0 and region=0") : ds.filter("creditortype='bank' and bankcate>0"));
        }
        if (EmptyUtil.isNoEmpty((String)(financeMode = (String)paramMap.get("financemode")))) {
            ds = ds.filter("financemode=" + financeMode);
        }
        ds = ds.addFields(new String[]{"case when financemode = 0 then 'a' else 'b' end", "case when isoutgroup = 0 then 'in' else 'out' end", "case when rowoffset = 0.0 and coloffset = 0.0 then 0 else 1 end", "case when financetype = 0 then 'bank' else case when financetype = 1 then 'bond' else case when financetype = 2 then 'company' else 'other' end end end"}, new String[]{"financemode1", "isoutgroup1", "isoffset", "financetype1"});
        ds = ds.updateFields(new String[]{"drawamount", "repayamount"}, new String[]{"case when isoffset = 1 then 0.0 else drawamount end", "case when isoffset = 1 then 0.0 else repayamount end"});
        QFilter mdRateFilter = new QFilter("enable", "=", (Object)"1");
        mdRateFilter.and("bizdate", "<=", (Object)queryDate);
        DataSet mdRateDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"md_datarate", (String)"referrate,bizdate,endprice", (QFilter[])mdRateFilter.toArray(), (String)"referrate asc,bizdate asc");
        ArrayList mdRateList = new ArrayList(10);
        for (Row row : mdRateDataSet) {
            HashMap<String, Object> tempMap = new HashMap<String, Object>(4);
            tempMap.put("referrate", row.get("referrate"));
            tempMap.put("bizdate", row.get("bizdate"));
            tempMap.put("endprice", row.get("endprice"));
            mdRateList.add(tempMap);
        }
        final Map<Long, List<Map>> mdRateMap = mdRateList.stream().collect(Collectors.groupingBy(o -> (Long)o.get("referrate")));
        final RowMeta rowMeta = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                int guaranteeIndex = rowMeta.getFieldIndex("guarantee");
                if (StringUtils.isNotEmpty((String)row.getString("guarantee"))) {
                    data[guaranteeIndex] = Arrays.stream(row.getString("guarantee").replace("1", ResManager.loadKDString((String)"\u4fe1\u7528", (String)"FinanceDetailDataListPlugin_80", (String)"tmc-tda-report", (Object[])new Object[0])).replace("7", ResManager.loadKDString((String)"\u4fe1\u7528/\u65e0\u62c5\u4fdd", (String)"FinanceDetailDataListPlugin_81", (String)"tmc-tda-report", (Object[])new Object[0])).replace("6", ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceDetailDataListPlugin_82", (String)"tmc-tda-report", (Object[])new Object[0])).replace("5", ResManager.loadKDString((String)"\u8d28\u62bc", (String)"FinanceDetailDataListPlugin_83", (String)"tmc-tda-report", (Object[])new Object[0])).replace("4", ResManager.loadKDString((String)"\u62b5\u62bc", (String)"FinanceDetailDataListPlugin_84", (String)"tmc-tda-report", (Object[])new Object[0])).replace("3", ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1", (String)"FinanceDetailDataListPlugin_85", (String)"tmc-tda-report", (Object[])new Object[0])).replace("2", ResManager.loadKDString((String)"\u4fdd\u8bc1", (String)"FinanceDetailDataListPlugin_86", (String)"tmc-tda-report", (Object[])new Object[0])).split(",")).filter(s -> !StringUtils.isBlank((String)s)).collect(Collectors.joining(","));
                }
                int index = rowMeta.getFieldIndex("referenceratevalue");
                Long referencerate = row.getLong("referencerate");
                if (referencerate == null) {
                    return data;
                }
                List mdRateTempMap = (List)mdRateMap.get(referencerate);
                if (!EmptyUtil.isEmpty((Collection)mdRateTempMap)) {
                    Map rateRow = (Map)mdRateTempMap.get(mdRateTempMap.size() - 1);
                    data[index] = rateRow.get("endprice");
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
        ds = ds.addField("isoffset", "isoffsetNum");
        ds = FinanceTermDateHelper.parseTerm(ds);
        String termYearText = String.format("case when termyearnumber=1 or termyearnumber=2 then '%1$s' else '%2$s' end", ResManager.loadKDString((String)"\u77ed\u671f", (String)"FinanceDetailDataListPlugin_89", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u957f\u671f", (String)"FinanceDetailDataListPlugin_90", (String)"tmc-tda-report", (Object[])new Object[0]));
        return ds.addField(termYearText, "termyeartext");
    }

    @Override
    protected List<String> getSumLists() {
        return Arrays.asList("repayamount", "drawamount");
    }

    @Override
    protected List<String> getOrderByList() {
        return Arrays.asList("financetype1", "loantype", "finproductname", "creditortype", "bankcatename", "textcreditor");
    }

    @Override
    public Map<String, String> getHyperlinkMap() {
        return Collections.singletonMap("billno", "id");
    }

    @Override
    protected String getCountField() {
        return "isoffsetNum";
    }

    @Override
    public Function<HyperLinkClickEvent, String> getHyperlinkEntity() {
        Function<HyperLinkClickEvent, String> hyperLinkFunction = hyperLinkClickEvent -> {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(rowIndex);
            String loantype = rowData.getString("loantype");
            String linkEntity = "cfm_loanbill";
            if ("loan".equals(loantype) || "sl".equals(loantype)) {
                linkEntity = "cfm_loanbill_b_l";
            } else if ("ec".equals(loantype) || "entrust".equals(loantype)) {
                linkEntity = "cfm_loanbill_e_l";
            } else if ("bond".equals(loantype)) {
                linkEntity = "cfm_loanbill_bond";
            } else if ("lease".equals(loantype)) {
                linkEntity = "fl_leasecontractbill";
            }
            return linkEntity;
        };
        return hyperLinkFunction;
    }

    @Override
    protected Boolean getIsRemoveNoDataFlag() {
        return Boolean.FALSE;
    }

    @Override
    protected String getNotNullFilterStr() {
        String filterStr = this.getFilterStr(this.getSumLists());
        return filterStr + " or (isoffsetNum != 0)";
    }

    private String getRegionType(Map<String, Object> paramMap) {
        JSONArray type = (JSONArray)paramMap.get(DEBT_QUANTITY_REGION_TYPE);
        if (type == null) {
            return "";
        }
        return type.get(0).toString();
    }
}

