/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.FinanceNatureTypeEnum;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.common.helper.FinanceInterestBearLiaDisDatahelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceInterestBearLiaDisHelper;
import kd.tmc.tda.report.finance.helper.FinanceTermDateHelper;
import org.apache.commons.lang.StringUtils;

public class FinanceTermDateDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String ISOFFSET = "isoffset";
    private static final String STATISTICS_TYPE = "statisticsType";
    private List<String> orderFields = new ArrayList<String>(32);
    private List<String> dataRangeValues = new ArrayList<String>(32);

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet ds = FinanceInterestBearLiaDisDatahelper.getInterstBearLiaDisDataSet((String)((Object)((Object)this)).getClass().getName(), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)orgDs);
        ds = this.filterByType(ds, paramMap);
        ds = ds.select("org,org orgid,residueterm,exrepaymentdate,repayamount,rowoffset,coloffset,'' as datarange,0 as order,perpetualbond,'0' isoffset");
        DataSet[] avgTermDs = FinanceInterestBearLiaDisHelper.dealDayNum(ds.copy(), queryDate, orgDs.copy());
        ds = ds.updateField("repayamount", "repayamount + rowoffset");
        ds = FinanceTermDateHelper.groupByExpireDate(ds, paramMap);
        DataSet allDs = this.groupby(ds.copy(), paramMap);
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet colOffsetDs = ds.copy().filter("coloffset < 0").updateFields(new String[]{"repayamount", "orgid", ISOFFSET}, new String[]{"coloffset", ((DynamicObject)parentOrgs.get(0)).getString("id"), "'1'"});
        colOffsetDs = this.groupby(colOffsetDs, paramMap);
        List<String> sumFields = this.getSumField(paramMap);
        allDs = this.unionOrgInfo(allDs, orgDs, sumFields, JoinType.RIGHT);
        colOffsetDs = this.unionOrgInfo(colOffsetDs, orgDs, sumFields, JoinType.LEFT).updateFields(new String[]{"sumlevel", "isgroupnode", "mixorgname"}, new String[]{"-1", "'0'", ResManager.loadKDString((String)"'\u5408\u5e76\u62b5\u6d88'", (String)"FinanceTermDateDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0])});
        colOffsetDs = colOffsetDs.addField("0", "avgterm");
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, sumFields, "mixorgname,orgid,sortcode").filter("stat > 0").updateField("orgid", "rowid");
        String[] sumDataSetFields = sumDataSet.getRowMeta().getFieldNames();
        sumDataSet = sumDataSet.leftJoin(avgTermDs[0]).on("rowid", "rowid").select(sumDataSetFields, new String[]{"avgterm"}).finish();
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("orgid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("stat > 0") : sumDataSet.filter("orgid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("stat > 0");
        sumDataSet = sumDataSet.orderBy(new String[]{"sortcode"}).union(colOffsetDs.select(sumDataSet.getRowMeta().getFieldNames())).addField("'groupcol'", "groupcol");
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        BigDecimal totalAvgTerm = BigDecimal.ZERO;
        DataSet otalAvgDs = avgTermDs[2];
        while (otalAvgDs.hasNext()) {
            totalAvgTerm = otalAvgDs.next().getBigDecimal("avgterm");
        }
        totalSet = totalSet.updateField("avgterm", totalAvgTerm.toPlainString());
        return sumDataSet.union(totalSet);
    }

    private DataSet groupby(DataSet ds, Map<String, Object> paramMap) {
        int[] orders = (int[])paramMap.get("orderArray");
        StringBuilder sb = new StringBuilder("orgid,order,isoffset,repayamount as stat");
        for (int order : orders) {
            sb.append(",case when order=").append(order).append(" then repayamount else 0.0 end as order_").append(order);
        }
        ds = ds.select(sb.toString());
        GroupbyDataSet groupbyDataSet = ds.groupBy(new String[]{"orgid"});
        List<String> sumFields = this.getSumField(paramMap);
        for (String sumField : sumFields) {
            groupbyDataSet = groupbyDataSet.sum(sumField);
        }
        return groupbyDataSet.finish();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.orderFields, this.dataRangeValues})) {
            return columns;
        }
        int count = 0;
        for (String dataRange : this.orderFields) {
            ReportColumn newReportColumn = new ReportColumn();
            newReportColumn.setFieldKey(dataRange);
            newReportColumn.setFieldType("decimal");
            newReportColumn.setZeroShow(true);
            newReportColumn.setScale(2);
            newReportColumn.setCaption(new LocaleString(this.dataRangeValues.get(count)));
            columns.add((AbstractReportColumn)newReportColumn);
            ++count;
        }
        ReportColumn newReportColumn = new ReportColumn();
        newReportColumn.setFieldKey("avgterm");
        newReportColumn.setFieldType("decimal");
        newReportColumn.setZeroShow(true);
        newReportColumn.setScale(2);
        newReportColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e73\u5747\u5230\u671f\u671f\u9650\uff08\u5e74\uff09", (String)"FinanceInterestBearLiaDisDataListPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0])));
        columns.add((AbstractReportColumn)newReportColumn);
        return columns;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(this.orderFields);
        return fields;
    }

    private DataSet filterByType(DataSet ds, Map<String, Object> paramMap) {
        String financingnature;
        String statType;
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String displayType = (String)paramMap.get(STATISTICS_TYPE);
        if (StringUtils.isEmpty((String)displayType)) {
            statType = FinanceStatisticTypeEnum.ALL.getValue();
            financingnature = FinanceNatureTypeEnum.ALL.getValue();
        } else {
            String[] displayStrs = displayType.split(",");
            statType = displayStrs[0];
            financingnature = displayStrs[1];
        }
        if (StringUtils.isEmpty((String)statType)) {
            statType = FinanceStatisticTypeEnum.ALL.getValue();
        }
        if (StringUtils.isEmpty((String)financingnature)) {
            financingnature = FinanceNatureTypeEnum.ALL.getValue();
        }
        DataSet afterChooseTypeSet = FinanceTermDateHelper.filterCurrentMonthOrYear(ds.filter("isequity = false"), queryDate, statType);
        if (FinanceNatureTypeEnum.IN.getValue().equals(financingnature)) {
            afterChooseTypeSet = afterChooseTypeSet.filter("isoutgroup = 0");
        }
        if (FinanceNatureTypeEnum.OUT.getValue().equals(financingnature)) {
            afterChooseTypeSet = afterChooseTypeSet.filter("isoutgroup = 1");
        }
        return afterChooseTypeSet;
    }

    private List<String> getSumField(Map<String, Object> paramMap) {
        if (EmptyUtil.isNoEmpty(this.orderFields)) {
            return this.orderFields;
        }
        int[] orders = (int[])paramMap.get("orderArray");
        String[] dataRanges = (String[])paramMap.get("dataRangeArray");
        for (int order : orders) {
            this.orderFields.add("order_" + order);
            this.dataRangeValues.add(dataRanges[order]);
        }
        this.orderFields.add("stat");
        this.dataRangeValues.add(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FinanceTermDateDataListPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
        return this.orderFields;
    }

    private DataSet unionOrgInfo(DataSet ds, DataSet orgDs, List<String> sumFields, JoinType joinType) {
        return ds.join(orgDs, joinType).on("orgid", "orgid").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
    }
}

