/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceingCostAnalsDataHelper;

public class FinanceingCostByBankDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final Log logger = LogFactory.getLog(FinanceingCostByBankDataListPlugin.class);
    private static final String AVGBALANCE_SUFFIX = "_avg";
    private static final String INTEREST_SUFFIX = "_int";
    private static final String CHANGE_FIELD = "changeField";
    private static final String ORGID = "org";
    private static final String BANK = "bank";
    private static final String BANK_PREFIX = "bank_";
    private static final String AVGBALANCE = "repayamount";
    private static final String INTEREST = "repayrateamount";
    private static final String BANK_CATE = "bankcate";
    private static final String BANK_CATENAME = "bankcatename";
    public static final int TOP = 6;
    public static final String ORG = "org";
    public static final String LOANRATE = "loanrate";
    private static final String REPAYAMOUNT = "repayamount";
    private static final String TERM = "term";
    private static final String START_INT_DATE = "startintdate";
    public static final String MONTHSTR = "month";
    public static final String DATE_STR = "dateStr";
    public static final String SEARCH_PARAM_ALL = "ALL";
    public static final String BIZDATE = "bizdate";
    public static final String SEARCH_PARAM = "param";
    private static final String PARAMNAME = "paramname";
    private static final String REPAYRATEAMOUNT = "repayrateamount";
    private static final Long AVG_BANK = 99999999999999999L;
    private static final Long OTHER_BANK = 0L;
    private Map<Long, String> ORDER_MAP = new LinkedHashMap<Long, String>(16);

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        String searchParam = (String)reportQueryParam.getCustomParam().get(SEARCH_PARAM);
        DataSet dateDateSet = FinanceingCostAnalsDataHelper.getDateDateSet(queryDate);
        DataSet financeDataSet = null;
        while (dateDateSet.hasNext()) {
            CharSequence[] charSequenceArray;
            Row row = dateDateSet.next();
            Date date = row.getDate("dateTime");
            if (StringUtils.isNotEmpty((String)searchParam)) {
                CharSequence[] charSequenceArray2 = new String[2];
                charSequenceArray2[0] = "repayamount";
                charSequenceArray = charSequenceArray2;
                charSequenceArray2[1] = MergeOffsetHandler.ROW_OFFSETFILENAME;
            } else {
                String[] stringArray = new String[3];
                stringArray[0] = "repayamount";
                stringArray[1] = MergeOffsetHandler.ROW_OFFSETFILENAME;
                charSequenceArray = stringArray;
                stringArray[2] = MergeOffsetHandler.COL_OFFSETFILENAME;
            }
            CharSequence[] amountCol = charSequenceArray;
            DataSet monthFinanceDataSet = FinanceDataHelper.getFinanceDataSet((String)FinanceingCostAnalsDataHelper.class.getName(), (List)orgIds, (Date)date, (Long)baseCurrency, (Long)orgviewId, (Long)orgId).filter("isequity = false").select(new String[]{"org", "repayamount", MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME, LOANRATE, START_INT_DATE, TERM, BANK_CATE, BANK_CATENAME}).updateField("repayamount", String.join((CharSequence)"+", amountCol)).addFields(new String[]{"'" + row.getString(DATE_STR) + "'", row.getString(MONTHSTR), "to_date('" + DateUtils.formatString((Date)date, (String)"yyyy-MM-dd") + "', 'yy-MM-dd')", "'ALL'", ResManager.loadKDString((String)"'\u5b58\u91cf\u6570\u636e'", (String)"FinanceingCostAnalsDataHelper_21", (String)"tmc-tda-report", (Object[])new Object[0]), "repayamount * loanrate"}, new String[]{DATE_STR, MONTHSTR, BIZDATE, SEARCH_PARAM, PARAMNAME, "repayrateamount"});
            monthFinanceDataSet = FinanceingCostAnalsDataHelper.unionFilterData(searchParam, date, monthFinanceDataSet);
            if (financeDataSet != null) {
                financeDataSet = financeDataSet.union(monthFinanceDataSet);
                continue;
            }
            financeDataSet = monthFinanceDataSet;
        }
        financeDataSet = financeDataSet.select(new String[]{"org", BANK_CATE, BANK_CATENAME, DATE_STR, "repayrateamount", "repayamount"}).filter("bankcate> 0");
        DataSet bankDataSet = financeDataSet.copy().groupBy(new String[]{"org", DATE_STR, BANK_CATE, BANK_CATENAME}).sum("repayamount").sum("repayrateamount").finish();
        String avgCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceCostByBankDataLPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
        DataSet weightedAverageSet = financeDataSet.groupBy(new String[]{"org", DATE_STR}).sum("repayamount").sum("repayrateamount").finish().select(new String[]{"org", DATE_STR, AVG_BANK + "L as " + BANK_CATE, "'" + avgCaption + "' as " + BANK_CATENAME, "repayamount", "repayrateamount"});
        DataSet resultSet = bankDataSet.union(weightedAverageSet);
        return resultSet;
    }

    private DataSet processDataSet(DataSet orgDateSet, DataSet financeCostDataSet) {
        DataSet tempDataSet = this.topIdsByRange(financeCostDataSet, this.ORDER_MAP);
        tempDataSet = tempDataSet.addField("concat(dateStr, concat('_', bankcate))", CHANGE_FIELD);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("repayamount", "avg");
        map.put("repayrateamount", "int");
        tempDataSet = DecisionAnlsHelper.ChangeRowToMultiColDataSet(tempDataSet, CHANGE_FIELD, "org", BANK_PREFIX, map);
        List<String> countFields = this.genFieldNames("change");
        tempDataSet = DecisionAnlsHelper.addAbsentFields(tempDataSet, countFields);
        DataSet leftJoinDs = orgDateSet.leftJoin(tempDataSet).on("rowid", "org").select(new String[]{"org", "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, countFields.toArray(new String[0])).finish().addField("0", "sumlevel");
        DataSet sumDataSet = DecisionAnlsHelper.getSumDataSetByLevel(leftJoinDs, countFields, "org,mixorgname,sortcode");
        sumDataSet = this.removeAllZeroRow(sumDataSet, new HashSet<String>(countFields));
        return sumDataSet;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam queryParam) {
        long start = System.currentTimeMillis();
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        if (ds.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        DataSet processDataSet = this.processDataSet(orgDateSet, ds);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        DataSet filterDataSet = processDataSet;
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            filterDataSet = filterDataSet.where("org in ids", Collections.singletonMap("ids", subOrgIds));
        }
        filterDataSet = filterDataSet.orderBy(new String[]{"sortcode"});
        List<String> countFields = this.genFieldNames("change");
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(filterDataSet, countFields, "mixorgname");
        filterDataSet = filterDataSet.union(totalDataSet);
        List<String> calcFieldNames = this.genFieldNames("calc");
        calcFieldNames.addAll(Arrays.asList("org", "rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode", "sumlevel"));
        DataSet resultDataSet = filterDataSet.select(calcFieldNames.toArray(new String[0]));
        logger.info("\u878d\u8d44\u6210\u672c\u5206\u6790-\u6309\u94f6\u884c" + orgViewId + " \u5904\u7406\u6570\u636e\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return resultDataSet.addField("org", "orgid");
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        ReportQueryParam queryParam = this.getQueryParam();
        Map queryParamMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(queryParamMap);
        String dateRange = (String)queryParam.getCustomParam().get("dateRange");
        if (EmptyUtil.isEmpty((String)dateRange)) {
            dateRange = DateRangeEnum.MONTH.getValue();
        }
        List<String> fieldNames = this.genFieldNames("target");
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
        int diff = dateRangeEnum.getEnd() - dateRangeEnum.getStart();
        LinkedHashMap<String, ReportColumnGroup> groupMap = new LinkedHashMap<String, ReportColumnGroup>();
        for (String fieldName : fieldNames) {
            String[] fieldNameSplit = fieldName.split("_");
            String dateIndex = fieldNameSplit[1];
            ReportColumnGroup reportColumnGroup = (ReportColumnGroup)groupMap.get(BANK_PREFIX + dateIndex);
            if (reportColumnGroup == null) {
                reportColumnGroup = new ReportColumnGroup();
                reportColumnGroup.setFieldKey(BANK_PREFIX + dateIndex);
                String caption = FinanceCostDateHelper.getDateCaption((Date)FinanceCostDateHelper.getNewDate((Date)queryDate), (String)dateRange, (String)dateRangeEnum.getShortName(), (int)diff--);
                reportColumnGroup.setCaption(new LocaleString(caption));
                groupMap.put(BANK_PREFIX + dateIndex, reportColumnGroup);
            }
            Long bankId = Long.parseLong(fieldNameSplit[2]);
            String columnCaption = this.ORDER_MAP.get(bankId);
            if (AVG_BANK.equals(bankId)) {
                columnCaption = ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceCostByBankDataLPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
            }
            ReportColumn column = this.createColumn(fieldName, columnCaption);
            reportColumnGroup.getChildren().add(column);
        }
        groupMap.forEach((k, v) -> columns.add((AbstractReportColumn)v));
        return columns;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("text");
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        ColumnStyle columnStyle = new ColumnStyle();
        columnStyle.setTextAlign("right");
        reportColumn.setStyle(columnStyle);
        return reportColumn;
    }

    private List<String> genFieldNames(String fieldType) {
        ReportQueryParam queryParam = this.getQueryParam();
        Map paramMap = this.transQueryParam(queryParam);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet dateDateSet = FinanceingCostAnalsDataHelper.getDateDateSet(queryDate).orderBy(new String[]{"dateStr asc"});
        ArrayList<String> fieldNames = new ArrayList<String>(16);
        for (Row date : dateDateSet) {
            this.ORDER_MAP.forEach((bankCate, bankName) -> this.getFields((List<String>)fieldNames, date.getString(DATE_STR), (Long)bankCate, fieldType));
        }
        return fieldNames;
    }

    private void getFields(List<String> fieldNames, String dateStr, Long bankCate, String fieldType) {
        switch (fieldType) {
            case "target": {
                fieldNames.add(BANK_PREFIX + dateStr + "_" + bankCate);
                break;
            }
            case "change": {
                fieldNames.add(BANK_PREFIX + dateStr + "_" + bankCate + AVGBALANCE_SUFFIX);
                fieldNames.add(BANK_PREFIX + dateStr + "_" + bankCate + INTEREST_SUFFIX);
                break;
            }
            case "calc": {
                String temp = BANK_PREFIX + dateStr + "_" + bankCate;
                String _int = temp + INTEREST_SUFFIX;
                String _avg = temp + AVGBALANCE_SUFFIX;
                String calcStr = "case when " + _avg + " = 0.0  or " + _avg + " is null then 0 else " + _int + " *0.01 / " + _avg + " end as " + temp;
                fieldNames.add(calcStr);
                break;
            }
        }
    }

    private DataSet topIdsByRange(DataSet dataSet, Map<Long, String> orderMap) {
        dataSet = dataSet.orderBy(new String[]{"dateStr desc", "repayamount desc"});
        Iterator tempSetIterator = dataSet.copy().groupBy(new String[]{BANK_CATE, BANK_CATENAME}).sum("repayamount").finish().orderBy(new String[]{"repayamount desc"}).iterator();
        if (tempSetIterator.hasNext()) {
            Row next1 = (Row)tempSetIterator.next();
            String bankName = null;
            if (!AVG_BANK.equals(next1.getLong(BANK_CATE))) {
                bankName = next1.getString(BANK_CATENAME);
                orderMap.put(next1.getLong(BANK_CATE), next1.getString(BANK_CATENAME));
            }
            while (tempSetIterator.hasNext()) {
                Row next = (Row)tempSetIterator.next();
                if (orderMap.size() >= 6) break;
                if (AVG_BANK.equals(next.getLong(BANK_CATE))) {
                    bankName = next.getString(BANK_CATENAME);
                    continue;
                }
                orderMap.put(next.getLong(BANK_CATE), next.getString(BANK_CATENAME));
            }
            ArrayList<Long> bankIds = new ArrayList<Long>(orderMap.keySet());
            bankIds.add(AVG_BANK);
            DataSet[] tempSets = dataSet.splitByFilter(new String[]{"bankcate in (" + TmcBusinessBaseHelper.idListToString(bankIds) + ")"}, true);
            DataSet resultSet = tempSets[0].groupBy(new String[]{"org", DATE_STR, BANK_CATE, BANK_CATENAME}).sum("repayamount").sum("repayrateamount").finish();
            if (!tempSets[1].isEmpty()) {
                String avgCaption = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceCostByBankDataListPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]);
                DataSet otherSet = tempSets[1].groupBy(new String[]{"org", DATE_STR}).sum("repayamount").sum("repayrateamount").finish();
                otherSet = otherSet.addFields(new String[]{OTHER_BANK + "L", "'" + avgCaption + "'"}, new String[]{BANK_CATE, BANK_CATENAME});
                resultSet = resultSet.union(otherSet.select(new String[]{"org", DATE_STR, BANK_CATE, BANK_CATENAME, "repayamount", "repayrateamount"}));
                orderMap.put(OTHER_BANK, avgCaption);
            }
            orderMap.put(AVG_BANK, bankName);
            return resultSet;
        }
        return DecisionAnlsHelper.createEmptyDataSet(new String[]{"org", DATE_STR, BANK_CATE, BANK_CATENAME, "repayamount", "repayrateamount"}, new DataType[]{DataType.LongType, DataType.IntegerType, DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType});
    }
}

