/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InterestDebtByFinProductDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static String FINANCE_TYPE = "financetype";
    private String REPAY_AMOUNT = "repayamount";
    private String UN_EQUITY = "isequity = false";
    private String TOTAL = "total";
    private String TYPE_PREFIX = "type_";
    private List<String> COUNT_FIELDS = new ArrayList<String>();

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet query = FinanceDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        query = query.filter(this.UN_EQUITY);
        DataSet[] splitDataSet = query.splitByFilter(new String[]{"isoutgroup = 0 and creditortype = 'fincom'"}, true);
        DataSet finCom = splitDataSet[0].updateField(FINANCE_TYPE, "4");
        query = finCom.union(splitDataSet[1]);
        return query.select(new String[]{"org", FINANCE_TYPE, this.REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        RowMeta rowMeta = dataSet.getRowMeta();
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet financeSet = dataSets[0].groupBy(new String[]{"org", FINANCE_TYPE}).sum(this.REPAY_AMOUNT).sum(MergeOffsetHandler.ROW_OFFSETFILENAME).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish();
        financeSet = financeSet.select(new String[]{"org", FINANCE_TYPE, this.REPAY_AMOUNT + "+" + MergeOffsetHandler.ROW_OFFSETFILENAME + " as " + "count"});
        financeSet = DecisionAnlsHelper.ChangeRowToColDataSet(financeSet, FINANCE_TYPE, "org", this.TYPE_PREFIX);
        financeSet = orgDateSet.leftJoin(financeSet).on("org", "org").select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, financeSet.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel");
        financeSet = DecisionAnlsHelper.getSumDataSetByLevel(financeSet, this.getCountFields(financeSet), "mixorgname,sortcode");
        this.COUNT_FIELDS.clear();
        this.COUNT_FIELDS = this.getCountFields(financeSet);
        financeSet = financeSet.addField(String.join((CharSequence)"+", this.COUNT_FIELDS), this.TOTAL);
        this.COUNT_FIELDS.add(this.TOTAL);
        DataSet colOffsetSet = this.getOffsetRow(dataSets[1].filter("org != " + orgId), financeSet);
        DataSet result = financeSet.orderBy(new String[]{"sortcode"}).union(colOffsetSet);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            subOrgIds.add(0L);
            result = result.where("rowid in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(result, this.COUNT_FIELDS, "mixorgname");
        result = result.union(totalDataSet);
        return result.addField("mixorgname", "org_name").addField("rowid", "orgid");
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.COUNT_FIELDS);
    }

    private List<String> getCountFields(DataSet dataSet) {
        return Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(this.TYPE_PREFIX)).collect(Collectors.toList());
    }

    private DataSet getOffsetRow(DataSet dataSet, DataSet interestSet) {
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(interestSet.getRowMeta().getFieldNames(), interestSet.getRowMeta().getDataTypes());
        }
        DataSet colOffsetSet = dataSet.groupBy(new String[]{FINANCE_TYPE}).sum(MergeOffsetHandler.COL_OFFSETFILENAME, "count").finish().addField("0", "org");
        colOffsetSet = DecisionAnlsHelper.ChangeRowToColDataSet(colOffsetSet, FINANCE_TYPE, "org", this.TYPE_PREFIX);
        String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashDistributionByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
        Iterator iterator = colOffsetSet.iterator();
        Row row = (Row)iterator.next();
        LinkedHashMap<String, String> updateMap = new LinkedHashMap<String, String>(this.getCountFields(colOffsetSet).size());
        BigDecimal totalValue = BigDecimal.ZERO;
        for (String fieldName : this.getCountFields(colOffsetSet)) {
            BigDecimal value = BigDecimal.ZERO;
            if (row.getBigDecimal(fieldName) != null) {
                value = row.getBigDecimal(fieldName);
                totalValue = totalValue.add(value);
            }
            updateMap.put(fieldName, value.toPlainString());
        }
        updateMap.put("mixorgname", "'" + offsetName + "'");
        updateMap.put(this.TOTAL, totalValue.toPlainString());
        colOffsetSet = DecisionAnlsHelper.createRowByDefault(interestSet.getRowMeta().getFieldNames(), interestSet.getRowMeta().getDataTypes()).updateFields(updateMap.keySet().toArray(new String[0]), updateMap.values().toArray(new String[0]));
        return colOffsetSet;
    }
}

