/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InterestDebtByInterestTypeDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private String INTEREST_TYPE = "interesttype";
    private String REPAY_AMOUNT = "repayamount";
    private String IS_OUT_GROUP = "isoutgroup";
    private String UN_EQUITY = "isequity = false";
    private String GROUP_INTEREST = "group_interest";
    private String FIXED = "fixed";
    private String FLOAT = "float";
    private String TOTAL = "total";
    private List<String> COUNT_FIELDS = Arrays.asList("fixed_0", "float_0", "total_0", "fixed_1", "float_1", "total_1", this.FIXED, this.FLOAT, this.TOTAL);

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet query = FinanceDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        return query.filter(this.UN_EQUITY).select(new String[]{"org", this.IS_OUT_GROUP, this.INTEREST_TYPE, this.REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        RowMeta rowMeta = dataSet.getRowMeta();
        if (dataSet.isEmpty()) {
            this.COUNT_FIELDS = Collections.emptyList();
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        dataSet = dataSet.groupBy(new String[]{"org", this.IS_OUT_GROUP, this.INTEREST_TYPE}).sum(this.REPAY_AMOUNT).sum(MergeOffsetHandler.ROW_OFFSETFILENAME).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish();
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet interestSet = dataSets[0].select(new String[]{"org", this.REPAY_AMOUNT + "+" + MergeOffsetHandler.ROW_OFFSETFILENAME + " as " + "count", "concat(interesttype, concat('_',isoutgroup)) as group_interest"});
        interestSet = DecisionAnlsHelper.ChangeRowToColDataSet(interestSet, this.GROUP_INTEREST, "org", "");
        interestSet = DecisionAnlsHelper.addAbsentFields(interestSet, this.COUNT_FIELDS);
        interestSet = orgDateSet.leftJoin(interestSet).on("org", "org").select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, interestSet.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel");
        interestSet = DecisionAnlsHelper.getSumDataSetByLevel(interestSet, this.COUNT_FIELDS, "mixorgname,sortcode");
        DataSet colOffsetSet = this.getOffsetRow(dataSets[1].filter("org != " + orgId), interestSet);
        DataSet result = interestSet.orderBy(new String[]{"sortcode"}).union(colOffsetSet).updateField(this.COUNT_FIELDS.get(2), this.COUNT_FIELDS.get(0) + " + " + this.COUNT_FIELDS.get(1)).updateField(this.COUNT_FIELDS.get(5), this.COUNT_FIELDS.get(3) + " + " + this.COUNT_FIELDS.get(4)).updateField(this.FIXED, this.COUNT_FIELDS.get(0) + " + " + this.COUNT_FIELDS.get(3)).updateField(this.FLOAT, this.COUNT_FIELDS.get(1) + " + " + this.COUNT_FIELDS.get(4)).updateField(this.TOTAL, this.FIXED + " + " + this.FLOAT);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            subOrgIds.add(0L);
            result = result.where("rowid in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(result, this.COUNT_FIELDS, "mixorgname");
        result = result.union(totalDataSet);
        return result.addField("mixorgname", "org_name").addField("rowid", "orgid");
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.COUNT_FIELDS);
    }

    private DataSet getOffsetRow(DataSet dataSet, DataSet interestSet) {
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(interestSet.getRowMeta().getFieldNames(), interestSet.getRowMeta().getDataTypes());
        }
        DataSet colOffsetSet = dataSet.groupBy(new String[]{this.INTEREST_TYPE}).sum(MergeOffsetHandler.COL_OFFSETFILENAME, "count").finish().addField("0", "org");
        colOffsetSet = DecisionAnlsHelper.ChangeRowToColDataSet(colOffsetSet, this.INTEREST_TYPE, "org", "");
        colOffsetSet = DecisionAnlsHelper.addAbsentFields(colOffsetSet, Arrays.asList(this.FIXED, this.FLOAT));
        String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashDistributionByAreaDataListPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
        BigDecimal fixedValue = BigDecimal.ZERO;
        BigDecimal floatValue = BigDecimal.ZERO;
        Iterator iterator = colOffsetSet.iterator();
        if (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            if (Objects.nonNull(row.getBigDecimal(this.FIXED))) {
                fixedValue = row.getBigDecimal(this.FIXED);
            }
            if (Objects.nonNull(row.getBigDecimal(this.FLOAT))) {
                floatValue = row.getBigDecimal(this.FLOAT);
            }
        }
        colOffsetSet = DecisionAnlsHelper.createRowByDefault(interestSet.getRowMeta().getFieldNames(), interestSet.getRowMeta().getDataTypes()).updateFields(new String[]{"mixorgname", this.COUNT_FIELDS.get(0), this.COUNT_FIELDS.get(1), this.FIXED, this.FLOAT}, new String[]{"'" + offsetName + "'", fixedValue.toPlainString(), floatValue.toPlainString(), fixedValue.toPlainString(), floatValue.toPlainString()});
        return colOffsetSet;
    }
}

