/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.form;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class FinanceDebtQuantityDataPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String DEBT_QUANTITY_REGION_TYPE = "debtquantityregiontype";
    private static final String ORGID = "orgid";
    private static final String FILTER = "filter";
    private static final String PREFIX = "fbank_";
    private static final String FILTER_COMPANY = "filter_company";
    private static final String BTN_SHOWALL = "btn_showall";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        queryParam.getFilter().addFilterItem(DEBT_QUANTITY_REGION_TYPE, (Object)this.getRegionType());
        queryParam.getFilter().addFilterItem("orgViewNumber", (Object)this.getPageCache().get("orgViewNumber"));
        return super.verifyQuery(queryParam);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("btn_showdetail")) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put(DEBT_QUANTITY_REGION_TYPE, formShowParameter.getCustomParam(DEBT_QUANTITY_REGION_TYPE));
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        } else if (BTN_SHOWALL.equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", true);
            this.getView().invokeOperation("refresh");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_SHOWALL});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String key = evt.getItemKey();
        if ("refresh".equals(key)) {
            this.getQueryParam().getCustomParam().put("isShowAll", false);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_SHOWALL});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        long orgid = row.getLong(ORGID);
        String fieldName = event.getFieldName();
        if (EmptyUtil.isNoEmpty((String)fieldName) && fieldName.startsWith(PREFIX)) {
            ReportShowParameter param = new ReportShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            Map paramMap = SnapDataHelper.transQueryParam((ReportQueryParam)this.getQueryParam());
            long parentId = ((DynamicObject)((DynamicObjectCollection)paramMap.get(FILTER_COMPANY)).get(0)).getLong("id");
            param.getCustomParams().put("parent_id", Long.toString(parentId));
            if (EmptyUtil.isEmpty((Long)orgid)) {
                param.getCustomParams().put("current_org_id", Long.toString(parentId));
            } else {
                param.getCustomParams().put("current_org_id", Long.toString(orgid));
            }
            param.getCustomParams().put(DEBT_QUANTITY_REGION_TYPE, paramMap.get(DEBT_QUANTITY_REGION_TYPE));
            if (this.getView().getFormShowParameter().getCustomParams().get("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            }
            param.setFormId("tda_findebtotherbackrpt");
            this.getView().showForm((FormShowParameter)param);
            return;
        }
        if (EmptyUtil.isEmpty((Long)orgid)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put(ORGID, Long.toString(orgid));
        param.getCustomParams().put("orgViewNumber", this.getPageCache().get("orgViewNumber"));
        param.getCustomParams().put("next", true);
        param.getCustomParams().put(DEBT_QUANTITY_REGION_TYPE, this.getRegionType());
        param.setFormId(this.getView().getFormShowParameter().getFormId());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        DynamicObject rowData = evt.getRowData();
        String isGroupNode = rowData.getString("isgroupnode");
        Object formatValue = evt.getFormatValue();
        String fieldKey = ((ReportColumn)evt.getSource()).getFieldKey();
        if (fieldKey.startsWith(PREFIX)) {
            return;
        }
        if (formatValue != null && !"1".equals(isGroupNode)) {
            evt.getNoLinkKey().add(fieldKey);
        }
    }

    private JSONArray getRegionType() {
        ReportShowParameter parameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = parameter.getCustomParams();
        return (JSONArray)customParams.get(DEBT_QUANTITY_REGION_TYPE);
    }
}

