/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.constant.MetaToDetailPluginMap;
import kd.tmc.tda.common.helper.HomeOverviewHelper;

public class FinanceingCostListPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final String ORGID = "orgid";
    private static final String FILTER = "filter";
    private static final String ISGROUPNODE = "isgroupnode";
    private static final String GROUPNODEVALUE = "1";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object displayType = customParams.get("displayType");
        Object searchParam = formShowParameter.getCustomParams().get("param");
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("displayType", (Object)("financeingtype".equals(displayType) ? "financeingtype" : displayType));
        filter.addFilterItem("param", searchParam);
        return super.verifyQuery(queryParam);
    }

    public void packageData(PackageDataEvent packageDataEvent) {
        super.packageData(packageDataEvent);
        DynamicObject row = packageDataEvent.getRowData();
        String isGroupNode = row.getString(ISGROUPNODE);
        Object formatValue = packageDataEvent.getFormatValue();
        if (formatValue != null && !GROUPNODEVALUE.equals(isGroupNode)) {
            packageDataEvent.getNoLinkKey().add(((ReportColumn)packageDataEvent.getSource()).getFieldKey());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        ReportList reportlist = (ReportList)this.getView().getControl("reportlistap");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (key.equals("btn_showdetail")) {
            Map pluginInfo;
            ReportShowParameter param = new ReportShowParameter();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            if (formShowParameter.getCustomParam("next") != null) {
                ReportQueryParam queryParam = this.getQueryParam();
                FilterInfo filter = queryParam.getFilter();
                Long orgId = Long.valueOf((String)formShowParameter.getCustomParam(ORGID));
                param.getCustomParams().put(ORGID, orgId);
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
            } else if (formShowParameter.getCustomParam("home") != null) {
                param.getCustomParams().put("home", Boolean.TRUE);
            } else {
                param.getCustomParams().put("next", true);
                param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)this.getQueryParam().getFilter()));
            }
            String entity = this.getView().getEntityId();
            if (MetaToDetailPluginMap.getSamePluginMap().get(entity) != null) {
                entity = (String)MetaToDetailPluginMap.getSamePluginMap().get(entity);
            }
            if ((pluginInfo = MetaToDetailPluginMap.getPluginInfo((String)entity)).get("plugin") != null) {
                Pair pluginPair = (Pair)pluginInfo.get("plugin");
                param.setCaption((String)pluginPair.getValue1());
            }
            param.getCustomParams().put("entity", entity);
            param.setFormId("tda_treedetailcommonrpt");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        int rowIndex = event.getRowIndex();
        ReportList rptList = (ReportList)event.getSource();
        DynamicObject row = rptList.getReportModel().getRowData(rowIndex);
        String isGroupNode = row.getString(ISGROUPNODE);
        long orgid = row.getLong(ORGID);
        if (EmptyUtil.isEmpty((Long)orgid) || !GROUPNODEVALUE.equals(isGroupNode)) {
            return;
        }
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(ORGID, Long.toString(orgid));
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        param.getCustomParams().put("displayType", customParams.get("displayType"));
        param.getCustomParams().put("param", customParams.get("param"));
        param.getCustomParams().put(FILTER, SerializationUtils.serializeToBase64((Object)filter));
        param.getCustomParams().put("next", Boolean.TRUE);
        param.setFormId(this.getView().getFormShowParameter().getFormId());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(formShowParameter.getCaption());
        HomeOverviewHelper.hyperLinkClickFromHome((IReportView)this.getView(), (ReportShowParameter)param);
        this.getView().showForm((FormShowParameter)param);
    }

    public void processRowData(String gridPk, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPk, rowData, queryParam);
        Iterator iterator = rowData.iterator();
        List<String> rateColName = this.getColNameList(rowData);
        while (iterator.hasNext()) {
            DynamicObject row = (DynamicObject)iterator.next();
            for (String colName : rateColName) {
                BigDecimal showNum = StringUtils.isEmpty((String)row.getString(colName)) ? BigDecimal.ZERO : row.getBigDecimal(colName).setScale(2, RoundingMode.HALF_UP);
                row.set(colName, (Object)(showNum + "%"));
            }
        }
    }

    private List<String> getColNameList(DynamicObjectCollection rowData) {
        DataEntityPropertyCollection properties = rowData.getDynamicObjectType().getProperties();
        return properties.stream().filter(r -> StringUtils.isNotEmpty((String)r.getName()) && r.getName().endsWith("RPTCOLSTR")).map(IMetadata::getName).collect(Collectors.toList());
    }
}

