/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinDebtTrendDataHelper {
    public static final String METRIC = "metrics";
    public static final String TREND = "trend";

    public static DataSet getDateDataSet(String entityName, Date queryDate) {
        String showStr;
        int i;
        int[] dateParam = FinDebtTrendDataHelper.getPeriodDimensionConfig(TREND, entityName);
        int monthNum = dateParam[0];
        int yearNum = dateParam[1];
        Calendar cal = Calendar.getInstance();
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        cal.setTime(queryDate);
        for (i = 0; i < monthNum; ++i) {
            cal.add(2, -1);
            Date lastMonthDate = DateUtils.getMaxMonthDate((Date)cal.getTime());
            int month = DateUtils.getMonth((Date)lastMonthDate);
            showStr = DateUtils.formatString((Date)lastMonthDate, (String)"yyyyMM");
            result.add(new Object[]{month, lastMonthDate, i, showStr});
        }
        for (i = monthNum; i < monthNum + yearNum; ++i) {
            cal.add(1, -1);
            Date lastYearDate = DateUtils.getLastYearDate((Date)cal.getTime());
            int year = DateUtils.getYear((Date)lastYearDate);
            showStr = DateUtils.formatString((Date)lastYearDate, (String)"yyyy");
            result.add(new Object[]{year, lastYearDate, i, showStr});
        }
        return DecisionAnlsHelper.createRow("kd.tmc.tda.report.finance.helper.FinDebtTrendDataHelper", new String[]{"month", "dateTime", "sort", "dateStr"}, new DataType[]{DataType.IntegerType, DataType.DateType, DataType.IntegerType, DataType.StringType}, result);
    }

    public static int[] getPeriodDimensionConfig(String periodType, String entityName) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{periodType, entityName})) {
            return new int[]{4, 5};
        }
        QFilter qFilter = new QFilter("periodtype", "=", (Object)periodType);
        Object[] paramSets = BusinessDataServiceHelper.load((String)"tda_perioddimset", (String)"number, periodtype, month, year, metrics", (QFilter[])qFilter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])paramSets)) {
            for (Object paramSet : paramSets) {
                Set reportNames;
                DynamicObjectCollection metrics = paramSet.getDynamicObjectCollection(METRIC);
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)metrics) || !(reportNames = metrics.stream().map(m -> m.getDynamicObject("fbasedataid").getString("reportform.number")).collect(Collectors.toSet())).contains(entityName)) continue;
                return new int[]{paramSet.getInt("month"), paramSet.getInt("year")};
            }
        }
        return new int[]{4, 5};
    }
}

