/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceEquityAnalDataHelper {
    public static final String REPAYAMOUNT = "repayamount";
    public static final String RATEAMOUNT = "rateamount";
    public static final String PERCENT = "percent";
    public static final String DATESTRING = "datestring";
    public static final String DATESTRINGPREFIX = "datestring_";
    public static final String MIXORGNAME = "mixorgname";
    public static final String ORG = "org";

    public static DataSet dealRow(List<String> dateStringFields, Long orgViewId, DataSet uionResult) {
        uionResult = uionResult.updateField(REPAYAMOUNT, "case when repayamount is null then 0 else repayamount end");
        uionResult = uionResult.addField("repayamount * loanrate", RATEAMOUNT);
        uionResult = uionResult.select(new String[]{ORG, DATESTRING, REPAYAMOUNT, RATEAMOUNT}).groupBy(new String[]{ORG, DATESTRING}).sum(REPAYAMOUNT).sum(RATEAMOUNT).finish();
        uionResult = DecisionAnlsHelper.ChangeMultRowToColDataSet(uionResult, DATESTRING, ORG, DATESTRINGPREFIX, Arrays.asList(REPAYAMOUNT, RATEAMOUNT));
        List<String> fieldname = Arrays.asList(uionResult.getRowMeta().getFieldNames());
        ArrayList<String> sumField = new ArrayList<String>(8);
        for (String dateStringField : dateStringFields) {
            String repayChangeRowFiled = DATESTRINGPREFIX + dateStringField + REPAYAMOUNT;
            String rateChangeRowFiled = DATESTRINGPREFIX + dateStringField + RATEAMOUNT;
            sumField.add(repayChangeRowFiled);
            sumField.add(rateChangeRowFiled);
            if (!fieldname.contains(repayChangeRowFiled)) {
                uionResult = uionResult.addField("0", repayChangeRowFiled);
            }
            if (!fieldname.contains(rateChangeRowFiled)) {
                uionResult = uionResult.addField("0", rateChangeRowFiled);
            }
            uionResult = uionResult.updateField(repayChangeRowFiled, "case when " + repayChangeRowFiled + " is null then 0 else " + repayChangeRowFiled + " end").updateField(rateChangeRowFiled, "case when " + rateChangeRowFiled + " is null then 0 else " + rateChangeRowFiled + " end");
        }
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        List<String> selectField = FinanceEquityAnalDataHelper.getSelectField(sumField);
        DataSet orgJoinSet = orgDateSet.leftJoin(uionResult).on("rowid", ORG).select(selectField.toArray(new String[0])).finish();
        DataSet result = DecisionAnlsHelper.getSumDataSetByLevel(orgJoinSet, sumField, "mixorgname,orgid,sortcode");
        StringBuilder nullFilterString = new StringBuilder();
        for (String dateStringField : dateStringFields) {
            String repayChangeRowFiled = DATESTRINGPREFIX + dateStringField + REPAYAMOUNT;
            nullFilterString.append(repayChangeRowFiled).append(" is not null or ");
            String rateChangeRowFiled = DATESTRINGPREFIX + dateStringField + RATEAMOUNT;
            nullFilterString.append(rateChangeRowFiled).append(" is not null or ");
            String percentChangeRowFiled = DATESTRINGPREFIX + dateStringField + PERCENT;
            nullFilterString.append(percentChangeRowFiled).append(" is not null or ");
            result = result.addField("case when " + repayChangeRowFiled + " = 0 then 0 else " + rateChangeRowFiled + " / " + repayChangeRowFiled + " end", percentChangeRowFiled);
        }
        nullFilterString.append("false");
        return result.filter(nullFilterString.toString());
    }

    private static List<String> getSelectField(List<String> sumField) {
        ArrayList<String> selectField = new ArrayList<String>(30);
        selectField.addAll(sumField);
        selectField.add("orgname");
        selectField.add(MIXORGNAME);
        selectField.add("rowid");
        selectField.add("orgid");
        selectField.add("pid");
        selectField.add("isgroupnode");
        selectField.add("level");
        selectField.add("0 sumlevel");
        selectField.add("sortcode");
        return selectField;
    }
}

