/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.common.enums.FinanceTermYearEnum;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinDebtTrendDataHelper;

public class FinanceTermDateHelper {
    public static final String DATA_RANGE_ARRAY = "dataRangeArray";
    public static final String ORDER_ARRAY = "orderArray";
    public static final String DATA_RANGE = "datarange";
    public static final String ORDER = "order";
    public static final String TERM_YEAR_NUMBER = "termyearnumber";

    public static DataSet groupByExpireDate(DataSet ds, Map<String, Object> paramMap) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        final List<Object[]> dateList = FinanceTermDateHelper.getExpireDateList(queryDate);
        String[] dataRanges = FinanceTermDateHelper.dataRanges(dateList);
        paramMap.put(DATA_RANGE_ARRAY, dataRanges);
        paramMap.put(ORDER_ARRAY, FinanceTermDateHelper.buildOrderArray(dataRanges.length));
        final RowMeta rowMetas = ds.getRowMeta();
        return ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                int order = 0;
                String dateStr = ((Object[])dateList.get(order))[2].toString();
                String residueTerm = row.getString("residueterm");
                Boolean perpetualbond = row.getBoolean("perpetualbond");
                if (Boolean.TRUE.equals(perpetualbond)) {
                    order = dateList.size() - 1;
                    dateStr = ((Object[])dateList.get(order))[2].toString();
                } else if (EmptyUtil.isNoEmpty((String)residueTerm)) {
                    Date exrepaymentDate = row.getDate("exrepaymentdate");
                    for (int i = 0; i < dateList.size(); ++i) {
                        Object[] objects = (Object[])dateList.get(i);
                        Date startDate = (Date)objects[0];
                        Date endDate = (Date)objects[1];
                        if (endDate != null) {
                            if (exrepaymentDate.compareTo(startDate) < 0 || exrepaymentDate.compareTo(endDate) >= 0) continue;
                            order = i;
                            dateStr = (String)objects[2];
                            break;
                        }
                        if (exrepaymentDate.compareTo(startDate) < 0) continue;
                        order = i;
                        dateStr = (String)objects[2];
                        break;
                    }
                }
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (FinanceTermDateHelper.ORDER.equals(fieldName)) {
                        rowInfo.add(order);
                        continue;
                    }
                    if (FinanceTermDateHelper.DATA_RANGE.equals(fieldName)) {
                        rowInfo.add(dateStr);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
    }

    public static DataSet filterCurrentMonthOrYear(DataSet ds, Date queryDate, String type) {
        HashMap<String, Date> paramsMap = new HashMap<String, Date>(4);
        if (type.equals(FinanceStatisticTypeEnum.MONTH.getValue())) {
            Date firstDay = DateUtils.getFirstDayOfMonth((Date)queryDate);
            Date lastDay = DateUtils.getLastDayOfMonth((Date)queryDate);
            paramsMap.put("firstDay", firstDay);
            paramsMap.put("lsatDay", lastDay);
            ds = ds.filter("startintdate >= firstDay and startintdate <= lsatDay", paramsMap);
        } else if (type.equals(FinanceStatisticTypeEnum.YEAR.getValue())) {
            Date firstDay = DateUtils.getFirstYearDate((Date)queryDate);
            paramsMap.put("firstDay", firstDay);
            paramsMap.put("lsatDay", queryDate);
            ds = ds.filter("startintdate >= firstDay and startintdate <= lsatDay", paramsMap);
        }
        return ds;
    }

    private static List<Object[]> getExpireDateList(Date queryDate) {
        String showStr;
        int i;
        int[] dateParam = FinDebtTrendDataHelper.getPeriodDimensionConfig("expire", "tda_fintermdateqingrpt");
        int monthNum = dateParam[0];
        int yearNum = dateParam[1];
        ArrayList<Object[]> dateList = new ArrayList<Object[]>(monthNum + yearNum);
        Date startDate = FinanceTermDateHelper.firstDayOfCurrentMonth(queryDate);
        Date endDate = null;
        boolean isContainDecember = false;
        for (i = 0; i < monthNum; ++i) {
            if (endDate == null) {
                endDate = DateUtils.getNextMonth((Date)startDate, (int)1);
            } else {
                startDate = DateUtils.getNextMonth((Date)startDate, (int)1);
                endDate = DateUtils.getNextMonth((Date)endDate, (int)1);
            }
            showStr = DateUtils.formatString((Date)startDate, (String)"yyyyMM");
            if (i == monthNum - 1) {
                isContainDecember = "12".equals(showStr.substring(4));
            }
            dateList.add(new Object[]{startDate, endDate, showStr});
        }
        if (!isContainDecember) {
            startDate = DateUtils.getNextMonth((Date)startDate, (int)1);
            endDate = FinanceTermDateHelper.firstDayOfNextYear(startDate);
            String showStr2 = DateUtils.formatString((Date)startDate, (String)"yyyy");
            dateList.add(new Object[]{startDate, endDate, showStr2});
        }
        for (i = 0; i < yearNum; ++i) {
            startDate = endDate;
            endDate = DateUtils.getNextYear((Date)endDate, (int)1);
            showStr = DateUtils.formatString((Date)startDate, (String)"yyyy");
            if (i == yearNum - 1) {
                showStr = String.format(ResManager.loadKDString((String)"%s\u4ee5\u540e", (String)"FinanceTermDateHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]), showStr);
                dateList.add(new Object[]{startDate, null, showStr});
                continue;
            }
            dateList.add(new Object[]{startDate, endDate, showStr});
        }
        return dateList;
    }

    private static Date firstDayOfCurrentMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(cal.get(1), cal.get(2), 1, 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    private static Date firstDayOfNextYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(cal.get(1) + 1, 0, 1, 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    private static String[] dataRanges(List<Object[]> dateList) {
        String[] array = new String[dateList.size()];
        for (int i = 0; i < dateList.size(); ++i) {
            array[i] = dateList.get(i)[2].toString();
        }
        return array;
    }

    private static int[] buildOrderArray(int size) {
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = i;
        }
        return array;
    }

    public static DataSet parseTerm(DataSet ds) {
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if (FinanceTermDateHelper.TERM_YEAR_NUMBER.equals(fieldName)) {
                        String term = row.getString("term");
                        FinanceTermYearEnum termYearEnum = FinanceTermYearEnum.getTermYearNumber((String)term);
                        rowInfo.add(termYearEnum.getNumber());
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }
}

