/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.olap.util.Pair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.enums.FinanceStatisticTypeEnum;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.helper.TdaParameterHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceingCostAnalsDataHelper {
    public static final String RPTCOLSTR = "RPTCOLSTR";
    public static final String DATE_STR = "dateStr";
    public static final String BIZDATE = "bizdate";
    public static final String TMC_TDA_REPORT = "tmc-tda-report";
    public static final String DISPLAY_TYPE = "displayType";
    public static final String CUSTOM_TYPE = "customtype";
    public static final String SEARCH_PARAM = "param";
    public static final String SEARCH_PARAM_ALL = "ALL";
    public static final String SEARCH_PARAM_CURRENTYEAR = "CurrentYear";
    public static final String SEARCH_PARAM_CURRENTMONTH = "CurrentMonth";
    public static final String FINANCEINGTYPE = "financeingtype";
    public static final String FINANCEINGCURRENCY = "financeingcurrency";
    public static final String FINANCEINGTERM = "financeingterm";
    public static final String FINANCEINGBANK = "financeingbank";
    public static final String ORG = "org";
    public static final String LOANRATE = "loanrate";
    public static final String MONTHSTR = "month";
    private static final String REPAYAMOUNT = "repayamount";
    private static final String TERM = "term";
    private static final String BANKCATE = "bankcate";
    private static final String BANKCATENAME = "bankcatename";
    private static final String CURRENCYNUMBER = "currencynumber";
    private static final String START_INT_DATE = "startintdate";
    private static final String FINANCETYPE = "financetype";
    private static final String PARAMNAME = "paramname";
    private static final String DATARANGE = "datarange";
    private static final String DATARANGENUMBER = "datarangenumber";
    private static final String REPAYRATEAMOUNT = "repayrateamount";
    private static final String FINANCETYPENAME = "financetypename";

    private FinanceingCostAnalsDataHelper() {
    }

    public static DataSet getMonthData(Map<String, Object> paramMap, String displayType, String[] groupby, String searchParam) {
        Long orgviewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get(ORG)).getLong("id");
        List orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgviewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet financeDataSet = null;
        DataSet dateDateSet = FinanceingCostAnalsDataHelper.getDateDateSet(queryDate);
        DataSet dateDateSetForAddEmptyRow = dateDateSet.copy();
        while (dateDateSet.hasNext()) {
            CharSequence[] charSequenceArray;
            Row row = dateDateSet.next();
            Date date = row.getDate("dateTime");
            if (StringUtils.isNotEmpty((String)searchParam)) {
                CharSequence[] charSequenceArray2 = new String[2];
                charSequenceArray2[0] = REPAYAMOUNT;
                charSequenceArray = charSequenceArray2;
                charSequenceArray2[1] = MergeOffsetHandler.ROW_OFFSETFILENAME;
            } else {
                String[] stringArray = new String[3];
                stringArray[0] = REPAYAMOUNT;
                stringArray[1] = MergeOffsetHandler.ROW_OFFSETFILENAME;
                charSequenceArray = stringArray;
                stringArray[2] = MergeOffsetHandler.COL_OFFSETFILENAME;
            }
            CharSequence[] amountCol = charSequenceArray;
            DataSet monthFinanceDataSet = FinanceDataHelper.getFinanceDataSet((String)FinanceingCostAnalsDataHelper.class.getName(), (List)orgIds, (Date)date, (Long)baseCurrency, (Long)orgviewId, (Long)orgId).filter("isequity = false").select(new String[]{ORG, REPAYAMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME, LOANRATE, CURRENCYNUMBER, FINANCETYPE, START_INT_DATE, TERM, BANKCATE, BANKCATENAME}).updateField(REPAYAMOUNT, String.join((CharSequence)"+", amountCol)).addFields(new String[]{"'" + row.getString(DATE_STR) + "'", row.getString(MONTHSTR), "to_date('" + DateUtils.formatString((Date)date, (String)"yyyy-MM-dd") + "', 'yy-MM-dd')", "'ALL'", ResManager.loadKDString((String)"'\u5b58\u91cf\u6570\u636e'", (String)"FinanceingCostAnalsDataHelper_21", (String)TMC_TDA_REPORT, (Object[])new Object[0]), "repayamount * loanrate"}, new String[]{DATE_STR, MONTHSTR, BIZDATE, SEARCH_PARAM, PARAMNAME, REPAYRATEAMOUNT});
            monthFinanceDataSet = FinanceingCostAnalsDataHelper.unionFilterData(searchParam, date, monthFinanceDataSet);
            if (financeDataSet != null) {
                financeDataSet = financeDataSet.union(monthFinanceDataSet);
                continue;
            }
            financeDataSet = monthFinanceDataSet;
        }
        boolean isrpt = StringUtils.isNotEmpty((String)searchParam);
        if (FINANCEINGTERM.equals(displayType) && financeDataSet != null) {
            financeDataSet = FinanceingCostAnalsDataHelper.handleDataSet(financeDataSet, isrpt);
        }
        financeDataSet = FinanceingCostAnalsDataHelper.getGroupByDataSet(displayType, groupby, financeDataSet, isrpt, dateDateSetForAddEmptyRow);
        return financeDataSet;
    }

    private static DataSet handleDataSet(DataSet ds, boolean isChangeChines) {
        ds = ds.addFields(new String[]{"''", "0"}, new String[]{DATARANGE, DATARANGENUMBER});
        List<String> dataRangeList = FinanceingCostAnalsDataHelper.getDataRangeList(isChangeChines);
        RowMeta rowMeta = ds.getRowMeta();
        DataSet resultDataSet = DecisionAnlsHelper.createEmptyDataSet(rowMeta.getFieldNames(), rowMeta.getDataTypes());
        int len = dataRangeList.size();
        for (int i = 0; i < len; ++i) {
            DataSet filterDs = FinanceingCostAnalsDataHelper.filterDataSet(i == len - 1 ? ds : ds.copy(), dataRangeList, i).updateFields(new String[]{DATARANGE, DATARANGENUMBER}, new String[]{"'" + dataRangeList.get(i) + "'", "" + i});
            resultDataSet = resultDataSet == null ? filterDs : resultDataSet.union(filterDs);
        }
        return resultDataSet;
    }

    private static DataSet filterDataSet(DataSet ds, List<String> dataRangeList, int count) {
        return ds.filter(FinanceingCostAnalsDataHelper.buildFilter(dataRangeList, count));
    }

    private static FilterFunction buildFilter(final List<String> dataRangeList, final int count) {
        return new FilterFunction(){

            public boolean test(Row row) {
                String term = row.getString(FinanceingCostAnalsDataHelper.TERM);
                if (term != null) {
                    return FinanceingCostAnalsDataHelper.getDataRangeByTerm(term, dataRangeList).equals(dataRangeList.get(count));
                }
                return false;
            }
        };
    }

    private static String getDataRangeByTerm(String term, List<String> dataRangeList) {
        String result;
        boolean isContainMonthDay;
        if (EmptyUtil.isEmpty((String)term)) {
            return dataRangeList.get(5);
        }
        int indexYear = term.indexOf("y");
        int indexMonth = term.indexOf("m");
        int indexDay = term.indexOf("d");
        boolean bl = isContainMonthDay = indexMonth > 0 || indexDay > 0;
        if (indexYear > 0) {
            int year = Integer.parseInt(term.substring(0, indexYear));
            if (year == 1) {
                result = dataRangeList.get(2);
                if (!isContainMonthDay) {
                    result = dataRangeList.get(1);
                }
            } else if (1 < year && year <= 3) {
                result = dataRangeList.get(2);
                if (year == 3 && isContainMonthDay) {
                    result = dataRangeList.get(3);
                }
            } else if (3 < year && year <= 5) {
                result = dataRangeList.get(3);
                if (year == 5 && isContainMonthDay) {
                    result = dataRangeList.get(4);
                }
            } else if (5 < year && year <= 10) {
                result = dataRangeList.get(4);
                if (year == 10 && isContainMonthDay) {
                    result = dataRangeList.get(5);
                }
            } else {
                result = dataRangeList.get(5);
            }
        } else if (indexMonth < 0) {
            result = dataRangeList.get(0);
        } else {
            int month = Integer.parseInt(term.substring(0, indexMonth));
            if (month <= 6) {
                result = dataRangeList.get(0);
                if (month == 6 && indexDay > 0) {
                    result = dataRangeList.get(1);
                }
            } else {
                result = dataRangeList.get(1);
            }
        }
        return result;
    }

    public static DataSet unionFilterData(String searchParam, Date date, DataSet monthFinanceDataSet) {
        Date currentYearFirst = DateUtils.getFirstYearDate((Date)date);
        Date currentYearLast = date;
        Date currentMonthFirst = DateUtils.getFirstDayOfMonth((Date)date);
        Date currentMonthLast = DateUtils.getLastDayOfMonth((Date)date);
        HashMap<String, Date> params = new HashMap<String, Date>(8);
        if (StringUtils.isNotEmpty((String)searchParam)) {
            if (!SEARCH_PARAM_ALL.equals(searchParam)) {
                if (searchParam.equals(SEARCH_PARAM_CURRENTYEAR)) {
                    params.put("start", currentYearFirst);
                    params.put("end", currentYearLast);
                } else if (searchParam.equals(SEARCH_PARAM_CURRENTMONTH)) {
                    params.put("start", currentMonthFirst);
                    params.put("end", currentMonthLast);
                }
                monthFinanceDataSet = monthFinanceDataSet.filter("startintdate >= start and startintdate <= end", params).updateField(PARAMNAME, FinanceingCostAnalsDataHelper.getParamName(searchParam)).updateField(SEARCH_PARAM, "'" + searchParam + "'");
            }
        } else {
            params.put("currentYearFirst", currentYearFirst);
            params.put("currentYearLast", currentYearLast);
            DataSet currentYearDataSet = monthFinanceDataSet.copy().filter("startintdate >= currentYearFirst and startintdate <= currentYearLast", params).updateField(SEARCH_PARAM, "'CurrentYear'").updateField(PARAMNAME, FinanceingCostAnalsDataHelper.getParamName(SEARCH_PARAM_CURRENTYEAR));
            monthFinanceDataSet = monthFinanceDataSet.union(currentYearDataSet);
            params.put("currentMonthFirst", currentMonthFirst);
            params.put("currentMonthLast", currentMonthLast);
            DataSet currentMonthDataSet = monthFinanceDataSet.copy().filter("startintdate >= currentMonthFirst and startintdate <= currentMonthLast", params).updateField(SEARCH_PARAM, "'CurrentMonth'").updateField(PARAMNAME, FinanceingCostAnalsDataHelper.getParamName(SEARCH_PARAM_CURRENTMONTH));
            monthFinanceDataSet = monthFinanceDataSet.union(currentMonthDataSet);
        }
        return monthFinanceDataSet;
    }

    private static String getParamName(String type) {
        if (SEARCH_PARAM_CURRENTYEAR.equals(type)) {
            return ResManager.loadKDString((String)"'\u672c\u5e74\u65b0\u589e'", (String)"FinanceingCostAnalsDataHelper_22", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"'\u672c\u6708\u65b0\u589e'", (String)"FinanceingCostAnalsDataHelper_23", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
    }

    private static DataSet getGroupByDataSet(String displayType, String[] groupby, DataSet financeDataSet, boolean isrpt, DataSet dateDateSet) {
        if (financeDataSet != null) {
            financeDataSet = isrpt ? FinanceingCostAnalsDataHelper.getRepdataSet(financeDataSet, displayType, groupby) : FinanceingCostAnalsDataHelper.getQingRptDataSet(financeDataSet, displayType, groupby, dateDateSet);
        }
        return financeDataSet;
    }

    private static DataSet getRepdataSet(DataSet financeDataSet, String displayType, String[] groupby) {
        if (FINANCEINGCURRENCY.equals(displayType)) {
            String expr = "case when currencynumber = '" + CurrencyTypeEnum.CNY.getNumber() + "' then 0 when currencynumber = '" + CurrencyTypeEnum.USD.getNumber() + "' then 1 when currencynumber = '" + CurrencyTypeEnum.HKD.getNumber() + "' then 2 when (currencynumber != '" + CurrencyTypeEnum.CNY.getNumber() + "' and currencynumber != '" + CurrencyTypeEnum.USD.getNumber() + "' and currencynumber != '" + CurrencyTypeEnum.HKD.getNumber() + "') then 3 end";
            financeDataSet = financeDataSet.addField(expr, FINANCEINGCURRENCY);
            List<String> financeCurrencyList = Arrays.asList("cny", "usd", "hkd", "other");
            financeDataSet = FinanceingCostAnalsDataHelper.getDataSetByFinanceList(financeDataSet, financeCurrencyList, FINANCEINGCURRENCY, groupby);
        } else if (FINANCEINGTERM.equals(displayType)) {
            List<String> financeTermList = Arrays.asList("insixmonth", "sixtotwelvemonth", "onetothreeyear", "threetofiveyear", "fivetotenyear", "overtenyear");
            financeDataSet = FinanceingCostAnalsDataHelper.getDataSetByFinanceList(financeDataSet, financeTermList, DATARANGENUMBER, groupby);
        } else {
            List<String> financeTypeList = Arrays.asList("bank", "bond", "company", "other");
            financeDataSet = FinanceingCostAnalsDataHelper.getDataSetByFinanceList(financeDataSet, financeTypeList, FINANCETYPE, groupby);
        }
        return financeDataSet;
    }

    private static DataSet getDataSetByFinanceList(DataSet financeDataSet, List<String> financetypelist, String financeingnumber, String[] groupby) {
        List<Integer> financeTypes = FinanceingCostAnalsDataHelper.getFinanceTypes(financeDataSet, financeingnumber);
        GroupbyDataSet groupbyDataSet = financeDataSet.groupBy((String[])ArrayUtils.addAll((Object[])groupby, (Object[])new String[]{SEARCH_PARAM, PARAMNAME}));
        for (Integer typeInt : financeTypes) {
            groupbyDataSet.sum("case when " + financeingnumber + " = " + typeInt + " then repayamount * loanrate end", financetypelist.get(typeInt) + "rateamount").sum("case when " + financeingnumber + " = " + typeInt + " then repayamount end", financetypelist.get(typeInt) + "amount").sum("case when " + financeingnumber + " = " + typeInt + " then coloffset end", financetypelist.get(typeInt) + "amountcoloffset").sum("case when " + financeingnumber + " = " + typeInt + " then coloffset * loanrate end", financetypelist.get(typeInt) + "rateamountcoloffset");
        }
        groupbyDataSet.sum("repayamount * loanrate end ", "avasumrateamount").sum(REPAYAMOUNT, "avasumamount").sum(MergeOffsetHandler.COL_OFFSETFILENAME, "avasumamountcoloffset").sum(MergeOffsetHandler.COL_OFFSETFILENAME + " * loanrate", "avasumrateamountcoloffset");
        return groupbyDataSet.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Integer> getFinanceTypes(DataSet ds, String type) {
        ArrayList<Integer> financeTypes = new ArrayList<Integer>(6);
        try (DataSet copy = null;){
            copy = ds.copy().groupBy(new String[]{type}).finish();
            while (copy.hasNext()) {
                Row row = copy.next();
                Integer financeType = row.getInteger(type);
                if (financeType == null) continue;
                financeTypes.add(financeType);
            }
            ArrayList<Integer> arrayList = financeTypes;
            return arrayList;
        }
    }

    private static DataSet getQingRptDataSet(DataSet financeDataSet, String displayType, String[] groupby, DataSet dateDateSet) {
        if (FINANCEINGTYPE.equals(displayType)) {
            financeDataSet = financeDataSet.groupBy((String[])ArrayUtils.addAll((Object[])groupby, (Object[])new String[]{SEARCH_PARAM, PARAMNAME})).sum(REPAYRATEAMOUNT).sum(REPAYAMOUNT).finish();
            List<Integer> financeTypes = FinanceingCostAnalsDataHelper.getFinanceTypes(financeDataSet, FINANCETYPE);
            financeDataSet = FinanceingCostAnalsDataHelper.addEmptyRow(dateDateSet, financeDataSet, financeTypes, FINANCETYPE);
            String expr = "case when financetype = 0 then '%1$s' when financetype = 1 then '%2$s' when financetype = 2 then '%3$s' when financetype = 3 then '%4$s' end";
            financeDataSet = financeDataSet.addField(String.format(expr, ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceingCostAnalsDataHelper_29", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceingCostAnalsDataHelper_30", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceingCostAnalsDataHelper_31", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceingCostAnalsDataHelper_32", (String)TMC_TDA_REPORT, (Object[])new Object[0])), FINANCETYPENAME);
        } else {
            if (FINANCEINGBANK.equals(displayType)) {
                financeDataSet = financeDataSet.filter("bankcate > 0");
                financeDataSet = financeDataSet.groupBy((String[])ArrayUtils.addAll((Object[])groupby, (Object[])new String[]{SEARCH_PARAM, PARAMNAME})).sum(REPAYRATEAMOUNT).sum(REPAYAMOUNT).finish();
                financeDataSet = FinanceingCostAnalsDataHelper.addEmptyRow(dateDateSet, financeDataSet, null, BANKCATE);
                return financeDataSet;
            }
            if (FINANCEINGTERM.equals(displayType)) {
                GroupbyDataSet groupbyDataSet = financeDataSet.groupBy((String[])ArrayUtils.addAll((Object[])groupby, (Object[])new String[]{SEARCH_PARAM, PARAMNAME}));
                financeDataSet = groupbyDataSet.sum("case when datarangenumber = 0 then repayamount * loanrate end ", "insixmonthrateamount").sum("case when datarangenumber = 1 then repayamount * loanrate end ", "sixtotwelvemonthrateamount").sum("case when datarangenumber = 2 then repayamount * loanrate end ", "onetothreeyearrateamount").sum("case when datarangenumber = 3 then repayamount * loanrate end ", "threetofiveyearrateamount").sum("case when datarangenumber = 4 then repayamount * loanrate end ", "fivetotenyearrateamount").sum("case when datarangenumber = 5 then repayamount * loanrate end ", "overtenyearrateamount").sum("case when datarangenumber = 0 then repayamount end", "insixmonthamount").sum("case when datarangenumber = 1 then repayamount end", "sixtotwelvemonthamount").sum("case when datarangenumber = 2 then repayamount end", "onetothreeyearamount").sum("case when datarangenumber = 3 then repayamount end", "threetofiveyearamount").sum("case when datarangenumber = 4 then repayamount end", "fivetotenyearamount").sum("case when datarangenumber = 5 then repayamount end", "overtenyearamount").sum("repayamount * loanrate end ", "avasumrateamount").sum(REPAYAMOUNT, "avasumamount").finish();
                financeDataSet = FinanceingCostAnalsDataHelper.addEmptyRow(dateDateSet, financeDataSet, null, null);
                return financeDataSet;
            }
            String expr = "case when currencynumber = '" + CurrencyTypeEnum.CNY.getNumber() + "' then %1$s when currencynumber = '" + CurrencyTypeEnum.USD.getNumber() + "' then %2$s when currencynumber = '" + CurrencyTypeEnum.HKD.getNumber() + "' then %3$s when (currencynumber != '" + CurrencyTypeEnum.CNY.getNumber() + "' and currencynumber != '" + CurrencyTypeEnum.USD.getNumber() + "' and currencynumber != '" + CurrencyTypeEnum.HKD.getNumber() + "') then %4$s end";
            financeDataSet = financeDataSet.addField(String.format(expr, "0", "1", "2", "3"), "currencysort");
            financeDataSet = financeDataSet.groupBy((String[])ArrayUtils.addAll((Object[])groupby, (Object[])new String[]{SEARCH_PARAM, PARAMNAME})).sum(REPAYRATEAMOUNT).sum(REPAYAMOUNT).finish();
            List<Integer> financeTypes = FinanceingCostAnalsDataHelper.getFinanceTypes(financeDataSet, "currencysort");
            financeDataSet = FinanceingCostAnalsDataHelper.addEmptyRow(dateDateSet, financeDataSet, financeTypes, "currencysort");
            String addCurrencyNameExpr = "case when currencysort = 0 then '%1$s' when currencysort =  1 then '%2$s' when currencysort =  2 then '%3$s' when currencysort =  3 then '%4$s' end";
            financeDataSet = financeDataSet.addField(String.format(addCurrencyNameExpr, ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"FinanceingCostAnalsDataHelper_33", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u7f8e\u5143", (String)"FinanceingCostAnalsDataHelper_34", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u6e2f\u5e01", (String)"FinanceingCostAnalsDataHelper_35", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceingCostAnalsDataHelper_32", (String)TMC_TDA_REPORT, (Object[])new Object[0])), "currencytypename");
        }
        return financeDataSet;
    }

    private static DataSet addEmptyRow(DataSet dateDateSet, DataSet ds, List<Integer> financeTypes, String fieldNumber) {
        RowMeta rowMeta = ds.getRowMeta();
        HashMap<String, String> paramToNameMap = new HashMap<String, String>(6);
        paramToNameMap.put(SEARCH_PARAM_ALL, FinanceStatisticTypeEnum.ALL.getName());
        paramToNameMap.put(SEARCH_PARAM_CURRENTMONTH, FinanceStatisticTypeEnum.MONTH.getName());
        paramToNameMap.put(SEARCH_PARAM_CURRENTYEAR, FinanceStatisticTypeEnum.YEAR.getName());
        HashMap<Long, String> topBank = new HashMap<Long, String>(16);
        if (BANKCATE.equals(fieldNumber)) {
            DataSet topBankDs = ds.copy().groupBy(new String[]{BANKCATE, BANKCATENAME}).sum(REPAYAMOUNT).finish().orderBy(new String[]{"repayamount desc"});
            for (Row topBankRow : topBankDs) {
                topBank.put(topBankRow.getLong(BANKCATE), topBankRow.getString(BANKCATENAME));
                if (topBank.size() != 6) continue;
                break;
            }
        }
        while (dateDateSet.hasNext()) {
            Row row = dateDateSet.next();
            String datastr = row.getString(DATE_STR);
            String bizdate = DateUtils.formatString((Date)row.getDate("dateTime"), (String)"yyyy-MM-dd");
            String month = row.getString(MONTHSTR);
            for (Map.Entry entry : paramToNameMap.entrySet()) {
                DataSet bizDs;
                String filterConditions;
                if (financeTypes != null) {
                    for (Integer n : financeTypes) {
                        filterConditions = String.format("dateStr = '%1$s' and param = '%2$s' and %3$s = %4$s", datastr, entry.getKey(), fieldNumber, n);
                        if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                        bizDs = DecisionAnlsHelper.createRow(FinanceingCostAnalsDataHelper.class.getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{bizdate, month, datastr, n, entry.getKey(), entry.getValue(), 0.0, 0.0}));
                        ds = ds.union(bizDs);
                    }
                    continue;
                }
                if (BANKCATE.equals(fieldNumber)) {
                    for (Map.Entry entry2 : topBank.entrySet()) {
                        filterConditions = String.format("dateStr = '%1$s' and param = '%2$s' and bankcate = %3$s", datastr, entry.getKey(), fieldNumber, entry2.getKey());
                        if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                        bizDs = DecisionAnlsHelper.createRow(FinanceingCostAnalsDataHelper.class.getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{bizdate, month, datastr, entry2.getKey(), entry2.getValue(), entry.getKey(), entry.getValue(), 0.0, 0.0}));
                        ds = ds.union(bizDs);
                    }
                    continue;
                }
                String filterConditions2 = String.format("dateStr = '%1$s' and param = '%2$s'", datastr, entry.getKey());
                if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions2))) continue;
                DataSet dataSet = DecisionAnlsHelper.createRow(FinanceingCostAnalsDataHelper.class.getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{bizdate, month, datastr, entry.getKey(), entry.getValue(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}));
                ds = ds.union(dataSet);
            }
        }
        if (BANKCATE.equals(fieldNumber)) {
            DataSet averageDataSet = ds.copy().groupBy(new String[]{BIZDATE, MONTHSTR, DATE_STR, SEARCH_PARAM, PARAMNAME}).sum(REPAYAMOUNT).sum(REPAYRATEAMOUNT).finish();
            averageDataSet = averageDataSet.addFields(new String[]{"99", String.format("'%s'", ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceingCostBankDataPlugin_9", (String)TMC_TDA_REPORT, (Object[])new Object[0]))}, new String[]{BANKCATE, BANKCATENAME});
            ds = ds.filter("bankcate in topbankcate", Collections.singletonMap("topbankcate", topBank.keySet()));
            ds = ds.union(averageDataSet.select(ds.getRowMeta().getFieldNames()));
            ds = ds.addField("case when (repayamount = 0 or repayamount is null)  then 0  else repayrateamount/repayamount end", "rate").orderBy(new String[]{BIZDATE});
        }
        return ds;
    }

    public static DataSet getDateDateSet(Date queryDate) {
        Calendar cal = Calendar.getInstance();
        ArrayList<Object[]> result = new ArrayList<Object[]>(12);
        cal.setTime(queryDate);
        int nowMonth = DateUtils.getMonth((Date)queryDate);
        result.add(new Object[]{nowMonth, queryDate, 0, DateUtils.formatString((Date)queryDate, (String)"yyyyMM")});
        for (int i = 0; i < 11; ++i) {
            cal.add(2, -1);
            Date lastMonthDate = DateUtils.getMaxMonthDate((Date)cal.getTime());
            int month = DateUtils.getMonth((Date)lastMonthDate);
            String showStr = DateUtils.formatString((Date)lastMonthDate, (String)"yyyyMM");
            result.add(new Object[]{month, lastMonthDate, i, showStr});
        }
        return DecisionAnlsHelper.createRow("kd.tmc.tda.report.finance.helper.FinanceingCostAnalsDataHelper", new String[]{MONTHSTR, "dateTime", "sort", DATE_STR}, new DataType[]{DataType.IntegerType, DataType.DateType, DataType.IntegerType, DataType.StringType}, result);
    }

    public static List<Pair<String, String>> getSumRptCols(String type) {
        ArrayList<Pair<String, String>> cols = new ArrayList<Pair<String, String>>(5);
        if (FINANCEINGCURRENCY.equals(type)) {
            cols.add(new Pair((Object)"cny", (Object)ResManager.loadKDString((String)"\u4eba\u6c11\u5e01", (String)"FinanceingCostAnalsDataHelper_13", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add(new Pair((Object)"usd", (Object)ResManager.loadKDString((String)"\u7f8e\u5143", (String)"FinanceingCostAnalsDataHelper_14", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add(new Pair((Object)"hkd", (Object)ResManager.loadKDString((String)"\u6e2f\u5e01", (String)"FinanceingCostAnalsDataHelper_15", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add(new Pair((Object)"other", (Object)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceingCostAnalsDataHelper_19", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
        } else if (FINANCEINGTERM.equals(type)) {
            cols.add(new Pair((Object)"insixmonth", (Object)ResManager.loadKDString((String)"6\u4e2a\u6708\u4ee5\u5185", (String)"FinanceingCostAnalsDataHelper_24", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add(new Pair((Object)"sixtotwelvemonth", (Object)ResManager.loadKDString((String)"6\u4e2a\u6708-1\u5e74", (String)"FinanceingCostAnalsDataHelper_25", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add(new Pair((Object)"onetothreeyear", (Object)ResManager.loadKDString((String)"1-3\u5e74", (String)"FinanceingCostAnalsDataHelper_38", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add(new Pair((Object)"threetofiveyear", (Object)ResManager.loadKDString((String)"3-5\u5e74", (String)"FinanceingCostAnalsDataHelper_39", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add((Pair<String, String>)new Pair((Object)"fivetotenyear", (Object)ResManager.loadKDString((String)"5-10\u5e74", (String)"FinanceingCostAnalsDataHelper_27", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add((Pair<String, String>)new Pair((Object)"overtenyear", (Object)ResManager.loadKDString((String)"10\u5e74\u4ee5\u4e0a", (String)"FinanceingCostAnalsDataHelper_28", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
        } else {
            cols.add(new Pair((Object)"bank", (Object)ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"FinanceingCostAnalsDataHelper_16", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            cols.add(new Pair((Object)"bond", (Object)ResManager.loadKDString((String)"\u503a\u5238\u53d1\u884c", (String)"FinanceingCostAnalsDataHelper_17", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
            if (containCompany) {
                cols.add(new Pair((Object)"company", (Object)ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"FinanceingCostAnalsDataHelper_18", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
            }
            cols.add(new Pair((Object)"other", (Object)ResManager.loadKDString((String)"\u5176\u4ed6", (String)"FinanceingCostAnalsDataHelper_19", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
        }
        cols.add(new Pair((Object)"avasum", (Object)FinanceingCostAnalsDataHelper.getWeightAvgCostKDString()));
        return cols;
    }

    public static String getWeightAvgCostKDString() {
        return ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceingCostAnalsDataHelper_20", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
    }

    public static List<String> getDataRangeList(Boolean isChangeChines) {
        if (isChangeChines.booleanValue()) {
            return Arrays.asList(ResManager.loadKDString((String)"6\u4e2a\u6708\u4ee5\u5185", (String)"FinanceingCostAnalsDataHelper_24", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"6\u4e2a\u6708-1\u5e74", (String)"FinanceingCostAnalsDataHelper_25", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"1-3\u5e74", (String)"FinanceingCostAnalsDataHelper_38", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"3-5\u5e74", (String)"FinanceingCostAnalsDataHelper_39", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"5-10\u5e74", (String)"FinanceingCostAnalsDataHelper_27", (String)TMC_TDA_REPORT, (Object[])new Object[0]), ResManager.loadKDString((String)"10\u5e74\u4ee5\u4e0a", (String)"FinanceingCostAnalsDataHelper_28", (String)TMC_TDA_REPORT, (Object[])new Object[0]));
        }
        return Arrays.asList("insixmonth", "sixtotwelvemonth", "onetothreeyear", "threetofiveyear", "fivetotenyear", "overtenyear");
    }
}

