/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public abstract class AbstractFinDebtDistDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    protected static final String ORG = "org";
    protected static final String REGION = "region";
    protected static final String CURRENCY = "currency";
    protected static final String REPAY_AMOUNT = "repayamount";
    protected static final String TOTAL_DEBT = "totaldebt";
    protected static final String IS_EQUITY = "totalequity";
    protected static final String ROW_OFFSET = "rowoffset";
    protected static final String COL_OFFSET = "coloffset";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{TOTAL_DEBT, ResManager.loadKDString((String)"\u6709\u606f\u8d1f\u503a\u603b\u989d", (String)"AbstractFinDebtDistDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{IS_EQUITY, ResManager.loadKDString((String)"\u6743\u76ca\u5de5\u5177", (String)"AbstractFinDebtDistDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{CURRENCY, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"AbstractFinDebtDistDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"currencynum", ResManager.loadKDString((String)"\u5e01\u79cd\u7f16\u7801", (String)"AbstractFinDebtDistDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{REGION, ResManager.loadKDString((String)"\u5730\u57df\u8303\u56f4", (String)"AbstractFinDebtDistDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"showname", ResManager.loadKDString((String)"\u5c55\u793a\u540d\u79f0", (String)"AbstractFinDebtDistDataPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"equityamount", ResManager.loadKDString((String)"\u91d1\u989d", (String)"AbstractFinDebtDistDataPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet resultSet;
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        Long orgId = ((DynamicObject)paramMap.get(ORG)).getLong("id");
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet allDs = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)currencyId, (Long)orgViewId, (Long)orgId);
        String selectStr = "org, repayamount, isequity, isoutgroup, rowoffset, coloffset,case when region=1 then region else 99 end as region,case when currency=1 or currency=2 or currency=6 then currency else 99 end as currency";
        allDs = allDs.select(selectStr);
        String groupKey = this.getGroupFields();
        if (EmptyUtil.isEmpty((String)groupKey)) {
            return allDs;
        }
        DataSet[] splitDataSet = ORG.equals(groupKey) ? allDs.splitByFilter(new String[]{"isequity=false"}, true) : allDs.splitByFilter(new String[]{"isequity=false"}, false);
        DataSet debtSumSet = splitDataSet[0].groupBy(new String[]{groupKey}).sum(REPAY_AMOUNT, TOTAL_DEBT).sum(ROW_OFFSET).sum(COL_OFFSET).finish();
        debtSumSet = debtSumSet.updateField(TOTAL_DEBT, String.join((CharSequence)"+", TOTAL_DEBT, ROW_OFFSET, COL_OFFSET)).select(new String[]{groupKey, TOTAL_DEBT});
        debtSumSet = debtSumSet.addField("0", IS_EQUITY);
        switch (groupKey) {
            case "org": {
                DataSet equitySumSet = splitDataSet[1].groupBy(new String[]{groupKey}).sum(REPAY_AMOUNT, TOTAL_DEBT).finish();
                equitySumSet = equitySumSet.addField("1", IS_EQUITY);
                resultSet = debtSumSet.union(equitySumSet);
                resultSet = resultSet.groupBy(new String[]{IS_EQUITY}).sum(TOTAL_DEBT).finish();
                resultSet = DecisionAnlsHelper.creatAbsentRow(resultSet, IS_EQUITY, Arrays.asList("0", "1"), 0, () -> new Object[]{"", 0.0});
                break;
            }
            case "currency": {
                resultSet = DecisionAnlsHelper.creatAbsentRow(debtSumSet, CURRENCY, Arrays.asList("1", "2", "6", "99"), 0, () -> new Object[]{"", "0", "0"});
                resultSet = resultSet.addField(CURRENCY, "currencynum");
                String currencyStr = String.format("case when currency=1 then '%1$s' when currency=2 then '%2$s' when currency=6 then '%3$s' else '%4$s' end", CurrencyTypeEnum.CNY.getName(), CurrencyTypeEnum.HKD.getName(), CurrencyTypeEnum.USD.getName(), this.getOtherCurrencyType());
                resultSet = resultSet.updateField(CURRENCY, currencyStr);
                break;
            }
            case "region": {
                resultSet = DecisionAnlsHelper.creatAbsentRow(debtSumSet, REGION, Arrays.asList("1", "99"), 0, () -> new Object[]{"", "0", "0"});
                resultSet = resultSet.addField(REGION, "regionnum");
                String regionStr = String.format("case when region=1 then '%1$s' else '%2$s' end", AbstractFinDebtDistDataPlugin.getDomesticType(), AbstractFinDebtDistDataPlugin.getForeignType());
                resultSet = resultSet.updateField(REGION, regionStr);
                break;
            }
            default: {
                resultSet = debtSumSet;
            }
        }
        resultSet = this.updateRowMeta(resultSet).select(new String[]{IS_EQUITY, "currencynum", CURRENCY, REGION, TOTAL_DEBT});
        return this.handleDataSet(resultSet);
    }

    private DataSet handleDataSet(DataSet ds) {
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds);
        ds = dataSets[0];
        final BigDecimal[] equityAmount = this.getEquityAmount(dataSets[1]);
        ds = ds.addFields(new String[]{"' '", "0.0"}, new String[]{"showname", "equityamount"});
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                String isEquity = row.getString(AbstractFinDebtDistDataPlugin.IS_EQUITY);
                for (String fieldName : rowMetas.getFieldNames()) {
                    if ("showname".equals(fieldName)) {
                        if ("1".equals(isEquity)) {
                            rowInfo.add(ResManager.loadKDString((String)"\u6709\u606f\u8d1f\u503a\uff08\u542b\u6743\u76ca\u5de5\u5177\uff09", (String)"AbstractFinDebtDistDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]));
                            continue;
                        }
                        rowInfo.add(ResManager.loadKDString((String)"\u6743\u76ca\u5de5\u5177", (String)"AbstractFinDebtDistDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]));
                        continue;
                    }
                    if ("equityamount".equals(fieldName)) {
                        if ("1".equals(isEquity)) {
                            rowInfo.add(equityAmount[0].add(equityAmount[1]));
                            continue;
                        }
                        rowInfo.add(equityAmount[0]);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal[] getEquityAmount(DataSet ds) {
        BigDecimal equityAmount = BigDecimal.ZERO;
        BigDecimal noEquityAmount = BigDecimal.ZERO;
        try {
            for (Row row : ds) {
                if ("1".equals(row.getString(IS_EQUITY))) {
                    equityAmount = row.getBigDecimal(TOTAL_DEBT);
                    continue;
                }
                noEquityAmount = row.getBigDecimal(TOTAL_DEBT);
            }
        }
        finally {
            ds.close();
        }
        return new BigDecimal[]{equityAmount, noEquityAmount};
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("cfm_loanbill");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return CURRENCY;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(this.getPenetrateEntityName());
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(TOTAL_DEBT);
        fields.add("equityamount");
        return fields;
    }

    protected abstract String getPenetrateEntityName();

    protected abstract String getGroupFields();

    public static String getDomesticType() {
        return ResManager.loadKDString((String)"\u5883\u5185\u6709\u606f\u8d1f\u503a", (String)"AbstractFinDebtDistDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    public static String getForeignType() {
        return ResManager.loadKDString((String)"\u5883\u5916\u6709\u606f\u8d1f\u503a", (String)"AbstractFinDebtDistDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private String getOtherCurrencyType() {
        return ResManager.loadKDString((String)"\u5176\u4ed6", (String)"AbstractFinDebtDistDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private DataSet updateRowMeta(DataSet dataSet) {
        Object[] fieldNames = dataSet.getRowMeta().getFieldNames();
        if (!ArrayUtils.contains((Object[])fieldNames, (Object)CURRENCY)) {
            dataSet = dataSet.addFields(new String[]{"'Not Selected'", "0"}, new String[]{CURRENCY, "currencynum"});
        }
        if (!ArrayUtils.contains((Object[])fieldNames, (Object)REGION)) {
            dataSet = dataSet.addField("'Not Selected'", REGION);
        }
        return dataSet;
    }
}

