/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.tda.common.helper.FinanceEquityDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinanceEquityAnalDataHelper;

public class EquityAnalysisQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String LASTMONTH_0_REPAYAMOUNT = "lastmonth_0repayamount";
    private static final String LASTMONTH_1_REPAYAMOUNT = "lastmonth_1repayamount";
    private static final String LASTMONTH_0_PERCENTAGE = "lastmonth_0percentage";
    private static final String LASTMONTH_1_PERCENTAGE = "lastmonth_1percentage";
    private static final String TDA_EQUITYANALRPT = "tda_equityanalrpt";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"mixorgname", ResManager.loadKDString((String)"\u5355\u4f4d\u540d\u79f0", (String)"EquityAnalysisQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{LASTMONTH_0_REPAYAMOUNT, ResManager.loadKDString((String)"\u672c\u6708", (String)"EquityAnalysisQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{LASTMONTH_1_REPAYAMOUNT, ResManager.loadKDString((String)"\u5e74\u521d", (String)"EquityAnalysisQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{LASTMONTH_0_PERCENTAGE, ResManager.loadKDString((String)"\u672c\u6708\u6210\u672c", (String)"EquityAnalysisQingAnlsPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{LASTMONTH_1_PERCENTAGE, ResManager.loadKDString((String)"\u5e74\u521d\u6210\u672c", (String)"EquityAnalysisQingAnlsPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return field;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList(TDA_EQUITYANALRPT);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "mixorgname";
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId(TDA_EQUITYANALRPT);
        this.fireLinkageShowForm(view, param);
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        String queryDateString = DateUtils.formatString((Date)queryDate, (String)"yyyyMMdd");
        Date lastYearSameDate = DateUtils.getLastDateOfAnyMonth((Date)queryDate, (int)-12);
        Date lastMonthDate = DateUtils.getLastYearDate((Date)lastYearSameDate);
        String lastMonthDateString = DateUtils.formatString((Date)lastMonthDate, (String)"yyyyMMdd");
        List<String> dateStringFields = Arrays.asList(queryDateString, lastMonthDateString);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet allData = FinanceEquityDataHelper.getFinanceDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryDate"), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId);
        DataSet[] splitDataSet = allData.splitByFilter(new String[]{"datestring = '" + queryDateString + "'", "datestring = '" + lastMonthDateString + "'"}, false);
        DataSet queryDateResult = splitDataSet[0];
        DataSet lastMonthDateResult = splitDataSet[1];
        DataSet uionResult = queryDateResult.union(lastMonthDateResult);
        DataSet result = FinanceEquityAnalDataHelper.dealRow(dateStringFields, orgViewId, uionResult);
        result = result.addField("datestring_" + queryDateString + "repayamount", LASTMONTH_0_REPAYAMOUNT);
        result = result.addField("datestring_" + lastMonthDateString + "repayamount", LASTMONTH_1_REPAYAMOUNT);
        result = result.addField("datestring_" + queryDateString + "percent", LASTMONTH_0_PERCENTAGE);
        result = result.addField("datestring_" + lastMonthDateString + "percent", LASTMONTH_1_PERCENTAGE);
        List secondOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)orgId, (boolean)true);
        result = CollectionUtils.isNotEmpty((Collection)secondOrgIds) ? result.filter("rowid in secondOrgIds", Collections.singletonMap("secondOrgIds", secondOrgIds)) : result.filter("rowid = id", Collections.singletonMap("id", orgId));
        return result;
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.add(LASTMONTH_0_REPAYAMOUNT);
        fields.add(LASTMONTH_1_REPAYAMOUNT);
        return fields;
    }
}

