/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.common.enums.CurrencyTypeEnum;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinCostCurrencyPeriodQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String CURRENCY_NUMBER = "currencynumber";
    private static final String FINANCE_COST = "financeCost";
    private static final String DATE_RANGE = "dateRange";
    private static final String DATE = "date";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{CURRENCY_NUMBER, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"FinCostCurrencyPeriodQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE, ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"FinCostCurrencyPeriodQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE_RANGE, ResManager.loadKDString((String)"\u4e0b\u62c9\u6846\u8303\u56f4", (String)"FinCostCurrencyPeriodQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{FINANCE_COST, ResManager.loadKDString((String)"\u878d\u8d44\u6210\u672c", (String)"FinCostCurrencyPeriodQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        List queryDateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        DataSet allDs = FinanceCostDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), allorgids, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)0L, (List)queryDateList);
        allDs = allDs.select("creditorinnerorg,customtype,currencynumber,datetype,avgbalance,intrate");
        allDs = allDs.filter("creditorinnerorg not in allorgids", Collections.singletonMap("allorgids", allorgids));
        DataSet groupDs = allDs.groupBy(new String[]{"customtype", CURRENCY_NUMBER, "datetype"}).sum("avgbalance", "amount").sum("avgbalance*intrate", "rateamount").finish();
        groupDs = groupDs.updateField(CURRENCY_NUMBER, "case when currencynumber = 'CNY' OR currencynumber = 'USD' OR currencynumber = 'HKD' then currencynumber else 'OTH' end");
        DataSet[] groupDsCopy = DataSetHelper.copy((DataSet)groupDs, (int)3);
        groupDs = groupDsCopy[0];
        DataSet avgDataSet = groupDsCopy[1];
        DataSet avaDs = avgDataSet.groupBy(new String[]{"customtype", "datetype"}).sum("amount").sum("rateamount").finish();
        avaDs = avaDs.addField("'AVG'", CURRENCY_NUMBER);
        DataSet addData = this.dealEmptyRow(groupDsCopy[2].filter("currencynumber != 'OTH'"));
        DataSet allData = groupDs.filter("currencynumber != 'OTH'").union(addData);
        DataSet ds = allData.union(avaDs.select(groupDs.getRowMeta().getFieldNames()));
        ds = this.parseDateType(ds, queryDate);
        String typeName = String.format("case when currencynumber='%1$s' then '%2$s' when currencynumber='%3$s' then '%4$s' when currencynumber='%5$s' then '%6$s' when currencynumber='%7$s' then '%8$s' when currencynumber='%9$s' then '%10$s' else ' ' end", CurrencyTypeEnum.CNY.getNumber(), CurrencyTypeEnum.CNY.getName(), CurrencyTypeEnum.USD.getNumber(), CurrencyTypeEnum.USD.getName(), CurrencyTypeEnum.HKD.getNumber(), CurrencyTypeEnum.HKD.getName(), CurrencyTypeEnum.OTHER.getNumber(), CurrencyTypeEnum.OTHER.getName(), "AVG", ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceTypeEnum_4", (String)"tmc-tda-common", (Object[])new Object[0]));
        DataSet result = ds.addFields(new String[]{"case when amount is null or amount=0 then 0.0 else rateamount/(amount*100) end", typeName, "begindate", "customtype"}, new String[]{FINANCE_COST, "currencyname", DATE, DATE_RANGE});
        return result.orderBy(new String[]{DATE}).updateField(CURRENCY_NUMBER, "currencyname");
    }

    private DataSet parseDateType(DataSet ds, Date queryDate) {
        ds = ds.addField("'0'", "begindate");
        final String[] array = FinanceCostDateHelper.parseNewDateType((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    Integer dateType = row.getInteger("datetype");
                    if ("begindate".equals(fieldName) && dateType != null) {
                        rowInfo.add(array[dateType]);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    private DataSet dealEmptyRow(DataSet rows) {
        HashSet<String> allRow = new HashSet<String>(16);
        HashSet<String> dataRow = new HashSet<String>(16);
        ArrayList<Object[]> newRow = new ArrayList<Object[]>(10);
        HashSet<String> currencyType = new HashSet<String>(8);
        for (Row row : rows) {
            dataRow.add(row.getString("customtype") + "-" + row.getString(CURRENCY_NUMBER) + "-" + row.getInteger("datetype"));
            if (!currencyType.add(row.getString(CURRENCY_NUMBER))) continue;
            for (DateRangeEnum dateRangeEnum : DateRangeEnum.getCommonEnums()) {
                if (DateRangeEnum.HALF_YEAR == dateRangeEnum) continue;
                Integer start = dateRangeEnum.getStart();
                Integer end = dateRangeEnum.getEnd();
                for (int j = start.intValue(); j <= end; ++j) {
                    String key = dateRangeEnum.getValue() + "-" + row.getString(CURRENCY_NUMBER) + "-" + j;
                    allRow.add(key);
                }
            }
        }
        allRow.removeAll(dataRow);
        for (String tempRowKey : allRow) {
            String[] temps = tempRowKey.split("-");
            newRow.add(new Object[]{temps[0], temps[1], temps[2], 0.0, 0.0});
        }
        DataSet createRows = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rows.getRowMeta().getFieldNames(), rows.getRowMeta().getDataTypes(), newRow);
        return createRows;
    }

    @Override
    protected List<String> getLinkReport() {
        List<String> objects = Collections.singletonList("tda_fincostcryprdrpt");
        return objects;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return DATE_RANGE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_fincostcryprdrpt");
        showParameter.getCustomParams().put(DATE_RANGE, ids.get(0));
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(5, 4);
        }
        return value;
    }
}

