/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.helper.FinDebtTrendDataHelper;

public class FinDebtTrendDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String REPAYAMOUNT = "repayamount";
    private static final String DATE = "date";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{REPAYAMOUNT, ResManager.loadKDString((String)"\u6709\u606f\u8d1f\u503a", (String)"FinDebtTrendDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{DATE, ResManager.loadKDString((String)"\u65e5\u671f", (String)"InvestAmtSumQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currencyId = (Long)paramMap.get("basecurrency");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List<Long> orgIdSet = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        DataSet dateDataSet = FinDebtTrendDataHelper.getDateDataSet("tda_findebttrendqingrpt", queryDate);
        DataSet financeDataset = null;
        while (dateDataSet.hasNext()) {
            Row row = dateDataSet.next();
            Date date = row.getDate("dateTime");
            DataSet trendDateDataset = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIdSet, (Date)date, (Long)currencyId, (Long)orgViewId, (Long)orgId).filter("isequity = false").select("org, repayamount, rowoffset, coloffset").updateField(REPAYAMOUNT, String.join((CharSequence)"+", REPAYAMOUNT, MergeOffsetHandler.COL_OFFSETFILENAME, MergeOffsetHandler.ROW_OFFSETFILENAME));
            trendDateDataset = trendDateDataset.addField(row.getString("dateStr"), DATE);
            trendDateDataset = trendDateDataset.groupBy(new String[]{DATE}).sum(REPAYAMOUNT).finish();
            if (financeDataset != null) {
                financeDataset = financeDataset.union(trendDateDataset);
                continue;
            }
            financeDataset = trendDateDataset;
        }
        return financeDataset;
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(REPAYAMOUNT);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return DATE;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_findebttrendrpt");
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter param = new ReportShowParameter();
        param.getCustomParams().put(DATE, ids.get(0));
        param.setFormId(formId);
        this.fireLinkageShowForm(view, param);
    }
}

