/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.finance.qing.data.FinanceCostByBankDataPlugin;

public class FinanceCostByBankDiagramDataPlugin
extends FinanceCostByBankDataPlugin {
    private static final String AVGBALANCE = "avgbalance";
    private static final String INTEREST = "interest";
    private static final String CUSTOMTYPE = "customtype";
    private static final String BANK_CATE = "bankcate";
    private static final String BANK_CATENAME = "bankcatename";
    private static final String FINANCE_COST = "financeCost";
    private static final String DATE_RANGE = "dateRange";
    private static final String DATE_TYPE = "datetype";
    private static final String DATE = "date";
    public static final int TOP = 6;
    public static final String SORT = "sort";
    private Long AVG_BANK = 99999999999999999L;

    @Override
    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{BANK_CATE, ResManager.loadKDString((String)"\u94f6\u884cID", (String)"FinanceCostByBankDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{BANK_CATENAME, ResManager.loadKDString((String)"\u94f6\u884c\u7c7b\u578b", (String)"FinanceCostByBankDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE, ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"FinanceCostByBankDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{DATE_RANGE, ResManager.loadKDString((String)"\u4e0b\u62c9\u6846\u8303\u56f4", (String)"FinanceCostByBankDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{FINANCE_COST, ResManager.loadKDString((String)"\u878d\u8d44\u6210\u672c", (String)"FinanceCostByBankDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{SORT, ResManager.loadKDString((String)"\u6392\u5e8f", (String)"FinanceCostByBankDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"customtypename", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b\u540d\u79f0", (String)"FinanceCostTypeSectionDataPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{"customtypenum", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b\u7f16\u53f7", (String)"FinanceCostTypeSectionDataPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return fields;
    }

    @Override
    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet qingDs = super.getDataSet(paramMap).updateField(FINANCE_COST, "financeCost * 100");
        String customTypeTemplate = "case when dateRange='year' then '%1$s' when dateRange='half' then '%2$s' when dateRange='season' then '%3$s' when dateRange='month' then '%4$s' else ' ' end";
        String customTypeName = String.format(customTypeTemplate, DateRangeEnum.YEAR.getText(), DateRangeEnum.HALF_YEAR.getText(), DateRangeEnum.SEASON.getText(), DateRangeEnum.MONTH.getText());
        String customTypeNum = String.format(customTypeTemplate, DateRangeEnum.YEAR.getIndex(), DateRangeEnum.HALF_YEAR.getIndex(), DateRangeEnum.SEASON.getIndex(), DateRangeEnum.MONTH.getIndex());
        return qingDs.select(new String[]{BANK_CATE, BANK_CATENAME, DATE, DATE_RANGE, FINANCE_COST, SORT}).addFields(new String[]{customTypeName, customTypeNum}, new String[]{"customtypename", "customtypenum"}).orderBy(new String[]{DATE_RANGE, DATE, SORT});
    }

    private DataSet topIdsByRange(DataSet dataSet, Map<String, Map<Long, String>> orderMap) {
        dataSet = dataSet.orderBy(new String[]{"dateRange desc", "datetype desc", "avgbalance desc"});
        String[] filterStr = new String[4];
        DateRangeEnum.getCommonEnums().forEach(dateRangeEnum -> {
            Integer index = dateRangeEnum.getIndex();
            filterStr[index.intValue()] = "dateRange = '" + dateRangeEnum.getValue() + "'";
        });
        DataSet[] dataSets = dataSet.splitByFilter(filterStr, false);
        DataSet topDataSet = null;
        for (int i = 0; i < dataSets.length; ++i) {
            Row next;
            DataSet tempSet = dataSets[i];
            Iterator tempSetIterator = tempSet.copy().iterator();
            if (!tempSetIterator.hasNext()) continue;
            LinkedHashMap<Long, String> bankIdMap = new LinkedHashMap<Long, String>(8);
            Row next1 = (Row)tempSetIterator.next();
            bankIdMap.put(next1.getLong(BANK_CATE), next1.getString(BANK_CATENAME));
            String dateRange = next1.getString(DATE_RANGE);
            int dateType = next1.getInteger(DATE_TYPE);
            int row = 2;
            while (tempSetIterator.hasNext() && row++ <= 6 && (next = (Row)tempSetIterator.next()).getInteger(DATE_TYPE) == dateType) {
                bankIdMap.put(next.getLong(BANK_CATE), next.getString(BANK_CATENAME));
            }
            orderMap.put(dateRange, bankIdMap);
            tempSet = tempSet.filter("bankcate in bankIds", Collections.singletonMap("bankIds", bankIdMap.keySet()));
            topDataSet = topDataSet == null ? tempSet : topDataSet.union(tempSet);
        }
        if (topDataSet == null) {
            return DecisionAnlsHelper.createEmptyDataSet(dataSet.getRowMeta().getFieldNames(), dataSet.getRowMeta().getDataTypes());
        }
        return topDataSet;
    }

    private DataSet updateFields(DataSet financeCostDataSet, final Date queryDate, final Map<String, Map<Long, String>> orderMap) {
        final RowMeta rowMeta = financeCostDataSet.getRowMeta();
        return financeCostDataSet.map(new MapFunction(){

            public Object[] map(Row row) {
                Object[] data = RowUtil.toArray((Row)row);
                Integer dateType = row.getInteger(FinanceCostByBankDiagramDataPlugin.DATE_TYPE);
                int dateIndex = rowMeta.getFieldIndex(FinanceCostByBankDiagramDataPlugin.DATE, false);
                String dateRange = row.getString(FinanceCostByBankDiagramDataPlugin.DATE_RANGE);
                DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)dateRange);
                int diff = dateRangeEnum.getEnd() - dateType;
                String dateCaption = FinanceCostDateHelper.getDateCaption((Date)FinanceCostDateHelper.getNewDate((Date)queryDate), (String)dateRange, (String)dateRangeEnum.getShortName(), (int)diff);
                data[dateIndex] = dateCaption;
                Map bankIdMap = (Map)orderMap.get(dateRange);
                if (EmptyUtil.isNoEmpty((Object)bankIdMap)) {
                    ArrayList bankIds = new ArrayList(bankIdMap.keySet());
                    Long bankcate = row.getLong(FinanceCostByBankDiagramDataPlugin.BANK_CATE);
                    int sortIndex = rowMeta.getFieldIndex(FinanceCostByBankDiagramDataPlugin.SORT, false);
                    data[sortIndex] = bankcate.equals(FinanceCostByBankDiagramDataPlugin.this.AVG_BANK) ? 7 : bankIds.indexOf(bankcate) + 1;
                }
                return data;
            }

            public RowMeta getResultRowMeta() {
                return rowMeta;
            }
        });
    }

    @Override
    protected List<String> getLinkReport() {
        List<String> objects = Collections.singletonList("tda_fincostbybankrpt");
        return objects;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return DATE_RANGE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_fincostbybankrpt");
        showParameter.getCustomParams().put(DATE_RANGE, ids.get(0));
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Object translateCellDisplay(String Field2, Object value, Row rs) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(5, 4);
        }
        return value;
    }

    private DataSet createAbsentRow(DataSet dataSet, Map<String, Map<Long, String>> orderMap) {
        DataSet[] copyDs = DataSetHelper.copy((DataSet)dataSet, (int)2);
        dataSet = copyDs[0];
        Set<String> allRowKeys = this.getAllRowKeys(orderMap);
        Set<String> existsRowKeys = this.getExistsRowKeys(copyDs[1]);
        HashSet<String> absentRowKeys = new HashSet<String>(allRowKeys.size());
        for (String string : allRowKeys) {
            if (existsRowKeys.contains(string.substring(0, string.lastIndexOf("_")))) continue;
            absentRowKeys.add(string);
        }
        if (EmptyUtil.isNoEmpty(absentRowKeys)) {
            ArrayList<Object[]> collection = new ArrayList<Object[]>(absentRowKeys.size());
            for (String string : absentRowKeys) {
                String[] splitKey = string.split("_");
                Map<Long, String> bankIdMap = orderMap.get(splitKey[2]);
                Long bankId = Long.parseLong(splitKey[1]);
                String bankName = this.AVG_BANK.equals(bankId) ? ResManager.loadKDString((String)"\u52a0\u6743\u5e73\u5747\u6210\u672c", (String)"FinanceCostByBankDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]) : bankIdMap.get(bankId);
                collection.add(new Object[]{splitKey[0], splitKey[1], bankName, splitKey[2], "0.0", "0"});
            }
            RowMeta rowMeta = dataSet.getRowMeta();
            DataSet dataSet2 = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), collection);
            dataSet = dataSet.union(dataSet2);
        }
        return dataSet;
    }

    private Set<String> getExistsRowKeys(DataSet dataSet) {
        HashSet<String> exists = new HashSet<String>(256);
        for (Row next : dataSet) {
            String dateType = next.getString(DATE_TYPE);
            String termIndex = next.getString(BANK_CATE);
            String rowKey = dateType + "_" + termIndex;
            exists.add(rowKey);
        }
        return exists;
    }

    private Set<String> getAllRowKeys(Map<String, Map<Long, String>> orderMap) {
        List dateRangeEnums = DateRangeEnum.getCommonEnums();
        HashSet<String> allRowKeys = new HashSet<String>();
        for (DateRangeEnum dateRangeEnum : dateRangeEnums) {
            Integer start = dateRangeEnum.getStart();
            Integer end = dateRangeEnum.getEnd();
            String value = dateRangeEnum.getValue();
            Map<Long, String> bankIdMap = orderMap.get(value);
            if (bankIdMap == null) continue;
            for (int j = start.intValue(); j <= end; ++j) {
                for (Map.Entry<Long, String> entry : bankIdMap.entrySet()) {
                    String key = j + "_" + entry.getKey() + "_" + dateRangeEnum.getValue();
                    allRowKeys.add(key);
                }
                String key = j + "_" + this.AVG_BANK + "_" + dateRangeEnum.getValue();
                allRowKeys.add(key);
            }
        }
        return allRowKeys;
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put(DATE_RANGE, ((JSONArray)clickArgs.get((Object)"data")).get(3));
    }
}

