/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.enums.DateRangeEnum;
import kd.tmc.tda.common.enums.FinanceTypeEnum;
import kd.tmc.tda.common.helper.FinanceCostDataHelper;
import kd.tmc.tda.common.helper.FinanceCostDateHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceCostTypeSectionDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String FINANCE_TYPE = "financetype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"begindate", ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4", (String)"FinanceCostTypeSectionDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"frate", ResManager.loadKDString((String)"\u5229\u7387", (String)"FinanceCostTypeSectionDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"datetype", ResManager.loadKDString((String)"\u65e5\u671f\u6392\u5e8f", (String)"FinanceCostTypeSectionDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        field.add(new Object[]{FINANCE_TYPE, ResManager.loadKDString((String)"\u878d\u8d44\u7c7b\u578b", (String)"FinanceCostTypeSectionDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"financetypename", ResManager.loadKDString((String)"\u878d\u8d44\u7c7b\u578b\u540d\u79f0", (String)"FinanceCostTypeSectionDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"customtype", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b", (String)"FinanceCostTypeSectionDataPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"customtypename", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b\u540d\u79f0", (String)"FinanceCostTypeSectionDataPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"customtypenum", ResManager.loadKDString((String)"\u533a\u95f4\u7c7b\u578b\u7f16\u53f7", (String)"FinanceCostTypeSectionDataPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Int.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List orgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, Collections.singletonList(orgId), (boolean)true);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        List dateList = FinanceCostDateHelper.getAllQueryDateList((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        DataSet allDs = FinanceCostDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (List)dateList);
        allDs = allDs.select("creditorinnerorg,customtype,financetype,datetype,avgbalance,intrate");
        allDs = allDs.filter("creditorinnerorg not in allorgids", Collections.singletonMap("allorgids", orgIds));
        DataSet groupDs = allDs.groupBy(new String[]{"customtype", FINANCE_TYPE, "datetype"}).sum("avgbalance", "amount").sum("avgbalance*intrate", "rateamount").finish();
        DataSet[] groupDsCopy = DataSetHelper.copy((DataSet)groupDs, (int)2);
        groupDs = groupDsCopy[0];
        DataSet addData = this.dealEmptyRow(groupDsCopy[1]);
        DataSet allData = groupDs.union(addData);
        DataSet[] allDataCopy = DataSetHelper.copy((DataSet)allData, (int)2);
        allData = allDataCopy[0];
        DataSet avaDs = this.calculateAverage(allDataCopy[1]);
        DataSet ds = allData.union(avaDs.select(groupDs.getRowMeta().getFieldNames()));
        ds = this.parseDateType(ds, queryDate);
        String typeName = String.format("case when financetype=%1$s then '%2$s' when financetype=%3$s then '%4$s' when financetype=%5$s then '%6$s' when financetype=%7$s then '%8$s' when financetype=%9$s then '%10$s' else ' ' end", FinanceTypeEnum.BANK.getNumber(), FinanceTypeEnum.BANK.getText(), FinanceTypeEnum.BOND.getNumber(), FinanceTypeEnum.BOND.getText(), FinanceTypeEnum.COMPANY.getNumber(), FinanceTypeEnum.COMPANY.getText(), FinanceTypeEnum.OTHER.getNumber(), FinanceTypeEnum.OTHER.getText(), FinanceTypeEnum.AVERAGE.getNumber(), FinanceTypeEnum.AVERAGE.getText());
        String customTypeTemplate = "case when customtype='year' then '%1$s' when customtype='half' then '%2$s' when customtype='season' then '%3$s' when customtype='month' then '%4$s' else ' ' end";
        String customTypeName = String.format(customTypeTemplate, DateRangeEnum.YEAR.getText(), DateRangeEnum.HALF_YEAR.getText(), DateRangeEnum.SEASON.getText(), DateRangeEnum.MONTH.getText());
        String customTypeNum = String.format(customTypeTemplate, DateRangeEnum.YEAR.getIndex(), DateRangeEnum.HALF_YEAR.getIndex(), DateRangeEnum.SEASON.getIndex(), DateRangeEnum.MONTH.getIndex());
        return ds.addFields(new String[]{"case when amount is null or amount=0 then 0.0 else rateamount/amount end", typeName, customTypeName, customTypeNum}, new String[]{"frate", "financetypename", "customtypename", "customtypenum"});
    }

    private DataSet dealEmptyRow(DataSet rows) {
        HashSet<String> allRow = new HashSet<String>(16);
        HashSet<String> dataRow = new HashSet<String>(16);
        ArrayList<Object[]> newRow = new ArrayList<Object[]>(10);
        HashSet<Integer> financeType = new HashSet<Integer>(8);
        for (Row row : rows) {
            dataRow.add(row.getString("customtype") + "-" + row.getInteger(FINANCE_TYPE) + "-" + row.getInteger("datetype"));
            if (!financeType.add(row.getInteger(FINANCE_TYPE))) continue;
            for (DateRangeEnum dateRangeEnum : DateRangeEnum.getCommonEnums()) {
                if (dateRangeEnum == DateRangeEnum.HALF_YEAR) continue;
                Integer start = dateRangeEnum.getStart();
                Integer end = dateRangeEnum.getEnd();
                for (int j = start.intValue(); j <= end; ++j) {
                    String key = dateRangeEnum.getValue() + "-" + row.getInteger(FINANCE_TYPE) + "-" + j;
                    allRow.add(key);
                }
            }
        }
        allRow.removeAll(dataRow);
        for (String tempRowKey : allRow) {
            String[] temps = tempRowKey.split("-");
            newRow.add(new Object[]{temps[0], temps[1], temps[2], 0.0, 0.0});
        }
        return DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rows.getRowMeta().getFieldNames(), rows.getRowMeta().getDataTypes(), newRow);
    }

    private DataSet calculateAverage(DataSet ds) {
        ds = ds.groupBy(new String[]{"customtype", "datetype"}).sum("amount").sum("rateamount").finish();
        return ds.addField(FinanceTypeEnum.AVERAGE.getNumber(), FINANCE_TYPE);
    }

    private DataSet parseDateType(DataSet ds, Date queryDate) {
        ds = ds.addField("'0'", "begindate");
        final String[] array = FinanceCostDateHelper.parseNewDateType((Date)FinanceCostDateHelper.getNewDate((Date)queryDate));
        final RowMeta rowMetas = ds.getRowMeta();
        ds = ds.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(64);
                for (String fieldName : rowMetas.getFieldNames()) {
                    Integer dateType = row.getInteger("datetype");
                    if ("begindate".equals(fieldName) && dateType != null) {
                        rowInfo.add(array[dateType]);
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return ds;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.getCustomParams().put("displayType", "financeingtype");
        rsp.getCustomParams().put("customtype", ids.get(0));
        rsp.setFormId("tda_fincosttyperpt");
        this.fireLinkageShowForm(view, rsp);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        param.getCustomParams().put("displayType", "financeingtype");
        param.getCustomParams().put("customtype", ((JSONArray)clickArgs.get((Object)"data")).get(5));
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return "customtype";
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_fincosttyperpt");
    }
}

