/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.DataSetHelper;
import kd.tmc.tda.common.enums.AcctDisplayByBankTypeEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class FinanceDebtQuantityQingAnlsPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String BANK_NAME = "fbankname";
    private static final String AMOUNT = "drawamount";
    private static final int TOP_NUMBER = 10;
    private static final String DEBT_QUANTITY_REGION_TYPE = "debtquantityregiontype";
    private static final String PARAM = "param";
    private static final String REGION_TYPE = "regiontype";
    private static final String RATIO = "ratio";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{REGION_TYPE, ResManager.loadKDString((String)"\u533a\u57df\u7c7b\u578b", (String)"FinanceDebtQuantityQingAnlsPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{BANK_NAME, ResManager.loadKDString((String)"\u94f6\u884c\u540d\u79f0", (String)"FinanceDebtQuantityQingAnlsPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{AMOUNT, ResManager.loadKDString((String)"\u91d1\u989d", (String)"FinanceDebtQuantityQingAnlsPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{RATIO, ResManager.loadKDString((String)"\u5360\u6bd4", (String)"FinanceDebtQuantityQingAnlsPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"qingsort", ResManager.loadKDString((String)"\u6392\u5e8f", (String)"AbstractDraftBillAccepterBankPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"GuaranteeContractGuaranteedPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> orgIds = this.getOrgIds(paramMap);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        DataSet ds = FinanceDataHelper.getFinanceDataSet((String)((Object)((Object)this)).getClass().getName(), orgIds, (Date)queryDate, (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        ds = ds.select("creditortype,bankcate,repayamount drawamount,region,isequity").filter("isequity=false and creditortype='bank' and bankcate>0");
        QFilter filter = new QFilter("id", "in", this.getFinOrgIds(ds));
        DataSet finOrgDs = QueryServiceHelper.queryDataSet((String)this.createAlgoKey("bankcgsetting"), (String)"bd_bankcgsetting", (String)"id,name fbankname", (QFilter[])filter.toArray(), null);
        ds = ds.leftJoin(finOrgDs).on("bankcate", "id").select(ds.getRowMeta().getFieldNames(), new String[]{BANK_NAME}).finish();
        ds = ds.groupBy(new String[]{BANK_NAME, "region"}).sum(AMOUNT).finish();
        DataSet[] dataSets = DataSetHelper.copy((DataSet)ds, (int)3);
        ds = dataSets[0];
        DataSet allDs = this.addRegionType(dataSets[1], AcctDisplayByBankTypeEnum.ALL);
        DataSet domesticDs = this.addRegionType(dataSets[2], AcctDisplayByBankTypeEnum.DOMESTIC);
        DataSet overseasDs = this.addRegionType(ds, AcctDisplayByBankTypeEnum.OVERSEAS);
        allDs = this.addRatio(allDs);
        domesticDs = this.addRatio(domesticDs);
        overseasDs = this.addRatio(overseasDs);
        return allDs.union(domesticDs).union(overseasDs);
    }

    private DataSet addRatio(DataSet ds) {
        BigDecimal totalAmount = this.getTotalAmount(ds.copy());
        if (totalAmount == null || totalAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return ds.addField("0.0", RATIO);
        }
        return ds.addField("drawamount/" + totalAmount.toPlainString(), RATIO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getTotalAmount(DataSet ds) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        try {
            ds = ds.groupBy(new String[]{PARAM}).sum(AMOUNT).finish();
            Iterator iterator = ds.iterator();
            if (iterator.hasNext()) {
                totalAmount = ((Row)iterator.next()).getBigDecimal(AMOUNT);
            }
        }
        finally {
            ds.close();
        }
        return totalAmount;
    }

    private DataSet addRegionType(DataSet ds, AcctDisplayByBankTypeEnum regionType) {
        DataSet dataSet = this.regionFilter(ds, regionType);
        return dataSet.addFields(new String[]{"'" + regionType.getName() + "'", "'" + regionType.getValue() + "'"}, new String[]{REGION_TYPE, PARAM});
    }

    private DataSet regionFilter(DataSet ds, AcctDisplayByBankTypeEnum regionType) {
        if (AcctDisplayByBankTypeEnum.DOMESTIC == regionType) {
            ds = ds.filter("region=1");
        } else if (AcctDisplayByBankTypeEnum.OVERSEAS == regionType) {
            ds = ds.filter("region=0");
        }
        return ds.filter("fbankname IS NOT NULL").groupBy(new String[]{BANK_NAME}).sum(AMOUNT).finish().orderBy(new String[]{"drawamount DESC"}).top(10);
    }

    private Set<Long> getFinOrgIds(DataSet ds) {
        return DecisionCommonHelper.getFieldValues((DataSet)ds.copy(), (String)"bankcate", Long.class);
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_findebtquanrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(4);
        customParams.put(DEBT_QUANTITY_REGION_TYPE, ids);
        parameter.setCustomParams(customParams);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(AMOUNT);
    }

    @Override
    protected Object translateCellDisplay(String field, Object value, Row rs) {
        if (RATIO.equals(field) && value instanceof BigDecimal) {
            return ((BigDecimal)value).setScale(4, 4);
        }
        return super.translateCellDisplay(field, value, rs);
    }
}

