/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.finance.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.helper.FinanceDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.common.helper.TdaParameterHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class InterestDebtByFinProductDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static String FINANCE_TYPE = "financetype";
    private static String REPAY_AMOUNT = "repayamount";
    private String UN_EQUITY = "isequity = false";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> fields = new LinkedList<Object[]>();
        fields.add(new Object[]{FINANCE_TYPE, ResManager.loadKDString((String)"\u878d\u8d44\u7c7b\u578b", (String)"InterestDebtByFinProductDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        fields.add(new Object[]{REPAY_AMOUNT, ResManager.loadKDString((String)"\u8fd8\u6b3e\u4f59\u989d", (String)"InterestDebtByFinProductDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        fields.add(new Object[]{"financetypename", ResManager.loadKDString((String)"\u878d\u8d44\u7c7b\u578b\u540d\u79f0", (String)"InterestDebtByFinProductDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return fields;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        List<Long> allorgids = this.getOrgIds(paramMap);
        paramMap.put("allorgids", allorgids);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        DataSet financeDataSet = FinanceDataHelper.getFinanceDataSet((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)orgId);
        financeDataSet = financeDataSet.filter(this.UN_EQUITY);
        DataSet[] splitDataSet = financeDataSet.splitByFilter(new String[]{"isoutgroup = 0 and creditortype = 'fincom'"}, true);
        DataSet finCom = splitDataSet[0].updateField(FINANCE_TYPE, "4");
        financeDataSet = finCom.union(splitDataSet[1]);
        financeDataSet = financeDataSet.select(new String[]{"org", FINANCE_TYPE, REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
        DataSet result = financeDataSet.groupBy(new String[]{FINANCE_TYPE}).sum(REPAY_AMOUNT).sum(MergeOffsetHandler.ROW_OFFSETFILENAME).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish();
        result = result.updateField(REPAY_AMOUNT, String.join((CharSequence)"+", REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME));
        boolean containCompany = TdaParameterHelper.getFinCompanyFlag();
        List<String> financeTypeList = containCompany ? Arrays.asList("0", "1", "2", "3", "4") : Arrays.asList("0", "1", "3", "4");
        result = DecisionAnlsHelper.creatAbsentRow(result, FINANCE_TYPE, financeTypeList, 0, () -> new Object[]{"", "0", "0", "0"});
        DataSet[] splitOther = result.splitByFilter(new String[]{"financetype = 3", "financetype = 4"}, true);
        result = splitOther[2].union(new DataSet[]{splitOther[0].updateField(FINANCE_TYPE, "4"), splitOther[1].updateField(FINANCE_TYPE, "3")});
        String typeName = String.format("case when financetype=0 then '%1$s' when financetype=1 then '%2$s' when financetype=2 then '%3$s' when financetype=4 then '%4$s'when financetype=3 then '%5$s' else ' ' end", ResManager.loadKDString((String)"\u94f6\u884c\u501f\u6b3e", (String)"InterestDebtByFinProductDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53d1\u884c\u503a\u5238", (String)"InterestDebtByFinProductDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4f01\u4e1a\u501f\u6b3e", (String)"InterestDebtByFinProductDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InterestDebtByFinProductDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8d22\u53f8\u501f\u6b3e", (String)"InterestDebtByFinProductDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]));
        return result.addField(typeName, "financetypename");
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_interdebtbyfinprorpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return FINANCE_TYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("tda_interdebtbyfinprorpt");
        this.fireLinkageShowForm(view, showParameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(REPAY_AMOUNT);
    }
}

