/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeExceedStockDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    private static final String GUARANTEED_FINANCE_TYPE_ALL = "all";
    private static final String ROWID = "rowid";

    @Override
    protected DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        List orgIds = (List)paramMap.get("allorgids");
        DataSet contractDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, orgIds);
        contractDs = contractDs.groupBy(new String[]{"org", "isfinance", "isexceedstock", "guaranteeway"}).sum("dutyamount").finish();
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        return contractDs.addField(ismortgageType, "ismortgagetype");
    }

    @Override
    protected DataSet filterResultDataSet(DataSet ds, ReportQueryParam param) {
        String mortgagetype;
        Map paramMap = this.transQueryParam(param);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        DataSet orgDs = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        String type = GuaranteeReportHelper.getFinanceType(paramMap);
        if (!GUARANTEED_FINANCE_TYPE_ALL.equals(type)) {
            ds = ds.filter("isfinance = '" + type + "'");
        }
        if (!GUARANTEED_FINANCE_TYPE_ALL.equals(mortgagetype = GuaranteeReportHelper.getMortgagetype(paramMap))) {
            ds = ds.filter("ismortgagetype = '" + mortgagetype + "'");
        }
        ds = ds.groupBy(new String[]{"org", "isexceedstock"}).sum("dutyamount").finish();
        String props = "org,isexceedstock,dutyamount,case when isexceedstock=true then dutyamount else 0 end as exceedstock,case when isexceedstock=false then dutyamount else 0 end as stockamount";
        ds = ds.select(props);
        ds = ds.groupBy(new String[]{"org"}).sum("dutyamount", "totalamount").sum("exceedstock").sum("stockamount").finish();
        List<String> sumFields = this.getSumField();
        DataSet allDs = orgDs.leftJoin(ds).on(ROWID, "org").select(DecisionAnlsHelper.getSelectField(sumFields)).finish();
        DynamicObjectCollection parentOrgs = (DynamicObjectCollection)param.getFilter().getFilterItem("filter_company").getValue();
        DataSet sumDataSet = this.getSumDataSetByLevel(allDs, sumFields, "mixorgname,orgid,sortcode");
        List subOrgIds = (List)paramMap.get("suborgids");
        sumDataSet = EmptyUtil.isEmpty((Collection)subOrgIds) ? sumDataSet.filter("rowid=" + ((DynamicObject)parentOrgs.get(0)).getString("id")).filter("totalamount > 0") : sumDataSet.filter("rowid in subOrgIds", Collections.singletonMap("subOrgIds", subOrgIds)).filter("totalamount > 0");
        sumDataSet = sumDataSet.addField("'groupcol'", "groupcol").orderBy(new String[]{"sortcode"});
        DataSet totalSet = this.addSubTotalDataSet(sumDataSet, Collections.singletonList("groupcol"), sumFields, "mixorgname");
        return sumDataSet.union(totalSet).addField("mixorgname", "org_name");
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(4);
        fields.addAll(this.getSumField());
        return fields;
    }

    private List<String> getSumField() {
        ArrayList<String> fields = new ArrayList<String>(4);
        fields.add("totalamount");
        fields.add("stockamount");
        fields.add("exceedstock");
        return fields;
    }
}

