/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.helper;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.GuaDebtBillTypeEnum;
import kd.tmc.fbp.common.helper.AmountTransHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.enums.GuaranteeTermEnum;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.common.helper.BasicParamHelper;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.SysParamHelper;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;

public class GuaranteeReportHelper {
    private static final String GM_GUARANTEEAPPLY = "gm_guaranteeapply";
    private static final String GUARANTEED_FINANCE_TYPE = "exceedstocktype";
    private static final String GUARANTEED_FINANCE_TYPE_ALL = "all";
    private static final String[] amountArray = new String[]{"ensureamount", "ensuamtamount", "mortgageamount", "pledgeamount"};

    public static DataSet getGuaranteeContractDataSet(Map<String, Object> paramMap, List<Long> orgIds) {
        return GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, orgIds, false);
    }

    public static DataSet getGuaranteeContractDataSet(Map<String, Object> paramMap, List<Long> orgIds, boolean isQueryDetail) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        boolean isQueryCache = SysParamHelper.getQueryCacheFlag();
        String className = "getGuaranteeContractDataSet";
        DataSet ds = CacheManager.getCacheOrElseGet((Long)orgViewId, (String)GuaranteeReportHelper.getAlgoKey(className), (String)GuaranteeReportHelper.getCacheKey(paramMap, className), () -> GuaranteeReportHelper.queryAllGuaranteeContracts(paramMap, orgIds, isQueryCache));
        if (EmptyUtil.isEmpty(orgIds)) {
            return DecisionAnlsHelper.createEmptyDataSet(ds.getRowMeta().getFieldNames(), ds.getRowMeta().getDataTypes());
        }
        if (isQueryCache) {
            ds = ds.filter("org in orgIds", Collections.singletonMap("orgIds", orgIds));
        }
        if (!isQueryDetail) {
            ds = GuaranteeReportHelper.handleGuaranteeway(ds);
        }
        ds = ds.filter("guaranteeway not like '%" + GuaranteeWayEntityEnum.ENSUAMT.getValue() + "%'");
        return ds;
    }

    private static DataSet queryAllGuaranteeContracts(Map<String, Object> paramMap, List<Long> orgIds, boolean isQueryCache) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        if (isQueryCache) {
            orgIds = TmcOrgDataHelper.getOrgIds((Long)orgViewId);
        }
        QFilter qFilter = GuaranteeReportHelper.getFilter(paramMap, orgIds);
        String selectProps = "id, billno, guaranteeno, guarantee.name guaranteename, guaranteeway, isexceedstock,case when amount is null or amount<0 then 0.0 else amount end as totalamount,entry_guaranteeorg.a_guaranteeorg org, entry_guaranteeorg.a_guaranteeorgtext guaranteeorgtext,entry_guaranteeorg.a_guaranteetype guaranteetype,entry_guaranteedorg.b_guaranteedorg guaranteedorg, entry_guaranteedorg.b_guaranteedorgtext guaranteedorgtext, entry_guaranteedorg.b_reguaranteetype reguaranteetype,entry_guaranteeorg.a_gamount amount,countorguaway, creditortype, creditortext, currency, currency.name currencyname,guaranteeamount,begindate, enddate, bizdate, bizstatus, closetime";
        DataSet allDs = QueryServiceHelper.queryDataSet((String)"guaranteedTypeQing", (String)"gm_guaranteecontract", (String)selectProps, (QFilter[])qFilter.toArray(), null);
        allDs = GuaranteeReportHelper.containConsistentGM(allDs);
        Set ids = DecisionCommonHelper.getFieldValues((DataSet)allDs, (String)"id", Long.class);
        allDs = QueryServiceHelper.queryDataSet((String)"guaranteedTypeQing2", (String)"gm_guaranteecontract", (String)selectProps, (QFilter[])new QFilter("id", "in", (Object)ids).toArray(), null);
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        allDs = GuaranteeReportHelper.changeHistoryDs(allDs, queryDate, true);
        String dateStr = "to_date('" + DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd") + "', 'yy-MM-dd')";
        allDs = allDs.addField("case when enddate<" + dateStr + " then '1' else '0' end", "isexpire");
        allDs = GuaranteeReportHelper.updateDutyAmount(paramMap, queryDate, allDs).where("isexpire='0' or dutyamount>0");
        allDs = allDs.updateField("amount", "amount*dutyamount_sum_rate");
        allDs = GuaranteeReportHelper.addTotalAmountRate(allDs);
        allDs = GuaranteeReportHelper.dutyAmountSplit(allDs);
        allDs = allDs.filter("guaranteetype='bos_org' or guaranteetype='tmc_org'");
        allDs = GuaranteeReportHelper.reverseTranDataSetRate(allDs, paramMap);
        allDs = allDs.addFields(new String[]{"case when reguaranteetype='bos_org' or reguaranteetype='tmc_org' then 'inner' else 'noinner' end", "amount", "guaranteeamount"}, new String[]{"isinner", "originalamount", "originalguaranteeamount"});
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        HashSet<String> transFields = new HashSet<String>(4);
        transFields.add("amount");
        transFields.add("guaranteeamount");
        return AmountTransHelper.tranDataSetRate((DataSet)allDs, (Long)orgViewId, (Long)baseCurrency, (String)"currency", transFields, (Date)queryDate);
    }

    private static DataSet containConsistentGM(DataSet allDs) {
        boolean containConsistentGM = BasicParamHelper.getAppBooleamParameter((String)"tda_security_param", (String)"containconsistentgm");
        if (!containConsistentGM) {
            allDs = allDs.filter("guaranteeorgtext != guaranteedorgtext");
        }
        return allDs;
    }

    private static DataSet addTotalAmountRate(DataSet allDs) {
        DataSet amountSumDs = allDs.groupBy(new String[]{"id"}).sum("amount", "amount_sum").finish();
        allDs = allDs.leftJoin(amountSumDs).on("id", "id").select(allDs.getRowMeta().getFieldNames(), new String[]{"case when amount_sum=0 then 0.0 else amount/amount_sum end as total_amount_rate"}).finish();
        return allDs.updateField("amount", "totalamount*total_amount_rate");
    }

    private static DataSet dutyAmountSplit(DataSet allDs) {
        DataSet amountSumDs = allDs.groupBy(new String[]{"id", "guaranteedorg", "isfinance"}).sum("amount", "amount_sum").finish();
        allDs = allDs.leftJoin(amountSumDs).on("id", "id").on("guaranteedorg", "guaranteedorg").on("isfinance", "isfinance").select(allDs.getRowMeta().getFieldNames(), new String[]{"case when amount_sum=0 then 0.0 else amount/amount_sum end as org_split_rate"}).finish();
        return allDs.updateField("dutyamount", "dutyamount*org_split_rate");
    }

    private static DataSet reverseTranDataSetRate(DataSet ds, Map<String, Object> paramMap) {
        ds = ds.addField("dutyamount", "originaldutyamount");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        Set<String> transFields = Collections.singleton("originaldutyamount");
        return AmountTransHelper.reverseTranDataSetRate((DataSet)ds, (Long)orgViewId, (Long)baseCurrency, (String)"currency", transFields, (Date)queryDate).removeFields(new String[]{"rate"});
    }

    private static QFilter getFilter(Map<String, Object> paramMap, List<Long> orgIdSet) {
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        QFilter filter = GuaranteeReportHelper.getCommFilter(orgIdSet, queryDate);
        filter.and("begindate", "<", (Object)GuaranteeReportHelper.queryNextDay(queryDate));
        return filter;
    }

    private static QFilter getCommFilter(List<Long> orgIdSet, Date queryDate) {
        QFilter filter1 = new QFilter("bizstatus", "=", (Object)"closed").and("closetime", ">=", (Object)queryDate);
        QFilter filter2 = new QFilter("bizstatus", "!=", (Object)"closed");
        QFilter filter = filter1.or(filter2);
        QFilter baseFilter = GuaranteeReportHelper.getBaseFilter(orgIdSet);
        return baseFilter.and(filter);
    }

    private static QFilter getBaseFilter(List<Long> orgIdSet) {
        QFilter filter = new QFilter("entry_guaranteeorg.a_guaranteeorg", "in", orgIdSet);
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        return filter;
    }

    private static DataSet changeHistoryDs(DataSet contractDs, Date queryDate, boolean isQueryDetail) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("applytype", "=", (Object)"change");
        filter.and("guacontract.id", "in", GuaranteeReportHelper.getGuacontractIds(contractDs));
        filter.and("auditdate", "<", (Object)GuaranteeReportHelper.queryNextDay(queryDate));
        String applyProps = "id applyid,auditdate,guacontract.id as guacontractid, guarantee.name guaranteename,guaranteeway, isexceedstock, countorguaway, amount totalamount, begindate, enddate";
        DataSet applyDs = QueryServiceHelper.queryDataSet((String)"guaranteeApplyQuery", (String)GM_GUARANTEEAPPLY, (String)applyProps, (QFilter[])filter.toArray(), (String)"guacontract.id, auditdate DESC");
        Set changeContractIds = DecisionCommonHelper.getFieldValues((DataSet)applyDs.copy(), (String)"guacontractid", Long.class);
        if (EmptyUtil.isEmpty((Collection)changeContractIds)) {
            if (!isQueryDetail) {
                contractDs = GuaranteeReportHelper.handleGuaranteeway(contractDs);
            }
            return contractDs.addField("'0'", "ischange");
        }
        applyDs = applyDs.filter(GuaranteeReportHelper.buildFilter());
        changeContractIds = DecisionCommonHelper.getFieldValues((DataSet)applyDs.copy(), (String)"guacontractid", Long.class);
        Set applyIds = DecisionCommonHelper.getFieldValues((DataSet)applyDs.copy(), (String)"applyid", Long.class);
        HashSet<String> changeFields = new HashSet<String>(Arrays.asList("guaranteeway", "isexceedstock", "countorguaway", "totalamount", "begindate", "enddate"));
        String[] allFieldNames = contractDs.getRowMeta().getFieldNames();
        ArrayList<String> fieldNames = new ArrayList<String>(32);
        for (String field : allFieldNames) {
            if (changeFields.contains(field)) continue;
            fieldNames.add(field);
        }
        DataSet nochangeDs = contractDs.filter("id not in changeContractIds", Collections.singletonMap("changeContractIds", changeContractIds)).addField("'0'", "ischange");
        if (!isQueryDetail) {
            nochangeDs = GuaranteeReportHelper.handleGuaranteeway(nochangeDs.copy());
        }
        changeFields.add("applyid");
        DataSet changeDs = applyDs.leftJoin(contractDs).on("guacontractid", "id").select(changeFields.toArray(new String[0]), fieldNames.toArray(new String[0])).finish().addField("'1'", "ischange");
        if (!isQueryDetail) {
            changeDs = GuaranteeReportHelper.handleGuaranteeway(changeDs.copy(), GM_GUARANTEEAPPLY, applyIds, "applyid");
        }
        return nochangeDs.union(changeDs.select(nochangeDs.getRowMeta().getFieldNames()));
    }

    private static FilterFunction buildFilter() {
        final HashSet contractIds = new HashSet(64);
        return new FilterFunction(){

            public boolean test(Row row) {
                Long contractId = row.getLong("guacontractid");
                if (EmptyUtil.isEmpty((Long)contractId)) {
                    return false;
                }
                if (contractIds.contains(contractId)) {
                    return false;
                }
                contractIds.add(contractId);
                return true;
            }
        };
    }

    private static DataSet handleGuaranteeway(DataSet contractDs) {
        Set<Long> contractIds = GuaranteeReportHelper.getGuacontractIds(contractDs);
        return GuaranteeReportHelper.handleGuaranteeway(contractDs, "gm_guaranteecontract", contractIds, "id");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSet handleGuaranteeway(DataSet contractDs, String entityName, Set<Long> ids, String pkName) {
        if (EmptyUtil.isEmpty((String)entityName)) {
            entityName = "gm_guaranteecontract";
        }
        QFilter filter = new QFilter("id", "in", ids);
        QFilter[] qFilters = filter.toArray();
        String algoKey = "handleGuaranteeway";
        String eProps = "id, ensureentity.e_amount ensureamount";
        DataSet ensureDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)eProps, (QFilter[])qFilters, null);
        ensureDs = ensureDs.groupBy(new String[]{"id"}).sum("ensureamount").finish();
        String aProps = "id, ensureamtentity.a_amount ensuamtamount";
        DataSet ensureamtDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)aProps, (QFilter[])qFilters, null);
        ensureamtDs = ensureamtDs.groupBy(new String[]{"id"}).sum("ensuamtamount").finish();
        String mProps = "id, morentity.m_amount mortgageamount";
        DataSet morDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)mProps, (QFilter[])qFilters, null);
        morDs = morDs.groupBy(new String[]{"id"}).sum("mortgageamount").finish();
        String pProps = "id, pletgageentity.p_amount pledgeamount";
        DataSet pletgageDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)pProps, (QFilter[])qFilters, null);
        pletgageDs = pletgageDs.groupBy(new String[]{"id"}).sum("pledgeamount").finish();
        contractDs = contractDs.leftJoin(ensureDs).on(pkName, "id").select(contractDs.getRowMeta().getFieldNames(), new String[]{"ensureamount"}).finish();
        contractDs = contractDs.leftJoin(ensureamtDs).on(pkName, "id").select(contractDs.getRowMeta().getFieldNames(), new String[]{"ensuamtamount"}).finish();
        contractDs = contractDs.leftJoin(morDs).on(pkName, "id").select(contractDs.getRowMeta().getFieldNames(), new String[]{"mortgageamount"}).finish();
        contractDs = contractDs.leftJoin(pletgageDs).on(pkName, "id").select(contractDs.getRowMeta().getFieldNames(), new String[]{"pledgeamount"}).finish();
        contractDs = contractDs.updateFields(amountArray, new String[]{"case when ensureamount is null or ensureamount<0 then 0.0 else ensureamount end", "case when ensuamtamount is null or ensuamtamount<0 then 0.0 else ensuamtamount end", "case when mortgageamount is null or mortgageamount<0 then 0.0 else mortgageamount end", "case when pledgeamount is null or pledgeamount<0 then 0.0 else pledgeamount end"});
        contractDs = contractDs.updateFields(amountArray, new String[]{"case when ensureamount=0 then 0.0 when ensureamount+ensuamtamount+mortgageamount+pledgeamount=0 then 0.0 else ensureamount/(ensureamount+ensuamtamount+mortgageamount+pledgeamount) end", "case when ensuamtamount=0 then 0.0 when ensureamount+ensuamtamount+mortgageamount+pledgeamount=0 then 0.0 else ensuamtamount/(ensureamount+ensuamtamount+mortgageamount+pledgeamount) end", "case when mortgageamount=0 then 0.0 when ensureamount+ensuamtamount+mortgageamount+pledgeamount=0 then 0.0 else mortgageamount/(ensureamount+ensuamtamount+mortgageamount+pledgeamount) end", "case when pledgeamount=0 then 0.0 when ensureamount+ensuamtamount+mortgageamount+pledgeamount=0 then 0.0 else pledgeamount/(ensureamount+ensuamtamount+mortgageamount+pledgeamount) end"});
        RowMeta rowMeta = contractDs.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        ArrayList<Object[]> rowDataList = new ArrayList<Object[]>(1024);
        Iterator iterator = contractDs.iterator();
        try {
            while (iterator.hasNext()) {
                List<String> guaranteeWays;
                Row row = (Row)iterator.next();
                String guaranteeWay = row.getString("guaranteeway");
                if (EmptyUtil.isEmpty((String)guaranteeWay) || (guaranteeWays = GuaranteeReportHelper.splitGuaranteeway(guaranteeWay)).isEmpty()) continue;
                for (String guaranteeWayName : guaranteeWays) {
                    ArrayList<Object> rowData = new ArrayList<Object>(fieldNames.length);
                    for (String fieldName : fieldNames) {
                        if ("guaranteeway".equals(fieldName)) {
                            rowData.add(guaranteeWayName);
                            continue;
                        }
                        if ("amount".equals(fieldName) || "dutyamount".equals(fieldName) || "originalamount".equals(fieldName) || "originaldutyamount".equals(fieldName)) {
                            BigDecimal amount = row.getBigDecimal(fieldName);
                            if (amount == null) {
                                amount = BigDecimal.ZERO;
                            }
                            BigDecimal ratio = guaranteeWays.size() == 1 ? BigDecimal.ONE : row.getBigDecimal(guaranteeWayName + "amount");
                            rowData.add(amount.multiply(ratio));
                            continue;
                        }
                        rowData.add(row.get(fieldName));
                    }
                    rowDataList.add(rowData.toArray(new Object[0]));
                }
            }
        }
        finally {
            if (contractDs != null) {
                contractDs.close();
            }
        }
        return DecisionAnlsHelper.createRow(algoKey, fieldNames, rowMeta.getDataTypes(), rowDataList);
    }

    private static DataSet updateDutyAmount(Map<String, Object> paramMap, Date queryDate, DataSet contractDs) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        filter.and("gsrcbilltype", "in", GuaranteeReportHelper.getGuaDebtBillTypeEnumValues());
        filter.and("gdebtstartdate", "<", (Object)GuaranteeReportHelper.queryNextDay(queryDate));
        filter.and("gcontract.id", "in", GuaranteeReportHelper.getGuacontractIds(contractDs));
        String gUseProps = "gcontract.id as gcontractid,gsrcbilltype,gsrcbillid, gdebtcurrency,gdebtorg,case when gratio is null or gratio<0 then 0.0 else gratio end as gratio,case when gdebtamount is null then 0.0 else gdebtamount end as gdebtamount,case when gdebtbalance is null then 0.0 else gdebtbalance end as gdebtbalance";
        gUseProps = gUseProps + ",case when " + GuaranteeReportHelper.getFinanceFilter() + " then 'finance' else 'nofinance' end as isfinance";
        DataSet guaranteeUseDs = QueryServiceHelper.queryDataSet((String)"queryguaranteeUseDs", (String)"gm_guaranteeuse", (String)gUseProps, (QFilter[])filter.toArray(), null);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        HashSet<String> transFields = new HashSet<String>(4);
        transFields.add("gdebtamount");
        transFields.add("gdebtbalance");
        guaranteeUseDs = AmountTransHelper.tranDataSetRate((DataSet)guaranteeUseDs, (Long)orgViewId, (Long)baseCurrency, (String)"gdebtcurrency", transFields, (Date)queryDate);
        DataSet[] dataSets = guaranteeUseDs.splitByFilter(new String[]{GuaranteeReportHelper.getLoanFilter(), "gsrcbilltype='lc_lettercredit'", "gsrcbilltype='gm_debt_register'", "gsrcbilltype='fl_receiptbill'"}, true);
        DataSet loanDs = dataSets[0];
        DataSet letterDs = dataSets[1];
        DataSet debtRegisterDs = dataSets[2];
        DataSet receiptBillDs = dataSets[3];
        DataSet otherDs = dataSets[4];
        otherDs = otherDs.groupBy(new String[]{"gcontractid", "gdebtorg", "isfinance"}).sum("gdebtbalance", "dutyamount").finish();
        loanDs = GuaranteeReportHelper.handleLoanDataSet(loanDs, paramMap, queryDate);
        letterDs = GuaranteeReportHelper.handleLetterDataSet(letterDs, paramMap, queryDate);
        debtRegisterDs = GuaranteeReportHelper.handleRegisterDataSet(debtRegisterDs, paramMap, queryDate);
        receiptBillDs = GuaranteeReportHelper.handleReceiptBillDsDataSet(receiptBillDs, paramMap, queryDate);
        String props = "gcontractid,gdebtorg,isfinance,dutyamount";
        DataSet unionDs = loanDs.select(props).union(new DataSet[]{letterDs.select(props), debtRegisterDs.select(props), receiptBillDs.select(props), otherDs}).groupBy(new String[]{"gcontractid", "gdebtorg", "isfinance"}).sum("dutyamount").finish();
        unionDs = GuaranteeReportHelper.addDutyAmountRate(unionDs);
        contractDs = contractDs.leftJoin(unionDs).on("id", "gcontractid").on("guaranteedorg", "gdebtorg").select(contractDs.getRowMeta().getFieldNames(), new String[]{"isfinance", "dutyamount", "dutyamount_sum_rate"}).finish();
        return contractDs.updateFields(new String[]{"dutyamount_sum_rate", "dutyamount", "isfinance"}, new String[]{"case when dutyamount_sum_rate is null then 1.0 else dutyamount_sum_rate end", "case when dutyamount is null or dutyamount<0 then 0.0 else dutyamount end", "case when isfinance is null then 'finance' else isfinance end"});
    }

    private static DataSet addDutyAmountRate(DataSet ds) {
        DataSet rateDs = ds.groupBy(new String[]{"gcontractid", "gdebtorg"}).sum("dutyamount", "dutyamount_sum").finish();
        return ds.leftJoin(rateDs).on("gcontractid", "gcontractid").on("gdebtorg", "gdebtorg").select(ds.getRowMeta().getFieldNames(), new String[]{"case when dutyamount is null or dutyamount=0 then 0.0 else dutyamount/dutyamount_sum end as dutyamount_sum_rate"}).finish();
    }

    private static DataSet handleLoanDataSet(DataSet loanDs, Map<String, Object> paramMap, Date queryDate) {
        Set<Long> billIdSet = GuaranteeReportHelper.getBillIds(loanDs);
        QFilter loanFilter = new QFilter("id", "in", billIdSet);
        loanFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet loanBillDs = QueryServiceHelper.queryDataSet((String)"handleLoanDataset", (String)"cfm_loanbill", (String)"id,currency,case when drawamount is null or drawamount<0 then 0.0 else drawamount end as drawamount", (QFilter[])loanFilter.toArray(), null);
        QFilter repayFilter = new QFilter("loans.e_loanbill", "in", billIdSet);
        repayFilter.and("bizdate", "<", (Object)GuaranteeReportHelper.queryNextDay(queryDate));
        repayFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repayBillDs = QueryServiceHelper.queryDataSet((String)"handleLoanDataset", (String)"cfm_repaymentbill", (String)"loans.e_loanbill loanbillid,case when loans.e_repayamount is null or loans.e_repayamount<0 then 0.0 else loans.e_repayamount end as ramount", (QFilter[])repayFilter.toArray(), null);
        repayBillDs = repayBillDs.groupBy(new String[]{"loanbillid"}).sum("ramount").finish();
        DataSet ds = loanBillDs.leftJoin(repayBillDs).on("id", "loanbillid").select(new String[]{"id", "currency", "drawamount", "ramount"}).finish();
        ds = ds.select("id loanid,currency,case when ramount is null then drawamount else drawamount-ramount end as loanamount");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Set<String> transFields = Collections.singleton("loanamount");
        ds = AmountTransHelper.tranDataSetRate((DataSet)ds, (Long)orgViewId, (Long)baseCurrency, (String)"currency", transFields, (Date)queryDate);
        loanDs = loanDs.leftJoin(ds).on("gsrcbillid", "loanid").select(loanDs.getRowMeta().getFieldNames(), new String[]{"loanamount"}).finish();
        return loanDs.addField("case when loanamount is null then gdebtamount else (loanamount * gratio * 0.01) end", "dutyamount");
    }

    private static DataSet handleReceiptBillDsDataSet(DataSet loanDs, Map<String, Object> paramMap, Date queryDate) {
        Set<Long> billIdSet = GuaranteeReportHelper.getBillIds(loanDs);
        QFilter loanFilter = new QFilter("id", "in", billIdSet);
        loanFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet loanBillDs = QueryServiceHelper.queryDataSet((String)"handleReceiptBillDsDataSet", (String)"fl_receiptbill", (String)"id,currency,case when drawamount is null or drawamount<0 then 0.0 else drawamount end as drawamount", (QFilter[])loanFilter.toArray(), null);
        QFilter repayFilter = new QFilter("loans.e_loanbill", "in", billIdSet);
        repayFilter.and("bizdate", "<", (Object)GuaranteeReportHelper.queryNextDay(queryDate));
        repayFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet repayBillDs = QueryServiceHelper.queryDataSet((String)"handleReceiptBillDsDataSet", (String)"fl_rentpaybill", (String)"loans.e_loanbill loanbillid,case when loans.e_repayamount is null or loans.e_repayamount<0 then 0.0 else loans.e_repayamount end as ramount", (QFilter[])repayFilter.toArray(), null);
        repayBillDs = repayBillDs.groupBy(new String[]{"loanbillid"}).sum("ramount").finish();
        DataSet ds = loanBillDs.leftJoin(repayBillDs).on("id", "loanbillid").select(new String[]{"id", "currency", "drawamount", "ramount"}).finish();
        ds = ds.select("id loanid,currency,case when ramount is null then drawamount else drawamount-ramount end as loanamount");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Set<String> transFields = Collections.singleton("loanamount");
        ds = AmountTransHelper.tranDataSetRate((DataSet)ds, (Long)orgViewId, (Long)baseCurrency, (String)"currency", transFields, (Date)queryDate);
        loanDs = loanDs.leftJoin(ds).on("gsrcbillid", "loanid").select(loanDs.getRowMeta().getFieldNames(), new String[]{"loanamount"}).finish();
        return loanDs.addField("case when loanamount is null then gdebtamount else (loanamount * gratio * 0.01) end", "dutyamount");
    }

    private static DataSet handleLetterDataSet(DataSet letterDs, Map<String, Object> paramMap, Date queryDate) {
        Set<Long> billIdSet = GuaranteeReportHelper.getBillIds(letterDs);
        QFilter loanFilter = new QFilter("id", "in", billIdSet);
        loanFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet letterBillDs = QueryServiceHelper.queryDataSet((String)"handleLetterDataSet", (String)"lc_lettercredit", (String)"id,currency,case when amount is null or amount<0 then 0.0 else amount end as amount", (QFilter[])loanFilter.toArray(), null);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        letterBillDs = AmountTransHelper.tranDataSetRate((DataSet)letterBillDs, (Long)orgViewId, (Long)baseCurrency, (String)"currency", Collections.singleton("amount"), (Date)queryDate);
        QFilter arriveFilter = new QFilter("lettercredit", "in", billIdSet);
        arriveFilter.and("arrivaldate", "<", (Object)GuaranteeReportHelper.queryNextDay(queryDate));
        arriveFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        arriveFilter.and("arrivalstatus", "=", (Object)"arrival_pay");
        DataSet arriveBillDs = QueryServiceHelper.queryDataSet((String)"handleLoanDataset", (String)"lc_arrival", (String)"lettercredit,arrivalcurrency,case when arrivalamount is null or arrivalamount<0 then 0.0 else arrivalamount end as arrivalamount", (QFilter[])arriveFilter.toArray(), null);
        arriveBillDs = AmountTransHelper.tranDataSetRate((DataSet)arriveBillDs, (Long)orgViewId, (Long)baseCurrency, (String)"arrivalcurrency", Collections.singleton("arrivalamount"), (Date)queryDate);
        arriveBillDs = arriveBillDs.groupBy(new String[]{"lettercredit"}).sum("arrivalamount").finish();
        DataSet ds = letterBillDs.leftJoin(arriveBillDs).on("id", "lettercredit").select(new String[]{"id", "amount", "arrivalamount"}).finish();
        ds = ds.select("id letterid,case when arrivalamount is null then amount else amount-arrivalamount end as letteramount");
        letterDs = letterDs.leftJoin(ds).on("gsrcbillid", "letterid").select(letterDs.getRowMeta().getFieldNames(), new String[]{"letteramount"}).finish();
        return letterDs.addField("case when letteramount is null then gdebtamount else (letteramount * gratio * 0.01) end", "dutyamount");
    }

    private static DataSet handleRegisterDataSet(DataSet debtRegisterDs, Map<String, Object> paramMap, Date queryDate) {
        Set<Long> billIdSet = GuaranteeReportHelper.getBillIds(debtRegisterDs);
        QFilter registerFilter = new QFilter("id", "in", billIdSet);
        registerFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        String sic = "id,currency,case when isfinance='1' then 'finance' else 'nofinance' end as isfinance,case when occupyamount is null or occupyamount<0 then 0.0 else occupyamount end as occupyamount";
        DataSet registerBillDs = QueryServiceHelper.queryDataSet((String)"handleRegisterDataSet", (String)"gm_debt_register", (String)sic, (QFilter[])registerFilter.toArray(), null);
        QFilter arriveFilter = new QFilter("rootid", "in", billIdSet.stream().map(String::valueOf).collect(Collectors.toSet()));
        arriveFilter.and("registerdate", "<", (Object)GuaranteeReportHelper.queryNextDay(queryDate));
        arriveFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        DataSet releaseBillDs = QueryServiceHelper.queryDataSet((String)"handleRegisterDataSet", (String)"gm_debt_register", (String)"rootid,currency,case when releaseamount is null or releaseamount<0 then 0.0 else releaseamount end as releaseamount", (QFilter[])arriveFilter.toArray(), null);
        releaseBillDs = releaseBillDs.groupBy(new String[]{"rootid"}).sum("releaseamount").finish();
        releaseBillDs = GuaranteeReportHelper.handle(releaseBillDs);
        DataSet ds = registerBillDs.leftJoin(releaseBillDs).on("id", "rootid").select(new String[]{"id", "isfinance", "currency", "occupyamount", "releaseamount"}).finish();
        ds = ds.select("id registerid,isfinance,currency,case when releaseamount is null then occupyamount else occupyamount-releaseamount end as dutyamount");
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Set<String> transFields = Collections.singleton("dutyamount");
        ds = AmountTransHelper.tranDataSetRate((DataSet)ds, (Long)orgViewId, (Long)baseCurrency, (String)"currency", transFields, (Date)queryDate);
        debtRegisterDs = debtRegisterDs.leftJoin(ds).on("gsrcbillid", "registerid").select(DecisionCommonHelper.getDifferenceArraysOrdered((String[])debtRegisterDs.getRowMeta().getFieldNames(), (String[])new String[]{"isfinance"}), new String[]{"isfinance", "dutyamount"}).finish();
        return debtRegisterDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataSet handle(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        try {
            for (Row row : ds) {
                values.add(GuaranteeReportHelper.row2Array(row, rowMeta));
            }
            DataSet dataSet = DecisionAnlsHelper.createRow(GuaranteeReportHelper.class.getName(), rowMeta.getFieldNames(), new DataType[]{DataType.LongType, DataType.BigDecimalType}, values);
            return dataSet;
        }
        finally {
            ds.close();
        }
    }

    private static Object[] row2Array(Row row, RowMeta rowMeta) {
        String[] fieldNames = rowMeta.getFieldNames();
        ArrayList<Object> list = new ArrayList<Object>(fieldNames.length);
        for (String fieldName : fieldNames) {
            if ("rootid".equals(fieldName)) {
                list.add(row.getLong(fieldName));
                continue;
            }
            list.add(row.get(fieldName));
        }
        return list.toArray(new Object[0]);
    }

    private static Set<String> getGuaDebtBillTypeEnumValues() {
        HashSet<String> values = new HashSet<String>(16);
        for (GuaDebtBillTypeEnum typeEnum : GuaDebtBillTypeEnum.values()) {
            values.add(typeEnum.getValue());
        }
        return values;
    }

    private static String getLoanFilter() {
        Set loanOrLetterValues = GuaDebtBillTypeEnum.getLoanValues();
        StringBuilder sb = new StringBuilder("gsrcbilltype in ('cfm_loanbill_bond',");
        for (String value : loanOrLetterValues) {
            sb.append("'").append(value).append("',");
        }
        sb.deleteCharAt(sb.length() - 1).append(")");
        return sb.toString();
    }

    private static String getFinanceFilter() {
        Set values = GuaDebtBillTypeEnum.getFinanceValues();
        StringBuilder sb = new StringBuilder("gsrcbilltype in (");
        for (String value : values) {
            sb.append("'").append(value).append("',");
        }
        sb.deleteCharAt(sb.length() - 1).append(")");
        return sb.toString();
    }

    private static Set<Long> getBillIds(DataSet ds) {
        return DecisionCommonHelper.getFieldValues((DataSet)ds.copy(), (String)"gsrcbillid", Long.class);
    }

    private static String getCacheKey(Map<String, Object> paramMap, String className) {
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        String prefix = GuaranteeReportHelper.class.getName() + "." + className + "-cacheKey";
        String key = prefix + "-" + orgViewId + "-" + DateUtils.formatString((Date)DecisionAnlsHelper.getQueryDate(paramMap), (String)"yyyy-MM-dd");
        return key;
    }

    private static String getAlgoKey(String className) {
        return GuaranteeReportHelper.class.getName() + "." + className + "-algokey";
    }

    public static String getFinanceType() {
        return ResManager.loadKDString((String)"\u878d\u8d44\u6027", (String)"GuaranteeReportHelper_0", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    public static String getNoFinanceType() {
        return ResManager.loadKDString((String)"\u975e\u878d\u8d44\u6027", (String)"GuaranteeReportHelper_1", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private static List<String> splitGuaranteeway(String guaranteeway) {
        if (EmptyUtil.isEmpty((String)guaranteeway)) {
            return Collections.emptyList();
        }
        String[] array = guaranteeway.split(",");
        ArrayList<String> list = new ArrayList<String>(4);
        for (int i = 0; i < array.length; ++i) {
            if (array[i].trim().isEmpty()) continue;
            list.add(array[i].trim());
        }
        return list;
    }

    public static String GuaranteewayValueMapText(String guaranteeway, Map<String, String> valueMapText) {
        List<String> guaranteeways = GuaranteeReportHelper.splitGuaranteeway(guaranteeway);
        if (EmptyUtil.isEmpty(guaranteeways)) {
            return "";
        }
        if (EmptyUtil.isEmpty(valueMapText)) {
            return guaranteeway;
        }
        StringBuilder sb = new StringBuilder();
        for (String value : guaranteeways) {
            String text = valueMapText.get(value);
            sb.append(text).append(",");
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    public static String getFinanceType(Map<String, Object> paramMap) {
        String type;
        JSONArray array = (JSONArray)paramMap.get(GUARANTEED_FINANCE_TYPE);
        if (array == null) {
            return GUARANTEED_FINANCE_TYPE_ALL;
        }
        HashSet<String> types = new HashSet<String>(4);
        for (int i = 0; i < array.size(); ++i) {
            String str = array.get(i).toString();
            if (str != null && str.contains(",")) {
                types.add(str.substring(0, str.indexOf(",")));
                continue;
            }
            types.add(str);
        }
        if (types.size() == 1 && ("finance".equals(type = (String)types.iterator().next()) || "nofinance".equals(type))) {
            return type;
        }
        return GUARANTEED_FINANCE_TYPE_ALL;
    }

    public static String getMortgagetype(Map<String, Object> paramMap) {
        String type;
        JSONArray array = (JSONArray)paramMap.get(GUARANTEED_FINANCE_TYPE);
        if (array == null) {
            return GUARANTEED_FINANCE_TYPE_ALL;
        }
        HashSet<String> types = new HashSet<String>(4);
        for (int i = 0; i < array.size(); ++i) {
            String str = array.get(i).toString();
            if (str == null || !str.contains(",")) continue;
            types.add(str.substring(str.indexOf(",") + 1));
        }
        if (types.size() == 1 && ("mortgagetype".equals(type = (String)types.iterator().next()) || "ensuretype".equals(type))) {
            return type;
        }
        return GUARANTEED_FINANCE_TYPE_ALL;
    }

    private static Set<Long> getGuacontractIds(DataSet ds) {
        return DecisionCommonHelper.getFieldValues((DataSet)ds.copy(), (String)"id", Long.class);
    }

    private static Date queryNextDay(Date queryDate) {
        return DateUtils.getNextDay((Date)queryDate, (int)1);
    }

    public static DataSet addTermByType(DataSet allDs, String termType, Date queryDate, final Boolean isChangeToChinese) {
        if ("residual".equals(termType)) {
            String dateStr = DateUtils.formatString((Date)queryDate, (String)"yyyy-MM-dd HH:mm:ss");
            allDs = allDs.updateField("begindate", "to_date('" + dateStr + "', 'yyyy-MM-dd HH:mm:ss')");
        }
        allDs = allDs.addFields(new String[]{"''", "0"}, new String[]{"term", "termsort"});
        final RowMeta rowMetas = allDs.getRowMeta();
        allDs = allDs.map(new MapFunction(){

            public RowMeta getResultRowMeta() {
                return rowMetas;
            }

            public Object[] map(Row row) {
                ArrayList<Object> rowInfo = new ArrayList<Object>(10);
                for (String fieldName : rowMetas.getFieldNames()) {
                    Date begindate = row.getDate("begindate");
                    Date enddate = row.getDate("enddate");
                    String term = DateUtils.getDiff_ymd((Date)begindate, (Date)enddate);
                    GuaranteeTermEnum guaranteeTermEnum = GuaranteeTermEnum.matchExp((String)term);
                    if ("term".equals(fieldName)) {
                        if (isChangeToChinese.booleanValue()) {
                            rowInfo.add(guaranteeTermEnum.getText().loadKDString());
                            continue;
                        }
                        rowInfo.add(guaranteeTermEnum.getNumber());
                        continue;
                    }
                    if ("termsort".equals(fieldName)) {
                        rowInfo.add(guaranteeTermEnum.getIndex());
                        continue;
                    }
                    rowInfo.add(row.get(fieldName));
                }
                return rowInfo.toArray();
            }
        });
        return allDs;
    }
}

