/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.qing.data;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.GuaranteeTermEnum;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public abstract class AbstractGuaranteeByTermQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String DUTYAMOUNT = "dutyamount";
    private static final String TERM = "term";
    private static final String TERMSORT = "termsort";
    private static final String IS_MORTGAGE_TYPE = "ismortgagetype";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{DUTYAMOUNT, ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u91d1\u989d", (String)"GuaranteeByOriginalTermQingDataPlugin_0", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{TERM, ResManager.loadKDString((String)"\u671f\u9650", (String)"GuaranteeByOriginalTermQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{TERMSORT, ResManager.loadKDString((String)"\u671f\u9650\u6392\u5e8f", (String)"GuaranteeByOriginalTermQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{IS_MORTGAGE_TYPE, ResManager.loadKDString((String)"\u662f\u5426\u542b\u62b5\u8d28\u62bc", (String)"GuaranteeByOriginalTermQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, this.getOrgIds(paramMap));
        Date queryDate = DecisionAnlsHelper.getQueryDate(paramMap);
        allDs = allDs.select(new String[]{DUTYAMOUNT, "enddate", "begindate", "guaranteeway"});
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        allDs = allDs.addField(ismortgageType, IS_MORTGAGE_TYPE);
        allDs = GuaranteeReportHelper.addTermByType(allDs, this.getTermType(), queryDate, true);
        allDs = allDs.groupBy(new String[]{TERM, TERMSORT, IS_MORTGAGE_TYPE}).sum(DUTYAMOUNT).finish();
        return this.addEmptyRange(allDs);
    }

    @Override
    protected Set<String> getAmountFields() {
        return Collections.singleton(DUTYAMOUNT);
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return IS_MORTGAGE_TYPE;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        parameter.getCustomParams().put("termType", this.getTermType());
        parameter.getCustomParams().put(IS_MORTGAGE_TYPE, ids);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    public void updateShowParam(ReportShowParameter param, JSONObject clickArgs, IPageCache pageCache, Map<String, Object> paramMap) {
        Map customParams = param.getCustomParams();
        String termType = this.getTermType();
        customParams.put("termType", termType);
        String areaRange = (String)paramMap.get("ensuretype");
        List<String> typeList = "ensuretype".equals(areaRange) ? Collections.singletonList("ensuretype") : Arrays.asList("ensuretype", "mortgagetype");
        customParams.put(IS_MORTGAGE_TYPE, typeList);
        String formId = "original".equals(termType) ? "tda_gmoriginaltermrpt" : "tda_gmresidualtermrpt";
        param.setFormId(formId);
    }

    protected abstract String getTermType();

    private DataSet addEmptyRange(DataSet ds) {
        List<String> isMortgageTypes = Arrays.asList("mortgagetype", "ensuretype");
        RowMeta rowMeta = ds.getRowMeta();
        for (GuaranteeTermEnum guaranteeTermEnum : GuaranteeTermEnum.values()) {
            for (String isMortgageType : isMortgageTypes) {
                String filterConditions = String.format("termsort=%1$s and ismortgagetype='%2$s'", guaranteeTermEnum.getIndex(), isMortgageType);
                if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{guaranteeTermEnum.getText().loadKDString(), guaranteeTermEnum.getIndex(), isMortgageType, 0.0}));
                ds = ds.union(bizDs);
            }
        }
        return ds;
    }
}

