/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeContractGuaranteedPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String GUARANTEED_FINANCE_TYPE = "exceedstocktype";
    private static final String PARAM = "param";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"amount", ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u603b\u989d", (String)"GuaranteeContractGuaranteedPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"inneramount", ResManager.loadKDString((String)"\u5bf9\u96c6\u56e2\u5185\u62c5\u4fdd\u8d23\u4efb\u603b\u989d", (String)"GuaranteeContractGuaranteedPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"noinneramount", ResManager.loadKDString((String)"\u5bf9\u96c6\u56e2\u5916\u62c5\u4fdd\u8d23\u4efb\u603b\u989d", (String)"GuaranteeContractGuaranteedPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"isfinance", ResManager.loadKDString((String)"\u662f\u5426\u878d\u8d44\u7c7b", (String)"GuaranteeContractGuaranteedPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"isinner", ResManager.loadKDString((String)"\u88ab\u62c5\u4fdd\u4eba\u7c7b\u578b", (String)"GuaranteeContractGuaranteedPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"GuaranteeContractGuaranteedPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"dutyamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u603b\u989d", (String)"GuaranteeContractGuaranteedPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"guaranteeway", ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f", (String)"GuaranteeContractGuaranteedPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"guaranteewayname", ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u540d\u79f0", (String)"GuaranteeContractGuaranteedPlugin_9", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"ismortgagetype", ResManager.loadKDString((String)"\u662f\u5426\u542b\u62b5\u8d28\u62bc", (String)"GuaranteeContractGuaranteedPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"incolumn", ResManager.loadKDString((String)"\u96c6\u56e2\u5185\u5217", (String)"GuaranteeContractGuaranteedPlugin_13", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"outcolumn", ResManager.loadKDString((String)"\u96c6\u56e2\u5916\u5217", (String)"GuaranteeContractGuaranteedPlugin_14", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"dutycolumn", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u5217", (String)"GuaranteeContractGuaranteedPlugin_15", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, this.getOrgIds(paramMap));
        allDs = allDs.groupBy(new String[]{"isinner", "isfinance", "guaranteeway"}).sum("amount").sum("dutyamount").finish();
        allDs = this.dealEmptyRow(allDs);
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        allDs = allDs.addField(ismortgageType, "ismortgagetype");
        String props = "isinner,isfinance,guaranteeway,ismortgagetype,amount,dutyamount,' ' guaranteewayname,case when isinner='inner' then dutyamount else 0 end as inneramount,case when isinner='noinner' then dutyamount else 0 end as noinneramount";
        allDs = allDs.select(props);
        allDs = allDs.addField("CONCAT(isfinance + ',' +  ismortgagetype)", PARAM);
        String isinnerStr = String.format("case when isinner='inner' then '%1$s' when isinner='noinner' then '%2$s' end", this.getInnerType(), this.getNoInnerType());
        String isfinanceStr = String.format("case when isfinance='finance' then '%1$s' when isfinance='nofinance' then '%2$s' end", GuaranteeReportHelper.getFinanceType(), GuaranteeReportHelper.getNoFinanceType());
        String guaranteeWayName = String.format("case when guaranteeway='%1$s' then '%2$s' when guaranteeway='%3$s' then '%4$s' when guaranteeway='%5$s' then '%6$s' when guaranteeway='%7$s' then '%8$s' else '%2$s' end", GuaranteeWayEntityEnum.ENSURE.getValue(), GuaranteeWayEntityEnum.ENSURE.getText(), GuaranteeWayEntityEnum.ENSUAMT.getValue(), GuaranteeWayEntityEnum.ENSUAMT.getText(), GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.MORTGAGE.getText(), GuaranteeWayEntityEnum.PLEDGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getText());
        allDs = allDs.updateFields(new String[]{"isinner", "isfinance", "guaranteewayname"}, new String[]{isinnerStr, isfinanceStr, guaranteeWayName});
        return allDs.addFields(new String[]{DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u96c6\u56e2\u5185", (String)"GuaranteeContractGuaranteedPlugin_16", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u96c6\u56e2\u5916", (String)"GuaranteeContractGuaranteedPlugin_17", (String)"tmc-tda-report", (Object[])new Object[0])), DecisionCommonHelper.stringFormat((String)ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb", (String)"GuaranteeContractGuaranteedPlugin_18", (String)"tmc-tda-report", (Object[])new Object[0]))}, new String[]{"incolumn", "outcolumn", "dutycolumn"}).filter("guaranteeway != '" + GuaranteeWayEntityEnum.ENSUAMT.getValue() + "'");
    }

    @Override
    protected List<String> getLinkReport() {
        ArrayList<String> list = new ArrayList<String>(2);
        list.add("tda_gmguaranteedrpt");
        list.add("tda_guaranteedwayrpt");
        return list;
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId(formId);
        if ("tda_guaranteedwayrpt".equals(formId) && EmptyUtil.isNoEmpty(ids)) {
            ArrayList<String> list = new ArrayList<String>(ids.size());
            for (String id : ids) {
                list.add(id.substring(0, id.indexOf(",")));
            }
            ids = list;
        }
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(4);
        customParams.put(GUARANTEED_FINANCE_TYPE, ids);
        parameter.setCustomParams(customParams);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(8);
        fields.add("amount");
        fields.add("inneramount");
        fields.add("noinneramount");
        fields.add("dutyamount");
        return fields;
    }

    private String getInnerType() {
        return ResManager.loadKDString((String)"\u5bf9\u96c6\u56e2\u5185", (String)"GuaranteeContractGuaranteedPlugin_10", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private String getNoInnerType() {
        return ResManager.loadKDString((String)"\u5bf9\u96c6\u56e2\u5916", (String)"GuaranteeContractGuaranteedPlugin_11", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private DataSet dealEmptyRow(DataSet ds) {
        List<String> isinner = Arrays.asList("inner", "noinner");
        List<String> isfinance = Arrays.asList("finance", "nofinance");
        List<String> guaranteeway = Arrays.asList(GuaranteeWayEntityEnum.ENSURE.getValue(), GuaranteeWayEntityEnum.ENSUAMT.getValue(), GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        RowMeta rowMeta = ds.getRowMeta();
        for (int i = 0; i < isinner.size(); ++i) {
            for (int j = 0; j < isfinance.size(); ++j) {
                for (int k = 0; k < guaranteeway.size(); ++k) {
                    String filterConditions = String.format("isinner='%1$s' and isfinance='%2$s' and guaranteeway='%3$s'", isinner.get(i), isfinance.get(j), guaranteeway.get(k));
                    if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                    DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{isinner.get(i), isfinance.get(j), guaranteeway.get(k), 0.0, 0.0}));
                    ds = ds.union(bizDs);
                }
            }
        }
        return ds;
    }
}

