/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.qing.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeExceedStockQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String PARAM = "param";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{"totalamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u5408\u540c\u603b\u989d", (String)"GuaranteeExceedStockQingDataPlugin_1", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"stockamount", ResManager.loadKDString((String)"\u6309\u80a1\u6bd4", (String)"GuaranteeExceedStockQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"exceedstock", ResManager.loadKDString((String)"\u8d85\u80a1\u6bd4", (String)"GuaranteeExceedStockQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"isfinance", ResManager.loadKDString((String)"\u662f\u5426\u878d\u8d44\u7c7b", (String)"GuaranteeExceedStockQingDataPlugin_4", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"isexceed", ResManager.loadKDString((String)"\u662f\u5426\u8d85\u80a1\u6bd4", (String)"GuaranteeExceedStockQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"GuaranteeExceedStockQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"dutyamount", ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u603b\u989d", (String)"GuaranteeExceedStockQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"ismortgagetype", ResManager.loadKDString((String)"\u662f\u5426\u542b\u62b5\u8d28\u62bc", (String)"GuaranteeContractGuaranteedPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, this.getOrgIds(paramMap));
        allDs = allDs.groupBy(new String[]{"isexceedstock", "isfinance", "guaranteeway"}).sum("amount").sum("dutyamount").finish();
        allDs = this.dealEmptyRow(allDs);
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        allDs = allDs.addField(ismortgageType, "ismortgagetype");
        String props = "isexceedstock,isfinance,guaranteeway,ismortgagetype,amount totalamount,dutyamount,' ' isexceed,case when isexceedstock=true then dutyamount else 0 end as exceedstock,case when isexceedstock=false then dutyamount else 0 end as stockamount";
        allDs = allDs.select(props);
        allDs = allDs.addField("CONCAT(isfinance + ',' +  ismortgagetype)", PARAM);
        String isexceedStr = String.format("case when isexceedstock=true then '%1$s' when isexceedstock=false then '%2$s' end", this.getExceedstock(), this.getStockamount());
        String isfinanceStr = String.format("case when isfinance='finance' then '%1$s' when isfinance='nofinance' then '%2$s' end", GuaranteeReportHelper.getFinanceType(), GuaranteeReportHelper.getNoFinanceType());
        allDs = allDs.updateFields(new String[]{"isexceed", "isfinance"}, new String[]{isexceedStr, isfinanceStr});
        return allDs;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_exceedstocksumrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_exceedstocksumrpt");
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(4);
        customParams.put("exceedstocktype", ids);
        parameter.setCustomParams(customParams);
        this.fireLinkageShowForm(view, parameter);
    }

    @Override
    protected Set<String> getAmountFields() {
        HashSet<String> fields = new HashSet<String>(8);
        fields.add("totalamount");
        fields.add("stockamount");
        fields.add("exceedstock");
        fields.add("dutyamount");
        return fields;
    }

    private String getExceedstock() {
        return ResManager.loadKDString((String)"\u8d85\u80a1\u6bd4", (String)"GuaranteeExceedStockQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private String getStockamount() {
        return ResManager.loadKDString((String)"\u6309\u80a1\u6bd4", (String)"GuaranteeExceedStockQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]);
    }

    private DataSet dealEmptyRow(DataSet ds) {
        List<String> isexceedstock = Arrays.asList("true", "false");
        List<String> isfinance = Arrays.asList("finance", "nofinance");
        List<String> guaranteeway = Arrays.asList(GuaranteeWayEntityEnum.ENSURE.getValue(), GuaranteeWayEntityEnum.ENSUAMT.getValue(), GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        RowMeta rowMeta = ds.getRowMeta();
        for (int i = 0; i < isexceedstock.size(); ++i) {
            for (int j = 0; j < isfinance.size(); ++j) {
                for (int k = 0; k < guaranteeway.size(); ++k) {
                    String filterConditions = String.format("isexceedstock=%1$s and isfinance='%2$s' and guaranteeway='%3$s'", isexceedstock.get(i), isfinance.get(j), guaranteeway.get(k));
                    if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                    DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{isexceedstock.get(i), isfinance.get(j), guaranteeway.get(k), 0.0, 0.0}));
                    ds = ds.union(bizDs);
                }
            }
        }
        return ds;
    }
}

