/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.gm.qing.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.form.IFormView;
import kd.bos.mvc.SessionManager;
import kd.bos.report.ReportShowParameter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.tda.common.enums.GuaranteeWayEntityEnum;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsQingDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.gm.helper.GuaranteeReportHelper;

public class GuaranteeOrgQingDataPlugin
extends AbstractDecisionAnlsQingDataPlugin {
    private static final String ROWID = "rowid";
    private static final String GUARANTEEORG = "guaranteeorg";
    private static String PID = "pid";
    private static String LEVEL = "level";
    private static String ISGROUPNODE = "isgroupnode";
    private static String ISFINANCE = "isfinance";
    private List<String> SUM_FIELDS = Arrays.asList("stockamount", "exceedstock");
    private static final String PARAM = "param";
    private static final String SIMPLENAME = "simplename";

    protected List<Object[]> getColumnItems() {
        LinkedList<Object[]> field = new LinkedList<Object[]>();
        field.add(new Object[]{SIMPLENAME, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7b80\u79f0", (String)"GuaranteeOrgQingDataPlugin_2", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{ISFINANCE, ResManager.loadKDString((String)"\u878d\u8d44\u5206\u7c7b", (String)"GuaranteeOrgQingDataPlugin_3", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"exceedstock", ResManager.loadKDString((String)"\u8d85\u80a1\u6bd4\u62c5\u4fdd", (String)"GuaranteeOrgQingDataPlugin_5", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{"stockamount", ResManager.loadKDString((String)"\u6309\u80a1\u6bd4\u62c5\u4fdd", (String)"GuaranteeOrgQingDataPlugin_6", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.Number.toNumber(), false});
        field.add(new Object[]{PARAM, ResManager.loadKDString((String)"\u53c2\u6570", (String)"GuaranteeOrgQingDataPlugin_8", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        field.add(new Object[]{"ismortgagetype", ResManager.loadKDString((String)"\u662f\u5426\u542b\u62b5\u8d28\u62bc", (String)"GuaranteeContractGuaranteedPlugin_12", (String)"tmc-tda-report", (Object[])new Object[0]), QingFieldType.String.toNumber(), false});
        return field;
    }

    protected DataSet getDataSet(Map<String, Object> paramMap) {
        DataSet allDs = GuaranteeReportHelper.getGuaranteeContractDataSet(paramMap, this.getOrgIds(paramMap));
        allDs = allDs.groupBy(new String[]{"org", "isexceedstock", "isfinance", "guaranteeway"}).sum("dutyamount").finish();
        String ismortgageType = String.format("case when guaranteeway='%1$s' or guaranteeway='%2$s' then 'mortgagetype' else 'ensuretype' end", GuaranteeWayEntityEnum.MORTGAGE.getValue(), GuaranteeWayEntityEnum.PLEDGE.getValue());
        allDs = allDs.addField(ismortgageType, "ismortgagetype");
        allDs = allDs.groupBy(new String[]{"org", "isexceedstock", "isfinance", "ismortgagetype"}).sum("dutyamount").finish();
        String props = "org guaranteeorg,isexceedstock,isfinance,ismortgagetype,case when isexceedstock=true then dutyamount else 0 end as exceedstock,case when isexceedstock=false then dutyamount else 0 end as stockamount";
        allDs = allDs.select(props);
        DataSet[] dataSets = allDs.splitByFilter(new String[]{"isfinance='finance' and ismortgagetype='mortgagetype'", "isfinance='finance' and ismortgagetype='ensuretype'", "isfinance='nofinance' and ismortgagetype='mortgagetype'"}, true);
        DataSet resultDataSet = this.getSetByFinanceType(dataSets[0], "finance", "mortgagetype", paramMap);
        resultDataSet = resultDataSet.union(this.getSetByFinanceType(dataSets[1], "finance", "ensuretype", paramMap));
        resultDataSet = resultDataSet.union(this.getSetByFinanceType(dataSets[2], "nofinance", "mortgagetype", paramMap));
        resultDataSet = resultDataSet.union(this.getSetByFinanceType(dataSets[3], "nofinance", "ensuretype", paramMap));
        resultDataSet = this.addAbsentFinance(resultDataSet);
        resultDataSet = resultDataSet.addField("CONCAT(isfinance + ',' +  ismortgagetype)", PARAM);
        String isfinanceStr = String.format("case when isfinance='finance' then '%1$s' when isfinance='nofinance' then '%2$s' end", GuaranteeReportHelper.getFinanceType(), GuaranteeReportHelper.getNoFinanceType());
        return resultDataSet.updateField("isfinance", isfinanceStr);
    }

    private DataSet addAbsentFinance(DataSet ds) {
        List<String> ismortgagetype = Arrays.asList("mortgagetype", "ensuretype");
        List<String> isfinance = Arrays.asList("finance", "nofinance");
        List simplename = DecisionCommonHelper.getFieldValues((DataSet)ds.copy(), (String)SIMPLENAME, String.class).stream().collect(Collectors.toList());
        RowMeta rowMeta = ds.getRowMeta();
        for (int i = 0; i < ismortgagetype.size(); ++i) {
            for (int j = 0; j < isfinance.size(); ++j) {
                for (int k = 0; k < simplename.size(); ++k) {
                    String filterConditions = String.format("simplename='%1$s' and isfinance='%2$s' and ismortgagetype='%3$s'", simplename.get(k), isfinance.get(j), ismortgagetype.get(i));
                    if (!DecisionAnlsHelper.checkEmptyAndClose(ds.copy().filter(filterConditions))) continue;
                    DataSet bizDs = DecisionAnlsHelper.createRow(((Object)((Object)this)).getClass().getName(), rowMeta.getFieldNames(), rowMeta.getDataTypes(), Collections.singletonList(new Object[]{1, "1", "1", simplename.get(k), isfinance.get(j), ismortgagetype.get(i), 0.0, 0.0}));
                    ds = ds.union(bizDs);
                }
            }
        }
        return ds;
    }

    private DataSet getSetByFinanceType(DataSet allDs, String financeType, String ismortgageType, Map<String, Object> paramMap) {
        Long orgViewid = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long currentOrgId = ((DynamicObject)paramMap.get("org")).getLong("id");
        List subOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewid, (Long)currentOrgId, (boolean)true);
        DataSet allOrgDataSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewid);
        List<String> fieldList = GuaranteeOrgQingDataPlugin.getFieldList();
        fieldList.set(1, String.format("'%s' as isfinance", financeType));
        fieldList.set(2, String.format("'%s' as ismortgagetype", ismortgageType));
        DataSet allDsJoinOrg = allOrgDataSet.leftJoin(allDs).on(ROWID, GUARANTEEORG).select(fieldList.toArray(new String[fieldList.size()])).finish();
        DataSet sumDataSetByLevel = DecisionAnlsHelper.getSumDataSetByLevel(allDsJoinOrg, this.SUM_FIELDS, "simplename,isfinance,ismortgagetype");
        sumDataSetByLevel = CollectionUtils.isEmpty((Collection)subOrgIds) ? DecisionAnlsHelper.createEmptyDataSet(sumDataSetByLevel.getRowMeta().getFieldNames(), sumDataSetByLevel.getRowMeta().getDataTypes()) : sumDataSetByLevel.filter("rowid in orgidparam", Collections.singletonMap("orgidparam", subOrgIds)).filter("stockamount + exceedstock > 0");
        DataSet groupSet = sumDataSetByLevel.groupBy(new String[]{PID, ISGROUPNODE, LEVEL, SIMPLENAME, ISFINANCE, "ismortgagetype"}).sum(this.SUM_FIELDS.get(0)).sum(this.SUM_FIELDS.get(1)).finish();
        return groupSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.SUM_FIELDS);
    }

    private static List<String> getFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(12);
        fieldList.add(ROWID);
        fieldList.add("isfinance isfinance");
        fieldList.add("ismortgagetype ismortgagetype");
        fieldList.add("stockamount stockamount");
        fieldList.add("exceedstock exceedstock");
        fieldList.add("mixorgname simplename");
        fieldList.add(GUARANTEEORG);
        fieldList.add("isgroupnode");
        fieldList.add("level");
        fieldList.add("pid");
        fieldList.add("0 as sumlevel");
        return fieldList;
    }

    @Override
    protected List<String> getLinkReport() {
        return Collections.singletonList("tda_exceedstocksumrpt");
    }

    @Override
    protected String getFormPrimaryKey(String reportId) {
        return PARAM;
    }

    @Override
    public void fireLinkageInfo(List<String> ids, String pageId, String formId, String appId) {
        super.fireLinkageInfo(ids, pageId, formId, appId);
        IFormView view = SessionManager.getCurrent().getView(pageId);
        ReportShowParameter parameter = new ReportShowParameter();
        parameter.setFormId("tda_exceedstocksumrpt");
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>(4);
        customParams.put("exceedstocktype", ids);
        parameter.setCustomParams(customParams);
        parameter.setCaption(ResManager.loadKDString((String)"\u62c5\u4fdd\u8d23\u4efb\u5355\u4f4d\u5206\u5e03\u8868", (String)"GuaranteeOrgQingDataPlugin_7", (String)"tmc-tda-report", (Object[])new Object[0]));
        this.fireLinkageShowForm(view, parameter);
    }
}

