/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.report.interloan.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.helper.DecisionCommonHelper;
import kd.tmc.tda.common.helper.InterCompanyLoansDataHelper;
import kd.tmc.tda.common.helper.MergeOffsetHandler;
import kd.tmc.tda.report.common.data.AbstractDecisionAnlsDataPlugin;
import kd.tmc.tda.report.common.helper.DecisionAnlsHelper;
import kd.tmc.tda.report.interloan.helper.InterLoanParamHelper;

public class InterLoanByCurrencyDataListPlugin
extends AbstractDecisionAnlsDataPlugin {
    protected static final String TMC_TDA_REPORT = "tmc-tda-report";
    protected static final String REPAY_AMOUNT = "repayamount";
    private static final String LEND_TYPE = "lendType";
    private static final String DEBT = "org";
    private static final String REGION = "region";
    private static final String OTHER_ID = "99";
    private static String BUSINESS_PREFIX = "business_";
    private static final String CHANGE_FIELD = "changeField";
    private static String TOTAL = "total";
    private static String OVERSEAS_SUFFIX = "_0";
    private static String DOMESTIC_SUFFIX = "_1";
    private static String TOTAL_SUFFIX = "_2";
    private static String OVERSEAS_TOTAL = BUSINESS_PREFIX + TOTAL + OVERSEAS_SUFFIX;
    private static String DOMESTIC_TOTAL = BUSINESS_PREFIX + TOTAL + DOMESTIC_SUFFIX;
    private static String TOTAL_TOTAL = BUSINESS_PREFIX + TOTAL;
    private List<String> COUNT_FIELDS = new ArrayList<String>();

    @Override
    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        Long baseCurrency = (Long)paramMap.get("basecurrency");
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get(DEBT)).getLong("id");
        String lendType = (String)reportQueryParam.getCustomParam().get(LEND_TYPE);
        if (EmptyUtil.isEmpty((String)lendType)) {
            lendType = DEBT;
        }
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        boolean isDebit = DEBT.equals(lendType);
        String comloanRange = InterLoanParamHelper.getRptComLoanRange(reportQueryParam);
        DataSet interCompanyLoanData = InterCompanyLoansDataHelper.getInterCompanyLoanData((String)this.createAlgoKey(""), (List)((List)paramMap.get("allorgids")), (Date)DecisionAnlsHelper.getQueryDate(paramMap), (Long)baseCurrency, (Long)orgViewId, (Long)orgId, (DataSet)orgDateSet, (boolean)isDebit, (String)comloanRange);
        if (!isDebit) {
            interCompanyLoanData = interCompanyLoanData.updateField(DEBT, lendType);
        }
        interCompanyLoanData = interCompanyLoanData.select(new String[]{DEBT, "currency", REGION, REPAY_AMOUNT, MergeOffsetHandler.ROW_OFFSETFILENAME, MergeOffsetHandler.COL_OFFSETFILENAME});
        return interCompanyLoanData;
    }

    @Override
    protected DataSet filterResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        RowMeta rowMeta = dataSet.getRowMeta();
        if (dataSet.isEmpty()) {
            return DecisionAnlsHelper.createEmptyDataSet(rowMeta);
        }
        Map<Object, DynamicObject> currencyMap = this.getCurrencyMap();
        ArrayList<Object> currencyIds = new ArrayList<Object>(currencyMap.keySet());
        dataSet = dataSet.updateField("currency", "case when currency in (" + DecisionCommonHelper.idListToString(currencyIds) + ") then " + "currency" + " else " + OTHER_ID + "L end");
        dataSet = dataSet.groupBy(new String[]{DEBT, REGION, "currency"}).sum(REPAY_AMOUNT).sum(MergeOffsetHandler.ROW_OFFSETFILENAME).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish();
        Map paramMap = this.transQueryParam(queryParam);
        Long orgViewId = ((DynamicObject)paramMap.get("orgview")).getLong("id");
        Long orgId = ((DynamicObject)paramMap.get(DEBT)).getLong("id");
        DataSet orgDateSet = TmcOrgDataHelper.getOrgDateSet((Long)orgViewId);
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"true", "true"}, false);
        DataSet totalSet = dataSets[1].groupBy(new String[]{DEBT, "currency"}).sum(REPAY_AMOUNT).sum(MergeOffsetHandler.ROW_OFFSETFILENAME).sum(MergeOffsetHandler.COL_OFFSETFILENAME).finish().addField("2", REGION);
        DataSet union = dataSets[0].union(totalSet.select(dataSets[0].getRowMeta().getFieldNames()));
        dataSets = union.splitByFilter(new String[]{"true", "true"}, false);
        DataSet targetSet = dataSets[0].select(new String[]{DEBT, "repayamount+" + MergeOffsetHandler.ROW_OFFSETFILENAME + " as " + "count", "concat(currency, concat('_', region)) as changeField"});
        targetSet = DecisionAnlsHelper.ChangeRowToColDataSet(targetSet, CHANGE_FIELD, DEBT, BUSINESS_PREFIX);
        targetSet = orgDateSet.leftJoin(targetSet).on(DEBT, DEBT).select(new String[]{"rowid", "pid", "isgroupnode", "level", "mixorgname", "sortcode"}, targetSet.getRowMeta().getFieldNames()).finish().addField("0", "sumlevel");
        targetSet = DecisionAnlsHelper.getSumDataSetByLevel(targetSet, this.getCountFields(targetSet), "mixorgname,sortcode");
        DataSet colOffsetSet = this.getColOffsetSet(dataSets[1], orgId, targetSet.getRowMeta());
        DataSet result = targetSet.orderBy(new String[]{"sortcode"}).union(colOffsetSet);
        List subOrgIds = EmptyUtil.isNoEmpty(paramMap.get("suborgids")) ? (List)paramMap.get("suborgids") : (List)paramMap.get("allorgids");
        if (CollectionUtils.isNotEmpty((Collection)subOrgIds)) {
            subOrgIds.add(0L);
            result = result.where("rowid in (" + TmcBusinessBaseHelper.idListToString((List)subOrgIds) + ")");
        }
        List<String> countFields = this.getCountFields(result);
        DataSet totalDataSet = DecisionAnlsHelper.addAllTotalDataSet(result, countFields, "mixorgname");
        List zeroColNames = DecisionCommonHelper.getZeroColNames((DataSet)totalDataSet, countFields);
        result = result.union(totalDataSet);
        if (countFields.size() != zeroColNames.size() && EmptyUtil.isNoEmpty((Object)zeroColNames)) {
            result = result.removeFields(zeroColNames.toArray(new String[0]));
        }
        result = this.addTotalColumns(result);
        return result.addField("mixorgname", "org_name").addField("rowid", "orgid");
    }

    private DataSet getColOffsetSet(DataSet dataSet, Long orgId, RowMeta targetSetRowMeta) {
        dataSet = dataSet.filter(" org != " + orgId).updateField(DEBT, "0L").groupBy(new String[]{DEBT, REGION, "currency"}).sum(MergeOffsetHandler.COL_OFFSETFILENAME, "count").finish().select(new String[]{DEBT, "count", "concat(currency, concat('_',region)) as changeField"});
        dataSet = DecisionAnlsHelper.ChangeRowToColDataSet(dataSet, CHANGE_FIELD, DEBT, BUSINESS_PREFIX);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        Iterator iterator = dataSet.iterator();
        DataSet colOffsetSet = DecisionAnlsHelper.createRowByDefault(targetSetRowMeta.getFieldNames(), targetSetRowMeta.getDataTypes());
        if (iterator.hasNext()) {
            LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
            String offsetName = ResManager.loadKDString((String)"\u5408\u5e76\u62b5\u6d88", (String)"CashDistributionByAreaDataListPlugin_3", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
            Row next = (Row)iterator.next();
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                if (DEBT.equals(fieldName)) continue;
                BigDecimal value = Objects.nonNull(next.getBigDecimal(fieldName)) ? next.getBigDecimal(fieldName) : BigDecimal.ZERO;
                valueMap.put(fieldNames[i], value.toPlainString());
            }
            valueMap.put("mixorgname", "'" + offsetName + "'");
            colOffsetSet = colOffsetSet.updateFields(valueMap.keySet().toArray(new String[0]), valueMap.values().toArray(new String[0]));
        }
        return colOffsetSet;
    }

    @Override
    protected Set<String> getAmountFields() {
        return new HashSet<String>(this.COUNT_FIELDS);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        Map<Object, DynamicObject> currrencyMap = this.getCurrencyMap();
        ReportColumnGroup domesticGroup = this.createReportColumnGroup(columns, "domestic_group", new LocaleString(ResManager.loadKDString((String)"\u5883\u5185", (String)"InterLoanByCurrencyDataListPlugin_0", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
        ReportColumnGroup overseasGroup = this.createReportColumnGroup(columns, "overseas_group", new LocaleString(ResManager.loadKDString((String)"\u5883\u5916", (String)"InterLoanByCurrencyDataListPlugin_1", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
        ReportColumnGroup totalGroup = this.createReportColumnGroup(columns, "total_group", new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InterLoanByCurrencyDataListPlugin_2", (String)TMC_TDA_REPORT, (Object[])new Object[0])));
        List<String> collect = this.COUNT_FIELDS.stream().sorted(Comparator.comparing(s -> s.split("_")[1])).collect(Collectors.toList());
        collect.forEach(fieldName -> {
            if (fieldName.startsWith(BUSINESS_PREFIX)) {
                String currencyName = "";
                if (fieldName.contains(TOTAL)) {
                    currencyName = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"InterLoanByCurrencyDataListPlugin_2", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
                } else {
                    String[] names = fieldName.split("_");
                    String productIdStr = names[1];
                    if (OTHER_ID.equals(productIdStr)) {
                        currencyName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InterLoanByCurrencyDataListPlugin_3", (String)TMC_TDA_REPORT, (Object[])new Object[0]);
                    } else {
                        Long productId = Long.valueOf(productIdStr);
                        DynamicObject product = (DynamicObject)currrencyMap.get(productId);
                        if (Objects.nonNull(product)) {
                            currencyName = product.getString("name");
                        }
                    }
                }
                if (fieldName.endsWith(DOMESTIC_SUFFIX)) {
                    domesticGroup.getChildren().add(this.createColumn((String)fieldName, currencyName));
                } else if (fieldName.endsWith(OVERSEAS_SUFFIX)) {
                    overseasGroup.getChildren().add(this.createColumn((String)fieldName, currencyName));
                } else {
                    totalGroup.getChildren().add(this.createColumn((String)fieldName, currencyName));
                }
            }
        });
        return columns;
    }

    private ReportColumnGroup createReportColumnGroup(List<AbstractReportColumn> columns, String fieldKey, LocaleString caption) {
        ReportColumnGroup reportColumnGroup = new ReportColumnGroup();
        reportColumnGroup.setFieldKey(fieldKey);
        reportColumnGroup.setCaption(caption);
        reportColumnGroup.setHideSingleColumnRow(true);
        columns.add((AbstractReportColumn)reportColumnGroup);
        return reportColumnGroup;
    }

    private ReportColumn createColumn(String fieldKey, String caption) {
        ReportColumn reportColumn = new ReportColumn();
        reportColumn.setFieldKey(fieldKey);
        reportColumn.setFieldType("decimal");
        reportColumn.setZeroShow(true);
        reportColumn.setScale(2);
        reportColumn.setCaption(new LocaleString(caption));
        reportColumn.setWidth(new LocaleString("100px"));
        reportColumn.setHideSingleColumnRow(false);
        return reportColumn;
    }

    private DataSet addTotalColumns(DataSet dataSet) {
        List<String> countFields = this.getCountFields(dataSet);
        LinkedHashMap<String, String> fieldsMap = new LinkedHashMap<String, String>(4);
        this.setTotalColumnMap(fieldsMap, countFields, DOMESTIC_SUFFIX, DOMESTIC_TOTAL);
        this.setTotalColumnMap(fieldsMap, countFields, OVERSEAS_SUFFIX, OVERSEAS_TOTAL);
        this.setTotalColumnMap(fieldsMap, countFields, TOTAL_SUFFIX, TOTAL_TOTAL);
        dataSet = dataSet.addFields(fieldsMap.values().toArray(new String[0]), fieldsMap.keySet().toArray(new String[0]));
        this.COUNT_FIELDS.clear();
        this.COUNT_FIELDS = this.getCountFields(dataSet);
        return dataSet;
    }

    private void setTotalColumnMap(Map<String, String> fieldsMap, List<String> countFields, String fieldSuffix, String fieldName) {
        List totalFields = countFields.stream().filter(s -> s.endsWith(fieldSuffix)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(totalFields)) {
            fieldsMap.put(fieldName, String.join((CharSequence)"+", totalFields));
        }
    }

    public List<String> getCountFields(DataSet dataSet) {
        return Arrays.stream(dataSet.getRowMeta().getFieldNames()).filter(fieldName -> fieldName.startsWith(BUSINESS_PREFIX)).sorted(Comparator.comparing(fieldName -> fieldName.substring(fieldName.length() - 1))).collect(Collectors.toList());
    }

    private Map<Object, DynamicObject> getCurrencyMap() {
        return BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)String.join((CharSequence)",", "id", "number", "name"), (QFilter[])new QFilter("number", "in", Arrays.asList("CNY", "HKD", "USD")).toArray());
    }
}

